/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.cmd;

import java.io.IOException;
import org.rrd4j.cmd.RrdCmdScanner;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDbPool;
import org.rrd4j.core.RrdDef;

abstract class RrdToolCmd {
    private RrdCmdScanner cmdScanner;
    static boolean rrdDbPoolUsed = true;
    static boolean standardOutUsed = true;

    RrdToolCmd() {
    }

    abstract String getCmdType();

    abstract Object execute() throws IOException;

    Object executeCommand(String string) throws IOException {
        this.cmdScanner = new RrdCmdScanner(string);
        return this.execute();
    }

    String getOptionValue(String string, String string2) {
        return this.cmdScanner.getOptionValue(string, string2);
    }

    String getOptionValue(String string, String string2, String string3) {
        return this.cmdScanner.getOptionValue(string, string2, string3);
    }

    String[] getMultipleOptionValues(String string, String string2) {
        return this.cmdScanner.getMultipleOptions(string, string2);
    }

    boolean getBooleanOption(String string, String string2) {
        return this.cmdScanner.getBooleanOption(string, string2);
    }

    String[] getRemainingWords() {
        return this.cmdScanner.getRemainingWords();
    }

    static boolean isRrdDbPoolUsed() {
        return rrdDbPoolUsed;
    }

    static void setRrdDbPoolUsed(boolean bl) {
        rrdDbPoolUsed = bl;
    }

    static boolean isStandardOutUsed() {
        return standardOutUsed;
    }

    static void setStandardOutUsed(boolean bl) {
        standardOutUsed = bl;
    }

    static long parseLong(String string) {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(numberFormatException);
        }
    }

    static int parseInt(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(numberFormatException);
        }
    }

    static double parseDouble(String string) {
        if (string.equals("U")) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(numberFormatException);
        }
    }

    static void print(String string) {
        if (standardOutUsed) {
            System.out.print(string);
        }
    }

    static void println(String string) {
        if (standardOutUsed) {
            System.out.println(string);
        }
    }

    static RrdDb getRrdDbReference(String string) throws IOException {
        if (rrdDbPoolUsed) {
            return RrdDbPool.getInstance().requestRrdDb(string);
        }
        return new RrdDb(string);
    }

    static RrdDb getRrdDbReference(String string, String string2) throws IOException {
        if (rrdDbPoolUsed) {
            return RrdDbPool.getInstance().requestRrdDb(string, string2);
        }
        return new RrdDb(string, string2);
    }

    static RrdDb getRrdDbReference(RrdDef rrdDef) throws IOException {
        if (rrdDbPoolUsed) {
            return RrdDbPool.getInstance().requestRrdDb(rrdDef);
        }
        return new RrdDb(rrdDef);
    }

    static void releaseRrdDbReference(RrdDb rrdDb) throws IOException {
        if (rrdDbPoolUsed) {
            RrdDbPool.getInstance().release(rrdDb);
        } else {
            rrdDb.close();
        }
    }
}

