/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.codec.filebuffer;

import de.huxhorn.sulky.codec.filebuffer.MetaData;

public class FileHeader {
    private int magicValue;
    private MetaData metaData;
    private long dataOffset;

    public FileHeader(int magicValue, MetaData metaData, long dataOffset) {
        this.magicValue = magicValue;
        this.metaData = metaData;
        this.dataOffset = dataOffset;
    }

    public long getDataOffset() {
        return this.dataOffset;
    }

    public int getMagicValue() {
        return this.magicValue;
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileHeader that = (FileHeader)o;
        if (this.dataOffset != that.dataOffset) {
            return false;
        }
        if (this.magicValue != that.magicValue) {
            return false;
        }
        return !(this.metaData != null ? !this.metaData.equals(that.metaData) : that.metaData != null);
    }

    public int hashCode() {
        int result = this.magicValue;
        result = 31 * result + (this.metaData != null ? this.metaData.hashCode() : 0);
        result = 31 * result + (int)(this.dataOffset ^ this.dataOffset >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("FileHeader[");
        result.append("magicValue=");
        result.append("0x");
        String hexValue = Integer.toHexString(this.magicValue);
        int zeroes = 8 - hexValue.length();
        for (int i = 0; i < zeroes; ++i) {
            result.append("0");
        }
        result.append(hexValue);
        result.append(", ");
        result.append("metaData=").append(this.metaData);
        result.append(", ");
        result.append("dataOffset=").append(this.dataOffset);
        result.append("]");
        return result.toString();
    }
}

