/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageFormatter {
    private static final char DELIM_START = '{';
    private static final char DELIM_STOP = '}';
    private static final char ESCAPE_CHAR = '\\';
    public static final String RECURSION_PREFIX = "[...";
    public static final String RECURSION_SUFFIX = "...]";
    public static final String ERROR_PREFIX = "[!!!";
    public static final String ERROR_SEPARATOR = "=>";
    public static final String ERROR_MSG_SEPARATOR = ":";
    public static final String ERROR_SUFFIX = "!!!]";

    public static String format(String messagePattern, String[] arguments) {
        if (messagePattern == null || arguments == null || arguments.length == 0) {
            return messagePattern;
        }
        StringBuilder result = new StringBuilder();
        int escapeCounter = 0;
        int currentArgument = 0;
        for (int i = 0; i < messagePattern.length(); ++i) {
            char curChar = messagePattern.charAt(i);
            if (curChar == '\\') {
                ++escapeCounter;
                continue;
            }
            if (curChar == '{' && i < messagePattern.length() - 1 && messagePattern.charAt(i + 1) == '}') {
                int escapedEscapes = escapeCounter / 2;
                for (int j = 0; j < escapedEscapes; ++j) {
                    result.append('\\');
                }
                if (escapeCounter % 2 == 1) {
                    result.append('{');
                    result.append('}');
                } else {
                    if (currentArgument < arguments.length) {
                        result.append(arguments[currentArgument]);
                    } else {
                        result.append('{').append('}');
                    }
                    ++currentArgument;
                }
                ++i;
                escapeCounter = 0;
                continue;
            }
            if (escapeCounter > 0) {
                for (int j = 0; j < escapeCounter; ++j) {
                    result.append('\\');
                }
                escapeCounter = 0;
            }
            result.append(curChar);
        }
        return result.toString();
    }

    public static int countArgumentPlaceholders(String messagePattern) {
        if (messagePattern == null) {
            return 0;
        }
        int delim = messagePattern.indexOf(123);
        if (delim == -1) {
            return 0;
        }
        int result = 0;
        boolean isEscaped = false;
        for (int i = 0; i < messagePattern.length(); ++i) {
            char curChar = messagePattern.charAt(i);
            if (curChar == '\\') {
                isEscaped = !isEscaped;
                continue;
            }
            if (curChar == '{') {
                if (!isEscaped && i < messagePattern.length() - 1 && messagePattern.charAt(i + 1) == '}') {
                    ++result;
                    ++i;
                }
                isEscaped = false;
                continue;
            }
            isEscaped = false;
        }
        return result;
    }

    public static ArgumentResult evaluateArguments(String messagePattern, Object[] arguments) {
        String[] stringArgs;
        if (arguments == null) {
            return null;
        }
        int argsCount = MessageFormatter.countArgumentPlaceholders(messagePattern);
        int resultArgCount = arguments.length;
        Throwable throwable = null;
        if (argsCount < arguments.length && arguments[arguments.length - 1] instanceof Throwable) {
            throwable = (Throwable)arguments[arguments.length - 1];
            --resultArgCount;
        }
        if (argsCount == 1 && throwable == null && arguments.length > 1) {
            stringArgs = new String[]{MessageFormatter.deepToString(arguments)};
        } else {
            stringArgs = new String[resultArgCount];
            for (int i = 0; i < stringArgs.length; ++i) {
                stringArgs[i] = MessageFormatter.deepToString(arguments[i]);
            }
        }
        return new ArgumentResult(stringArgs, throwable);
    }

    public static String deepToString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        StringBuilder str = new StringBuilder();
        HashSet<String> dejaVu = new HashSet<String>();
        MessageFormatter.recursiveDeepToString(o, str, dejaVu);
        return str.toString();
    }

    private static void recursiveDeepToString(Object o, StringBuilder str, Set<String> dejaVu) {
        if (o == null) {
            str.append("null");
            return;
        }
        if (o instanceof String) {
            str.append(o);
            return;
        }
        Class<?> oClass = o.getClass();
        if (oClass.isArray()) {
            if (oClass == byte[].class) {
                str.append(Arrays.toString((byte[])o));
            } else if (oClass == short[].class) {
                str.append(Arrays.toString((short[])o));
            } else if (oClass == int[].class) {
                str.append(Arrays.toString((int[])o));
            } else if (oClass == long[].class) {
                str.append(Arrays.toString((long[])o));
            } else if (oClass == float[].class) {
                str.append(Arrays.toString((float[])o));
            } else if (oClass == double[].class) {
                str.append(Arrays.toString((double[])o));
            } else if (oClass == boolean[].class) {
                str.append(Arrays.toString((boolean[])o));
            } else if (oClass == char[].class) {
                str.append(Arrays.toString((char[])o));
            } else {
                String id = MessageFormatter.identityToString(o);
                if (dejaVu.contains(id)) {
                    str.append(RECURSION_PREFIX).append(id).append(RECURSION_SUFFIX);
                } else {
                    dejaVu.add(id);
                    Object[] oArray = (Object[])o;
                    str.append("[");
                    boolean first = true;
                    for (Object current : oArray) {
                        if (first) {
                            first = false;
                        } else {
                            str.append(", ");
                        }
                        MessageFormatter.recursiveDeepToString(current, str, new HashSet<String>(dejaVu));
                    }
                    str.append("]");
                }
            }
        } else if (o instanceof Map) {
            String id = MessageFormatter.identityToString(o);
            if (dejaVu.contains(id)) {
                str.append(RECURSION_PREFIX).append(id).append(RECURSION_SUFFIX);
            } else {
                dejaVu.add(id);
                Map oMap = (Map)o;
                str.append("{");
                boolean isFirst = true;
                for (Map.Entry current : oMap.entrySet()) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        str.append(", ");
                    }
                    Object key = current.getKey();
                    Object value = current.getValue();
                    MessageFormatter.recursiveDeepToString(key, str, new HashSet<String>(dejaVu));
                    str.append("=");
                    MessageFormatter.recursiveDeepToString(value, str, new HashSet<String>(dejaVu));
                }
                str.append("}");
            }
        } else if (o instanceof Collection) {
            String id = MessageFormatter.identityToString(o);
            if (dejaVu.contains(id)) {
                str.append(RECURSION_PREFIX).append(id).append(RECURSION_SUFFIX);
            } else {
                dejaVu.add(id);
                Collection oCol = (Collection)o;
                str.append("[");
                boolean isFirst = true;
                for (Object current : oCol) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        str.append(", ");
                    }
                    MessageFormatter.recursiveDeepToString(current, str, new HashSet<String>(dejaVu));
                }
                str.append("]");
            }
        } else if (o instanceof Date) {
            Date date = (Date)o;
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            str.append(format.format(date));
        } else {
            try {
                str.append(o.toString());
            }
            catch (Throwable t) {
                str.append(ERROR_PREFIX);
                str.append(MessageFormatter.identityToString(o));
                str.append(ERROR_SEPARATOR);
                String msg = t.getMessage();
                String className = t.getClass().getName();
                str.append(className);
                if (!className.equals(msg)) {
                    str.append(ERROR_MSG_SEPARATOR);
                    str.append(msg);
                }
                str.append(ERROR_SUFFIX);
            }
        }
    }

    public static String identityToString(Object obj) {
        if (obj == null) {
            return null;
        }
        return obj.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(obj));
    }

    public static class ArgumentResult {
        private Throwable throwable;
        private String[] arguments;

        public ArgumentResult(String[] arguments, Throwable throwable) {
            this.throwable = throwable;
            this.arguments = arguments;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public String[] getArguments() {
            return this.arguments;
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            result.append("ArgumentResult[throwable=").append(this.throwable);
            result.append(", arguments=");
            if (this.arguments != null) {
                result.append("[");
                boolean isFirst = true;
                for (String current : this.arguments) {
                    if (!isFirst) {
                        result.append(", ");
                    } else {
                        isFirst = false;
                    }
                    if (current != null) {
                        result.append("'").append(current).append("'");
                        continue;
                    }
                    result.append("null");
                }
                result.append("]");
            }
            return result.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArgumentResult result = (ArgumentResult)o;
            if (!Arrays.equals(this.arguments, result.arguments)) {
                return false;
            }
            return !(this.throwable != null ? !this.throwable.equals(result.throwable) : result.throwable != null);
        }

        public int hashCode() {
            int result = this.throwable != null ? this.throwable.hashCode() : 0;
            result = 31 * result + (this.arguments != null ? Arrays.hashCode(this.arguments) : 0);
            return result;
        }
    }
}

