/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging;

import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import de.huxhorn.lilith.data.logging.LoggerContext;
import de.huxhorn.lilith.data.logging.Marker;
import de.huxhorn.lilith.data.logging.Message;
import de.huxhorn.lilith.data.logging.ThreadInfo;
import de.huxhorn.lilith.data.logging.ThrowableInfo;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingEvent
implements Serializable {
    private static final long serialVersionUID = -5298580552977499507L;
    private String logger;
    private Level level;
    private ThreadInfo threadInfo;
    private LoggerContext loggerContext;
    private Long timeStamp;
    private Long sequenceNumber;
    private ThrowableInfo throwable;
    private Map<String, String> mdc;
    private Message[] ndc;
    private Marker marker;
    private ExtendedStackTraceElement[] callStack;
    private Message message;

    public String getLogger() {
        return this.logger;
    }

    public void setLogger(String logger) {
        this.logger = logger;
    }

    public ThreadInfo getThreadInfo() {
        return this.threadInfo;
    }

    public void setThreadInfo(ThreadInfo threadInfo) {
        this.threadInfo = threadInfo;
    }

    public Long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(Long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public LoggerContext getLoggerContext() {
        return this.loggerContext;
    }

    public void setLoggerContext(LoggerContext loggerContext) {
        this.loggerContext = loggerContext;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public Long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(Long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public ThrowableInfo getThrowable() {
        return this.throwable;
    }

    public void setThrowable(ThrowableInfo throwable) {
        this.throwable = throwable;
    }

    public Map<String, String> getMdc() {
        return this.mdc;
    }

    public void setMdc(Map<String, String> mdc) {
        this.mdc = mdc;
    }

    public Message[] getNdc() {
        return this.ndc;
    }

    public void setNdc(Message[] ndc) {
        this.ndc = ndc;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public void setMarker(Marker marker) {
        this.marker = marker;
    }

    public ExtendedStackTraceElement[] getCallStack() {
        return this.callStack;
    }

    public void setCallStack(ExtendedStackTraceElement[] callStack) {
        this.callStack = callStack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoggingEvent event = (LoggingEvent)o;
        if (this.level != event.level) {
            return false;
        }
        if (this.sequenceNumber != null ? !this.sequenceNumber.equals(event.sequenceNumber) : event.sequenceNumber != null) {
            return false;
        }
        if (this.timeStamp != null ? !this.timeStamp.equals(event.timeStamp) : event.timeStamp != null) {
            return false;
        }
        if (this.logger != null ? !this.logger.equals(event.logger) : event.logger != null) {
            return false;
        }
        if (this.loggerContext != null ? !this.loggerContext.equals(event.loggerContext) : event.loggerContext != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(event.message) : event.message != null) {
            return false;
        }
        if (this.threadInfo != null ? !this.threadInfo.equals(event.threadInfo) : event.threadInfo != null) {
            return false;
        }
        if (!Arrays.equals(this.callStack, event.callStack)) {
            return false;
        }
        if (this.marker != null ? !this.marker.equals(event.marker) : event.marker != null) {
            return false;
        }
        if (this.mdc != null ? !((Object)this.mdc).equals(event.mdc) : event.mdc != null) {
            return false;
        }
        if (!Arrays.equals(this.ndc, event.ndc)) {
            return false;
        }
        return !(this.throwable != null ? !this.throwable.equals(event.throwable) : event.throwable != null);
    }

    public int hashCode() {
        int result = this.logger != null ? this.logger.hashCode() : 0;
        result = 31 * result + (this.sequenceNumber != null ? this.sequenceNumber.hashCode() : 0);
        result = 31 * result + (this.level != null ? this.level.hashCode() : 0);
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.timeStamp != null ? this.timeStamp.hashCode() : 0);
        result = 31 * result + (this.threadInfo != null ? this.threadInfo.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("LoggingEvent[");
        result.append("logger=").append(this.logger).append(", ");
        result.append("level=").append((Object)this.level).append(", ");
        result.append("message=").append(this.message).append(", ");
        result.append("threadInfo=").append(this.threadInfo).append(", ");
        result.append("loggerContext=").append(this.loggerContext).append(", ");
        result.append("sequenceNumber=").append(this.sequenceNumber).append(", ");
        result.append("timeStamp=").append(this.timeStamp);
        result.append("]");
        return result.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

