/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.access.protobuf;

import de.huxhorn.lilith.data.access.AccessEvent;
import de.huxhorn.lilith.data.access.protobuf.AccessEventProtobufEncoder;
import de.huxhorn.lilith.data.access.protobuf.generated.AccessProto;
import de.huxhorn.lilith.data.eventsource.EventIdentifier;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.sulky.codec.Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessEventWrapperProtobufEncoder
implements Encoder<EventWrapper<AccessEvent>> {
    private boolean compressing;

    public AccessEventWrapperProtobufEncoder(boolean compressing) {
        this.compressing = compressing;
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
    }

    public byte[] encode(EventWrapper<AccessEvent> wrapper) {
        AccessProto.EventWrapper converted = AccessEventWrapperProtobufEncoder.convert(wrapper);
        if (converted == null) {
            return null;
        }
        if (!this.compressing) {
            return converted.toByteArray();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gos = new GZIPOutputStream(out);
            converted.writeTo(gos);
            gos.flush();
            gos.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static AccessProto.EventWrapper convert(EventWrapper<AccessEvent> wrapper) {
        AccessEvent event;
        if (wrapper == null) {
            return null;
        }
        AccessProto.EventWrapper.Builder builder = AccessProto.EventWrapper.newBuilder();
        EventIdentifier eventId = wrapper.getEventIdentifier();
        if (eventId != null) {
            builder.setEventIdentifier(AccessEventWrapperProtobufEncoder.convert(eventId));
        }
        if ((event = (AccessEvent)wrapper.getEvent()) != null) {
            builder.setEvent(AccessEventProtobufEncoder.convert(event));
        }
        return builder.build();
    }

    public static AccessProto.EventIdentifier convert(EventIdentifier eventId) {
        if (eventId == null) {
            return null;
        }
        AccessProto.EventIdentifier.Builder builder = AccessProto.EventIdentifier.newBuilder();
        SourceIdentifier sourceId = eventId.getSourceIdentifier();
        if (sourceId != null) {
            builder.setSourceIdentifier(AccessEventWrapperProtobufEncoder.convert(sourceId));
        }
        builder.setLocalId(eventId.getLocalId());
        return builder.build();
    }

    public static AccessProto.SourceIdentifier convert(SourceIdentifier sourceId) {
        if (sourceId == null) {
            return null;
        }
        AccessProto.SourceIdentifier.Builder builder = AccessProto.SourceIdentifier.newBuilder();
        String identifier = sourceId.getIdentifier();
        if (identifier != null) {
            builder.setIdentifier(identifier);
        }
        if ((identifier = sourceId.getSecondaryIdentifier()) != null) {
            builder.setSecondaryIdentifier(identifier);
        }
        return builder.build();
    }
}

