/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.access.protobuf;

import com.google.protobuf.GeneratedMessage;
import de.huxhorn.lilith.data.access.AccessEvent;
import de.huxhorn.lilith.data.access.LoggerContext;
import de.huxhorn.lilith.data.access.protobuf.generated.AccessProto;
import de.huxhorn.sulky.codec.Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessEventProtobufEncoder
implements Encoder<AccessEvent> {
    private boolean compressing;

    public AccessEventProtobufEncoder(boolean compressing) {
        this.compressing = compressing;
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
    }

    public byte[] encode(AccessEvent event) {
        AccessProto.AccessEvent converted = AccessEventProtobufEncoder.convert(event);
        if (converted == null) {
            return null;
        }
        if (!this.compressing) {
            return converted.toByteArray();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gos = new GZIPOutputStream(out);
            converted.writeTo(gos);
            gos.flush();
            gos.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static AccessProto.AccessEvent convert(AccessEvent event) {
        LoggerContext context;
        Long ts;
        String name;
        String url;
        String uri;
        String user;
        String host;
        String address;
        String protocol;
        if (event == null) {
            return null;
        }
        AccessProto.AccessEvent.Builder eventBuilder = AccessProto.AccessEvent.newBuilder();
        String method = event.getMethod();
        if (method != null) {
            eventBuilder.setMethod(method);
        }
        if ((protocol = event.getProtocol()) != null) {
            eventBuilder.setProtocol(protocol);
        }
        if ((address = event.getRemoteAddress()) != null) {
            eventBuilder.setRemoteAddress(address);
        }
        if ((host = event.getRemoteHost()) != null) {
            eventBuilder.setRemoteHost(host);
        }
        if ((user = event.getRemoteUser()) != null) {
            eventBuilder.setRemoteUser(user);
        }
        if ((uri = event.getRequestURI()) != null) {
            eventBuilder.setRequestUri(uri);
        }
        if ((url = event.getRequestURL()) != null) {
            eventBuilder.setRequestUrl(url);
        }
        if ((url = event.getRequestURL()) != null) {
            eventBuilder.setRequestUrl(url);
        }
        if ((name = event.getServerName()) != null) {
            eventBuilder.setServerName(name);
        }
        if ((ts = event.getTimeStamp()) != null) {
            eventBuilder.setTimeStamp(ts);
        }
        int port = event.getLocalPort();
        eventBuilder.setLocalPort(port);
        int status = event.getStatusCode();
        eventBuilder.setStatusCode(status);
        GeneratedMessage data = AccessEventProtobufEncoder.convertStringMap(event.getRequestHeaders());
        if (data != null) {
            eventBuilder.setRequestHeaders((AccessProto.StringMap)data);
        }
        if ((data = AccessEventProtobufEncoder.convertStringMap(event.getResponseHeaders())) != null) {
            eventBuilder.setResponseHeaders((AccessProto.StringMap)data);
        }
        if ((data = AccessEventProtobufEncoder.convertStringArrayMap(event.getRequestParameters())) != null) {
            eventBuilder.setRequestParameters((AccessProto.StringArrayMap)data);
        }
        if ((context = event.getLoggerContext()) != null) {
            eventBuilder.setLoggerContext(AccessEventProtobufEncoder.convert(context));
        }
        return eventBuilder.build();
    }

    public static AccessProto.LoggerContext convert(LoggerContext context) {
        Map map;
        Date birthTime;
        if (context == null) {
            return null;
        }
        AccessProto.LoggerContext.Builder builder = AccessProto.LoggerContext.newBuilder();
        String name = context.getName();
        if (name != null) {
            builder.setName(name);
        }
        if ((birthTime = context.getBirthTime()) != null) {
            builder.setBirthTime(birthTime.getTime());
        }
        if ((map = context.getProperties()) != null && map.size() > 0) {
            builder.setProperties(AccessEventProtobufEncoder.convertStringMap(map));
        }
        return builder.build();
    }

    public static AccessProto.StringMap convertStringMap(Map<String, String> data) {
        if (data == null) {
            return null;
        }
        AccessProto.StringMap.Builder builder = AccessProto.StringMap.newBuilder();
        for (Map.Entry<String, String> current : data.entrySet()) {
            AccessProto.StringMapEntry.Builder entryBuilder = AccessProto.StringMapEntry.newBuilder().setKey(current.getKey());
            String value = current.getValue();
            if (value != null) {
                entryBuilder.setValue(value);
            }
            builder.addEntry(entryBuilder.build());
        }
        return builder.build();
    }

    public static AccessProto.StringArrayMap convertStringArrayMap(Map<String, String[]> data) {
        if (data == null) {
            return null;
        }
        AccessProto.StringArrayMap.Builder builder = AccessProto.StringArrayMap.newBuilder();
        for (Map.Entry<String, String[]> current : data.entrySet()) {
            AccessProto.StringArrayMapEntry.Builder entryBuilder = AccessProto.StringArrayMapEntry.newBuilder().setKey(current.getKey());
            String[] value = current.getValue();
            if (value != null && value.length > 0) {
                for (String cur : value) {
                    AccessProto.StringArrayValue.Builder valBuilder = AccessProto.StringArrayValue.newBuilder();
                    if (cur != null) {
                        valBuilder.setValue(cur);
                    }
                    entryBuilder.addValue(valBuilder.build());
                }
            }
            builder.addEntry(entryBuilder.build());
        }
        return builder.build();
    }
}

