/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.transfer;

import de.huxhorn.lilith.swing.MainFrame;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.TransferHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainFrameTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 6201602937026372558L;
    private final Logger logger = LoggerFactory.getLogger(MainFrameTransferHandler.class);
    protected MainFrame mainFrame;
    protected JDesktopPane desktop;

    public MainFrameTransferHandler(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.desktop = mainFrame.getDesktop();
    }

    public void attach() {
        this.desktop.setTransferHandler(this);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Attached transfer handler to desktop.");
        }
    }

    public boolean importData(JComponent comp, Transferable transferable) {
        return this.canImport(comp, transferable.getTransferDataFlavors()) && this.importData(transferable);
    }

    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        if (comp != this.desktop) {
            return false;
        }
        if (transferFlavors != null) {
            for (DataFlavor current : transferFlavors) {
                if (!DataFlavor.javaFileListFlavor.equals(current)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean importData(Transferable transferable) {
        if (!transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            return false;
        }
        try {
            List l = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
            for (Object o : l) {
                if (!(o instanceof File)) continue;
                File file = (File)o;
                String fileName = file.getAbsolutePath();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Checking file '{}'...", (Object)fileName);
                }
                if (!fileName.toLowerCase().endsWith(".lilith")) continue;
                this.mainFrame.open(file);
            }
        }
        catch (UnsupportedFlavorException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

