/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import de.huxhorn.lilith.engine.EventSource;
import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.ViewManager;
import de.huxhorn.lilith.swing.preferences.PreferencesDialog;
import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.buffers.Reset;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TroubleshootingPanel
extends JPanel {
    private PreferencesDialog preferencesDialog;

    public TroubleshootingPanel(PreferencesDialog preferencesDialog) {
        this.preferencesDialog = preferencesDialog;
        this.createUI();
    }

    private void createUI() {
        this.add(new JButton(new InitDetailsViewAction()));
        this.add(new JButton(new InitExampleScriptsAction()));
        this.add(new JButton(new DeleteAllLogsAction()));
    }

    public static void reset(ViewContainer<?> container) {
        if (container == null) {
            return;
        }
        EventSource<?> eventSource = container.getEventSource();
        if (eventSource == null) {
            return;
        }
        Buffer buffer = eventSource.getBuffer();
        Reset.reset((Object)buffer);
    }

    public class DeleteAllLogsAction
    extends AbstractAction {
        private static final long serialVersionUID = 5218712842261152334L;

        public DeleteAllLogsAction() {
            super("Delete *all* logs.");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String dialogTitle = "Delete all log files?";
            String message = "This deletes *all* log files, even the Lilith logs and the global logs!\nDelete all log files right now?";
            int result = JOptionPane.showConfirmDialog(TroubleshootingPanel.this.preferencesDialog, message, dialogTitle, 2, 3);
            if (0 != result) {
                return;
            }
            MainFrame mainFrame = TroubleshootingPanel.this.preferencesDialog.getMainFrame();
            ViewManager levm = mainFrame.getLoggingEventViewManager();
            Map views = levm.getViews();
            for (Map.Entry current : views.entrySet()) {
                TroubleshootingPanel.reset(current.getValue());
            }
            levm = mainFrame.getAccessEventViewManager();
            views = levm.getViews();
            for (Map.Entry current : views.entrySet()) {
                TroubleshootingPanel.reset(current.getValue());
            }
            mainFrame.cleanAllInactiveLogs();
        }
    }

    public class InitExampleScriptsAction
    extends AbstractAction {
        private static final long serialVersionUID = -4197531497673863904L;

        public InitExampleScriptsAction() {
            super("Reinitialize example groovy conditions.");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String dialogTitle = "Reinitialize example groovy conditions?";
            String message = "This overwrites all example groovy conditions. Other conditions are not changed!\nReinitialize example groovy conditions right now?";
            int result = JOptionPane.showConfirmDialog(TroubleshootingPanel.this.preferencesDialog, message, dialogTitle, 2, 3);
            if (0 != result) {
                return;
            }
            ApplicationPreferences prefs = TroubleshootingPanel.this.preferencesDialog.getApplicationPreferences();
            prefs.installExampleConditions();
        }
    }

    public class InitDetailsViewAction
    extends AbstractAction {
        private static final long serialVersionUID = 8374235720899930441L;

        public InitDetailsViewAction() {
            super("Reinitialize details view files.");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String dialogTitle = "Reinitialize details view files?";
            String message = "This resets all details view related files, all manual changes will be lost!\nReinitialize details view right now?";
            int result = JOptionPane.showConfirmDialog(TroubleshootingPanel.this.preferencesDialog, message, dialogTitle, 2, 3);
            if (0 != result) {
                return;
            }
            ApplicationPreferences prefs = TroubleshootingPanel.this.preferencesDialog.getApplicationPreferences();
            prefs.initDetailsViewRoot(true);
        }
    }
}

