/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.preferences.PreferencesDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class StartupShutdownPanel
extends JPanel {
    private PreferencesDialog preferencesDialog;
    private ApplicationPreferences applicationPreferences;
    private JCheckBox showSplashCheckbox;
    private JCheckBox checkForUpdateCheckbox;
    private JCheckBox askBeforeQuitCheckbox;
    private JCheckBox cleaningLogsOnExitCheckbox;

    public StartupShutdownPanel(PreferencesDialog preferencesDialog) {
        this.preferencesDialog = preferencesDialog;
        this.applicationPreferences = preferencesDialog.getApplicationPreferences();
        this.createUI();
    }

    private void createUI() {
        this.showSplashCheckbox = new JCheckBox("Show splash screen.");
        this.checkForUpdateCheckbox = new JCheckBox("Check for updates on startup.");
        this.askBeforeQuitCheckbox = new JCheckBox("Ask before exit.");
        this.cleaningLogsOnExitCheckbox = new JCheckBox("Clean logs on exit.");
        JPanel startupPanel = new JPanel(new GridLayout(2, 1));
        startupPanel.add(this.showSplashCheckbox);
        startupPanel.add(this.checkForUpdateCheckbox);
        startupPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Startup"));
        JPanel shutdownPanel = new JPanel(new GridLayout(2, 1));
        shutdownPanel.add(this.askBeforeQuitCheckbox);
        shutdownPanel.add(this.cleaningLogsOnExitCheckbox);
        shutdownPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Shutdown"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)startupPanel, gbc);
        gbc.gridy = 1;
        this.add((Component)shutdownPanel, gbc);
    }

    public void initUI() {
        this.showSplashCheckbox.setSelected(!this.applicationPreferences.isSplashScreenDisabled());
        this.checkForUpdateCheckbox.setSelected(this.applicationPreferences.isCheckingForUpdate());
        this.askBeforeQuitCheckbox.setSelected(this.applicationPreferences.isAskingBeforeQuit());
        this.cleaningLogsOnExitCheckbox.setSelected(this.applicationPreferences.isCleaningLogsOnExit());
    }

    public void saveSettings() {
        this.applicationPreferences.setSplashScreenDisabled(!this.showSplashCheckbox.isSelected());
        this.applicationPreferences.setCheckingForUpdate(this.checkForUpdateCheckbox.isSelected());
        this.applicationPreferences.setAskingBeforeQuit(this.askBeforeQuitCheckbox.isSelected());
        this.applicationPreferences.setCleaningLogsOnExit(this.cleaningLogsOnExitCheckbox.isSelected());
    }
}

