/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.debug;

import de.huxhorn.lilith.debug.DebugProgressingCallable;
import de.huxhorn.lilith.debug.LoggerEventEmitter;
import de.huxhorn.lilith.swing.MainFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.concurrent.Callable;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugDialog
extends JDialog {
    private final Logger logger = LoggerFactory.getLogger(DebugDialog.class);
    LoggerEventEmitter loggerEventEmitter;
    private MainFrame mainFrame;

    public DebugDialog(Frame owner, MainFrame mainFrame) {
        super(owner, "Debug");
        this.mainFrame = mainFrame;
        this.initUI();
    }

    public DebugDialog(Dialog owner) {
        super(owner, "Debug");
        this.initUI();
    }

    private void initUI() {
        this.setModal(false);
        this.loggerEventEmitter = new LoggerEventEmitter();
        this.loggerEventEmitter.setDelay(0);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(new JButton(new DoneAction()));
        JToolBar debugToolbar = new JToolBar();
        debugToolbar.setFloatable(false);
        AbstractAction action = new LogStuffAction();
        JButton button = new JButton(action);
        debugToolbar.add(button);
        action = new LogExceptionsAction();
        button = new JButton(action);
        debugToolbar.add(button);
        action = new LogParamExceptionsAction();
        button = new JButton(action);
        debugToolbar.add(button);
        action = new LogSkullAction();
        button = new JButton(action);
        debugToolbar.add(button);
        action = new LogTruthAction();
        button = new JButton(action);
        debugToolbar.add(button);
        action = new LogAnonymousAction();
        button = new JButton(action);
        debugToolbar.add(button);
        action = new LogNDCAction();
        button = new JButton(action);
        debugToolbar.add(button);
        action = new LogDateAction();
        button = new JButton(action);
        debugToolbar.add(button);
        action = new LogAllAction();
        button = new JButton(action);
        debugToolbar.add(button);
        action = new EditGroovyAction();
        button = new JButton(action);
        debugToolbar.add(button);
        action = new NetworkAction();
        button = new JButton(action);
        debugToolbar.add(button);
        action = new DebugCallableAction();
        button = new JButton(action);
        debugToolbar.add(button);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)debugToolbar, "North");
        contentPane.add((Component)buttonPanel, "South");
    }

    private class DebugCallableAction
    extends AbstractAction {
        private static final long serialVersionUID = -97047951966954750L;

        public DebugCallableAction() {
            super("Callable");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.mainFrame.getLongWorkManager().startTask((Callable)((Object)new DebugProgressingCallable()), "Test Task", "This is just a simply test task.");
        }
    }

    private class LogAnonymousAction
    extends AbstractAction {
        private static final long serialVersionUID = -3343304084268635261L;

        public LogAnonymousAction() {
            super("Log anonymous");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.loggerEventEmitter.logAnonymous();
        }
    }

    private class LogTruthAction
    extends AbstractAction {
        private static final long serialVersionUID = -7354728704746203904L;

        public LogTruthAction() {
            super("Log truth");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.loggerEventEmitter.logTruth();
        }
    }

    private class LogSkullAction
    extends AbstractAction {
        private static final long serialVersionUID = -3162155864945849819L;

        public LogSkullAction() {
            super("Log skull");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.loggerEventEmitter.logSkull();
        }
    }

    private class LogParamExceptionsAction
    extends AbstractAction {
        private static final long serialVersionUID = -7404752330757185806L;

        public LogParamExceptionsAction() {
            super("Log param exceptions");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.loggerEventEmitter.logParamException();
            DebugDialog.this.loggerEventEmitter.logParamException2();
        }
    }

    private class LogExceptionsAction
    extends AbstractAction {
        private static final long serialVersionUID = -2289262066339501111L;

        public LogExceptionsAction() {
            super("Log exceptions");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.loggerEventEmitter.logException();
            DebugDialog.this.loggerEventEmitter.logException2();
        }
    }

    private class LogNDCAction
    extends AbstractAction {
        private static final long serialVersionUID = -518958063141973150L;

        public LogNDCAction() {
            super("Log NDC");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.loggerEventEmitter.logNDC();
        }
    }

    private class LogDateAction
    extends AbstractAction {
        private static final long serialVersionUID = -1734237014776105342L;

        public LogDateAction() {
            super("Log date");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.loggerEventEmitter.logDate();
        }
    }

    private class LogStuffAction
    extends AbstractAction {
        private static final long serialVersionUID = -3191463140774402016L;

        public LogStuffAction() {
            super("Log stuff");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.loggerEventEmitter.logStuff();
            DebugDialog.this.loggerEventEmitter.logStuffWithMarker();
            DebugDialog.this.loggerEventEmitter.logStuffWithMdc();
            DebugDialog.this.loggerEventEmitter.logStuffWithMdcAndMarker();
        }
    }

    private class NetworkAction
    extends AbstractAction {
        private static final long serialVersionUID = -3099597544720236257L;

        public NetworkAction() {
            super("Network");
        }

        public void actionPerformed(ActionEvent e) {
            HashSet<InetAddress> inetAddresses;
            block5: {
                inetAddresses = new HashSet<InetAddress>();
                try {
                    Enumeration<NetworkInterface> netIfcs = NetworkInterface.getNetworkInterfaces();
                    while (netIfcs.hasMoreElements()) {
                        NetworkInterface ni = netIfcs.nextElement();
                        Enumeration<InetAddress> inetAddrs = ni.getInetAddresses();
                        while (inetAddrs.hasMoreElements()) {
                            InetAddress iadd = inetAddrs.nextElement();
                            if (iadd.isLoopbackAddress()) continue;
                            inetAddresses.add(iadd);
                        }
                    }
                }
                catch (SocketException ex) {
                    if (!DebugDialog.this.logger.isWarnEnabled()) break block5;
                    DebugDialog.this.logger.warn("Exception while retrieving InetAddresses!", ex);
                }
            }
            if (DebugDialog.this.logger.isInfoEnabled()) {
                DebugDialog.this.logger.info("InetAddresses: {}", inetAddresses);
            }
        }
    }

    private class EditGroovyAction
    extends AbstractAction {
        private static final long serialVersionUID = -8812061542734868784L;

        public EditGroovyAction() {
            super("Edit groovy!");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.mainFrame.getPreferencesDialog().editDetailsFormatter();
        }
    }

    private class LogAllAction
    extends AbstractAction {
        private static final long serialVersionUID = -5004276984975201630L;

        public LogAllAction() {
            super("Log all!");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.loggerEventEmitter.logStuff();
            DebugDialog.this.loggerEventEmitter.logStuffWithMarker();
            DebugDialog.this.loggerEventEmitter.logStuffWithMdc();
            DebugDialog.this.loggerEventEmitter.logStuffWithMdcAndMarker();
            DebugDialog.this.loggerEventEmitter.logException();
            DebugDialog.this.loggerEventEmitter.logException2();
            DebugDialog.this.loggerEventEmitter.logParamException();
            DebugDialog.this.loggerEventEmitter.logParamException2();
            DebugDialog.this.loggerEventEmitter.logSkull();
            DebugDialog.this.loggerEventEmitter.logTruth();
            DebugDialog.this.loggerEventEmitter.logAnonymous();
            DebugDialog.this.loggerEventEmitter.logNDC();
            DebugDialog.this.loggerEventEmitter.logDate();
        }
    }

    private class DoneAction
    extends AbstractAction {
        private static final long serialVersionUID = -7747612911180730271L;

        public DoneAction() {
            super("Done!");
        }

        public void actionPerformed(ActionEvent e) {
            DebugDialog.this.setVisible(false);
        }
    }
}

