/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.callables;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.swing.table.model.EventWrapperTableModel;
import de.huxhorn.sulky.conditions.Condition;
import de.huxhorn.sulky.tasks.AbstractProgressingCallable;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindNextCallable<T extends Serializable>
extends AbstractProgressingCallable<Long> {
    private final Logger logger = LoggerFactory.getLogger(FindNextCallable.class);
    private int currentRow;
    private Condition condition;
    private EventWrapperTableModel<T> tableModel;

    public FindNextCallable(EventWrapperTableModel<T> tableModel, int currentRow, Condition condition) {
        super(200L, 1000L);
        this.tableModel = tableModel;
        this.currentRow = currentRow;
        this.condition = condition;
    }

    public Long call() throws Exception {
        int row = this.currentRow;
        if (row > -1) {
            int maxCount;
            int numberOfSteps;
            ++row;
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Searching next starting at {}.", row);
            }
            if ((numberOfSteps = (maxCount = this.tableModel.getRowCount() - row) - 1) < 1) {
                numberOfSteps = 1;
            }
            this.setNumberOfSteps(numberOfSteps);
            for (int i = 0; i < maxCount; ++i) {
                Object obj;
                this.setCurrentStep(i);
                int current = i + row;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Processing row {}", current);
                }
                if ((obj = this.tableModel.getValueAt(current, 0)) == null) {
                    return -1L;
                }
                if (obj instanceof EventWrapper) {
                    if (!this.condition.isTrue(obj)) continue;
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Found next at {}.", current);
                    }
                    return current;
                }
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn("Unexpected class! {}", (Object)obj.getClass().getName());
            }
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Didn't find next.");
        }
        return -1L;
    }
}

