/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.lilith.data.access.AccessEvent;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.Marker;
import de.huxhorn.lilith.data.logging.Message;
import de.huxhorn.lilith.data.logging.ThrowableInfo;
import de.huxhorn.lilith.engine.EventSource;
import de.huxhorn.lilith.services.sender.EventSender;
import de.huxhorn.lilith.swing.EventWrapperViewPanel;
import de.huxhorn.lilith.swing.LoggingViewState;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.ViewContainer;
import de.huxhorn.lilith.swing.ViewWindow;
import de.huxhorn.lilith.swing.table.EventWrapperViewTable;
import de.huxhorn.lilith.swing.table.model.PersistentTableColumnModel;
import de.huxhorn.sulky.conditions.Condition;
import de.huxhorn.sulky.swing.KeyStrokes;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;
import org.simplericity.macify.eawt.Application;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewActions {
    private final Logger logger = LoggerFactory.getLogger(ViewActions.class);
    private static final Icon EMPTY_16_ICON;
    private static final Icon CLEAR_MENU_ICON;
    private static final Icon ATTACH_MENU_ICON;
    private static final Icon DETACH_MENU_ICON;
    private static final Icon PAUSED_MENU_ICON;
    private static final Icon UNPAUSED_MENU_ICON;
    private static final Icon FIND_MENU_ITEM;
    private static final Icon STATISTICS_MENU_ICON;
    private static final Icon DISCONNECT_MENU_ICON;
    private static final Icon TAIL_MENU_ICON;
    private static final Icon FIND_NEXT_MENU_ICON;
    private static final Icon FIND_PREV_MENU_ICON;
    private static final Icon HELP_MENU_ICON;
    private static final Icon OPEN_INACTIVE_MENU_ICON;
    private static final Icon EXIT_MENU_ICON;
    private static final Icon PREFERENCES_MENU_ICON;
    private static final Icon CLEAR_TOOLBAR_ICON;
    private static final Icon ATTACH_TOOLBAR_ICON;
    private static final Icon DETACH_TOOLBAR_ICON;
    private static final Icon PAUSED_TOOLBAR_ICON;
    private static final Icon UNPAUSED_TOOLBAR_ICON;
    private static final Icon FIND_TOOLBAR_ICON;
    private static final Icon STATISTICS_TOOLBAR_ICON;
    private static final Icon DISCONNECT_TOOLBAR_ICON;
    private static final Icon TAIL_TOOLBAR_ICON;
    private static final Icon PREFERENCES_TOOLBAR_ICON;
    private JToolBar toolbar;
    private JMenuBar menubar;
    private MainFrame mainFrame;
    private ViewContainer viewContainer;
    private JToggleButton scrollToBottomButton;
    private AttachToolBarAction attachToolBarAction;
    private AttachMenuAction attachMenuAction;
    private DisconnectToolBarAction disconnectToolBarAction;
    private DisconnectMenuAction disconnectMenuAction;
    private PauseToolBarAction pauseToolBarAction;
    private PauseMenuAction pauseMenuAction;
    private FindPreviousAction findPreviousAction;
    private FindNextAction findNextAction;
    private ResetFindAction resetFindAction;
    private ScrollToBottomMenuAction scrollToBottomMenuAction;
    private EditSourceNameMenuAction editSourceNameMenuAction;
    private SaveLayoutAction saveLayoutAction;
    private ResetLayoutAction resetLayoutAction;
    private EditConditionMenuAction editConditionMenuAction;
    private NextTabAction nextTabAction;
    private PreviousTabAction previousTabAction;
    private CloseFilterAction closeFilterAction;
    private CloseOtherFiltersAction closeOtherFiltersAction;
    private CloseAllFiltersAction closeAllFiltersAction;
    private RemoveInactiveAction removeInactiveAction;
    private CloseAllAction closeAllAction;
    private CloseAllOtherAction closeAllOtherAction;
    private MinimizeAllAction minimizeAllAction;
    private MinimizeAllOtherAction minimizeAllOtherAction;
    private JMenuItem removeInactiveItem;
    private JMenu windowMenu;
    private AboutAction aboutAction;
    private PreferencesMenuAction preferencesMenuAction;
    private FindMenuAction findMenuAction;
    private JMenu searchMenu;
    private JMenu viewMenu;
    private JMenu columnsMenu;
    private ClearMenuAction clearMenuAction;
    private FocusMessageAction focusMessageAction;
    private FocusEventsAction focusEventsAction;
    private StatisticsMenuAction statisticsMenuAction;
    private ChangeListener containerChangeListener;
    private ScrollToBottomToolBarAction scrollToBottomToolBarAction;
    private ClearToolBarAction clearToolBarAction;
    private FindToolBarAction findToolBarAction;
    private StatisticsToolBarAction statisticsToolBarAction;
    private CopySelectionAction copySelectionAction;
    private CopyEventAction copyEventAction;
    private CopyLoggingMessageAction copyLoggingMessageAction;
    private CopyLoggingThrowableAction copyLoggingThrowableAction;
    private CopyLoggingCallStackAction copyLoggingCallStackAction;
    private CopyLoggingMarkerAction copyLoggingMarkerAction;
    private CopyLoggingMdcAction copyLoggingMdcAction;
    private CopyLoggingNdcAction copyLoggingNdcAction;
    private CopyLoggerNameAction copyLoggerNameAction;
    private CopyAccessUriAction copyAccessUriAction;
    private ShowUnfilteredEventAction showUnfilteredEventAction;
    private JPopupMenu popup;
    private GotoSourceAction gotoSourceAction;
    private JMenu sendToMenuItem;
    private PropertyChangeListener containerPropertyChangeListener;
    private EventWrapper eventWrapper;
    private JMenuItem showTaskManagerItem;
    private JMenuItem closeAllItem;
    private JMenuItem minimizeAllItem;
    private JMenuItem closeAllOtherItem;
    private JMenuItem minimizeAllOtherItem;
    private JMenu editMenu;

    public ViewActions(MainFrame mainFrame, ViewContainer viewContainer) {
        this(mainFrame);
        this.setViewContainer(viewContainer);
    }

    public ViewActions(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
        this.containerChangeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ViewActions.this.updateActions();
            }
        };
        this.containerPropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedEvent".equals(evt.getPropertyName())) {
                    ViewActions.this.setEventWrapper((EventWrapper)evt.getNewValue());
                }
            }
        };
        OpenMenuAction openMenuAction = new OpenMenuAction();
        OpenInactiveLogMenuAction openInactiveLogMenuAction = new OpenInactiveLogMenuAction();
        ImportMenuAction importMenuAction = new ImportMenuAction();
        CleanAllInactiveLogsMenuAction cleanAllInactiveLogsMenuAction = new CleanAllInactiveLogsMenuAction();
        this.preferencesMenuAction = new PreferencesMenuAction();
        ExitMenuAction exitMenuAction = new ExitMenuAction();
        this.showUnfilteredEventAction = new ShowUnfilteredEventAction();
        this.gotoSourceAction = new GotoSourceAction();
        this.copySelectionAction = new CopySelectionAction();
        this.copyEventAction = new CopyEventAction();
        this.copyLoggingMessageAction = new CopyLoggingMessageAction();
        this.copyLoggerNameAction = new CopyLoggerNameAction();
        this.copyLoggingThrowableAction = new CopyLoggingThrowableAction();
        this.copyLoggingCallStackAction = new CopyLoggingCallStackAction();
        this.copyLoggingMarkerAction = new CopyLoggingMarkerAction();
        this.copyLoggingMdcAction = new CopyLoggingMdcAction();
        this.copyLoggingNdcAction = new CopyLoggingNdcAction();
        this.copyAccessUriAction = new CopyAccessUriAction();
        this.findMenuAction = new FindMenuAction();
        this.findPreviousAction = new FindPreviousAction();
        this.findNextAction = new FindNextAction();
        this.resetFindAction = new ResetFindAction();
        this.scrollToBottomMenuAction = new ScrollToBottomMenuAction();
        this.pauseMenuAction = new PauseMenuAction();
        this.clearMenuAction = new ClearMenuAction();
        this.attachMenuAction = new AttachMenuAction();
        this.disconnectMenuAction = new DisconnectMenuAction();
        this.focusMessageAction = new FocusMessageAction();
        this.focusEventsAction = new FocusEventsAction();
        this.statisticsMenuAction = new StatisticsMenuAction();
        this.editSourceNameMenuAction = new EditSourceNameMenuAction();
        this.saveLayoutAction = new SaveLayoutAction();
        this.resetLayoutAction = new ResetLayoutAction();
        this.editConditionMenuAction = new EditConditionMenuAction();
        this.previousTabAction = new PreviousTabAction();
        this.nextTabAction = new NextTabAction();
        this.closeFilterAction = new CloseFilterAction();
        this.closeOtherFiltersAction = new CloseOtherFiltersAction();
        this.closeAllFiltersAction = new CloseAllFiltersAction();
        ShowTaskManagerAction showTaskManagerAction = new ShowTaskManagerAction();
        this.closeAllAction = new CloseAllAction();
        this.closeAllOtherAction = new CloseAllOtherAction();
        this.minimizeAllAction = new MinimizeAllAction();
        this.minimizeAllOtherAction = new MinimizeAllOtherAction();
        this.removeInactiveAction = new RemoveInactiveAction();
        KeyboardHelpAction keyboardHelpAction = new KeyboardHelpAction();
        DebugAction debugAction = new DebugAction();
        this.aboutAction = new AboutAction();
        CheckForUpdateAction checkForUpdateAction = new CheckForUpdateAction();
        this.scrollToBottomToolBarAction = new ScrollToBottomToolBarAction();
        this.pauseToolBarAction = new PauseToolBarAction();
        this.clearToolBarAction = new ClearToolBarAction();
        this.findToolBarAction = new FindToolBarAction();
        this.statisticsToolBarAction = new StatisticsToolBarAction();
        this.attachToolBarAction = new AttachToolBarAction();
        PreferencesToolBarAction preferencesToolBarAction = new PreferencesToolBarAction();
        this.disconnectToolBarAction = new DisconnectToolBarAction();
        this.showTaskManagerItem = new JMenuItem(showTaskManagerAction);
        this.closeAllItem = new JMenuItem(this.closeAllAction);
        this.closeAllOtherItem = new JMenuItem(this.closeAllOtherAction);
        this.minimizeAllItem = new JMenuItem(this.minimizeAllAction);
        this.minimizeAllOtherItem = new JMenuItem(this.minimizeAllOtherAction);
        this.removeInactiveItem = new JMenuItem(this.removeInactiveAction);
        this.toolbar = new JToolBar(0);
        this.toolbar.setFloatable(false);
        this.scrollToBottomButton = new JToggleButton(this.scrollToBottomToolBarAction);
        this.toolbar.add(this.scrollToBottomButton);
        JButton pauseButton = new JButton(this.pauseToolBarAction);
        this.toolbar.add(pauseButton);
        JButton clearButton = new JButton(this.clearToolBarAction);
        this.toolbar.add(clearButton);
        JButton findButton = new JButton(this.findToolBarAction);
        this.toolbar.add(findButton);
        JButton disconnectButton = new JButton(this.disconnectToolBarAction);
        this.toolbar.add(disconnectButton);
        this.toolbar.addSeparator();
        JButton statisticsButton = new JButton(this.statisticsToolBarAction);
        this.toolbar.add(statisticsButton);
        this.toolbar.addSeparator();
        JButton attachButton = new JButton(this.attachToolBarAction);
        this.toolbar.add(attachButton);
        this.toolbar.addSeparator();
        JButton preferencesButton = new JButton(preferencesToolBarAction);
        this.toolbar.add(preferencesButton);
        Application app = mainFrame.getApplication();
        this.menubar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('f');
        fileMenu.add(new JMenuItem(openMenuAction));
        fileMenu.add(new JMenuItem(openInactiveLogMenuAction));
        fileMenu.add(new JMenuItem(cleanAllInactiveLogsMenuAction));
        fileMenu.add(new JMenuItem(importMenuAction));
        if (!app.isMac()) {
            fileMenu.addSeparator();
            fileMenu.add(new JMenuItem(this.preferencesMenuAction));
            fileMenu.addSeparator();
            fileMenu.add(new JMenuItem(exitMenuAction));
        }
        this.editMenu = new JMenu("Edit");
        this.editMenu.setMnemonic('e');
        this.editMenu.add(this.copySelectionAction);
        this.editMenu.addSeparator();
        this.editMenu.add(this.copyEventAction);
        this.editMenu.addSeparator();
        this.editMenu.add(this.copyLoggingMessageAction);
        this.editMenu.add(this.copyLoggerNameAction);
        this.editMenu.add(this.copyLoggingThrowableAction);
        this.editMenu.add(this.copyLoggingCallStackAction);
        this.editMenu.add(this.copyLoggingMarkerAction);
        this.editMenu.add(this.copyLoggingMdcAction);
        this.editMenu.add(this.copyLoggingNdcAction);
        this.editMenu.addSeparator();
        this.editMenu.add(this.copyAccessUriAction);
        this.searchMenu = new JMenu("Search");
        this.searchMenu.setMnemonic('s');
        this.searchMenu.add(this.findMenuAction);
        this.searchMenu.add(this.resetFindAction);
        this.searchMenu.add(this.findPreviousAction);
        this.searchMenu.add(this.findNextAction);
        this.viewMenu = new JMenu("View");
        this.viewMenu.setMnemonic('v');
        JMenuItem scrollToBottomMenuItem = new JMenuItem(this.scrollToBottomMenuAction);
        this.viewMenu.add(scrollToBottomMenuItem);
        this.viewMenu.add(this.pauseMenuAction);
        this.viewMenu.add(this.clearMenuAction);
        this.viewMenu.add(this.attachMenuAction);
        this.viewMenu.add(this.disconnectMenuAction);
        this.viewMenu.add(this.focusEventsAction);
        this.viewMenu.add(this.focusMessageAction);
        this.viewMenu.add(this.statisticsMenuAction);
        this.viewMenu.add(this.editSourceNameMenuAction);
        this.viewMenu.add(this.editConditionMenuAction);
        this.viewMenu.addSeparator();
        JMenu layoutMenu = new JMenu("Layout");
        this.columnsMenu = new JMenu("Columns");
        layoutMenu.add(this.columnsMenu);
        layoutMenu.addSeparator();
        layoutMenu.add(this.saveLayoutAction);
        layoutMenu.add(this.resetLayoutAction);
        this.viewMenu.add(layoutMenu);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.previousTabAction);
        this.viewMenu.add(this.nextTabAction);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.closeFilterAction);
        this.viewMenu.add(this.closeOtherFiltersAction);
        this.viewMenu.add(this.closeAllFiltersAction);
        this.windowMenu = new JMenu("Window");
        this.windowMenu.setMnemonic('w');
        JMenu helpMenu = new JMenu("Help");
        helpMenu.setMnemonic('h');
        helpMenu.add(new JMenuItem(keyboardHelpAction));
        helpMenu.add(new JMenuItem(checkForUpdateAction));
        helpMenu.addSeparator();
        helpMenu.add(new JMenuItem(debugAction));
        if (!app.isMac()) {
            helpMenu.addSeparator();
            helpMenu.add(new JMenuItem(this.aboutAction));
        }
        this.menubar.add(fileMenu);
        this.menubar.add(this.editMenu);
        this.menubar.add(this.searchMenu);
        this.menubar.add(this.viewMenu);
        this.menubar.add(this.windowMenu);
        this.menubar.add(helpMenu);
        this.updateWindowMenu();
        this.updateActions();
    }

    public PreferencesMenuAction getPreferencesAction() {
        return this.preferencesMenuAction;
    }

    public JToolBar getToolbar() {
        return this.toolbar;
    }

    public JMenuBar getMenuBar() {
        return this.menubar;
    }

    public void setViewContainer(ViewContainer viewContainer) {
        if (this.viewContainer != viewContainer) {
            if (this.viewContainer != null) {
                this.viewContainer.removeChangeListener(this.containerChangeListener);
                this.viewContainer.removePropertyChangeListener(this.containerPropertyChangeListener);
            }
            this.viewContainer = viewContainer;
            if (this.viewContainer != null) {
                this.viewContainer.addChangeListener(this.containerChangeListener);
                this.viewContainer.addPropertyChangeListener(this.containerPropertyChangeListener);
                EventWrapperViewPanel view = viewContainer.getSelectedView();
                this.setEventWrapper(this.viewContainer.getSelectedEvent());
            }
            this.updateActions();
        }
    }

    public ViewContainer getViewContainer() {
        return this.viewContainer;
    }

    public void updateWindowMenu() {
        this.updateWindowMenu(this.windowMenu);
    }

    public void updateActions() {
        boolean hasView = false;
        boolean hasFilter = false;
        boolean isActive = false;
        boolean hasFilteredBuffer = false;
        EventSource eventSource = null;
        if (this.viewContainer != null) {
            hasView = true;
            EventWrapperViewPanel eventWrapperViewPanel = this.viewContainer.getSelectedView();
            if (eventWrapperViewPanel != null) {
                eventSource = eventWrapperViewPanel.getEventSource();
                hasFilter = eventWrapperViewPanel.getFilterCondition() != null;
                isActive = eventWrapperViewPanel.getState() == LoggingViewState.ACTIVE;
                hasFilteredBuffer = eventWrapperViewPanel.getBufferCondition() != null;
            }
            this.copySelectionAction.setView(eventWrapperViewPanel);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("updateActions() eventSource={}, hasFilteredBuffer={}", new Object[]{eventSource, hasFilteredBuffer});
        }
        this.editMenu.setEnabled(hasView);
        this.searchMenu.setEnabled(hasView);
        this.findMenuAction.setEnabled(hasView);
        this.resetFindAction.setEnabled(hasFilter);
        this.findPreviousAction.setEnabled(hasFilter);
        this.findNextAction.setEnabled(hasFilter);
        this.viewMenu.setEnabled(hasView);
        this.scrollToBottomMenuAction.setEnabled(hasView);
        this.editSourceNameMenuAction.setEnabled(hasView);
        this.saveLayoutAction.setEnabled(hasView);
        this.resetLayoutAction.setEnabled(hasView);
        this.editConditionMenuAction.setEnabled(hasView);
        this.pauseMenuAction.setEnabled(hasView);
        this.clearMenuAction.setEnabled(hasView && !hasFilteredBuffer);
        this.attachMenuAction.setEnabled(hasView);
        this.disconnectMenuAction.setEnabled(isActive);
        this.focusEventsAction.setEnabled(hasView);
        this.focusMessageAction.setEnabled(hasView);
        this.statisticsMenuAction.setEnabled(hasView);
        this.updateShowHideMenu();
        this.previousTabAction.updateAction();
        this.nextTabAction.updateAction();
        this.closeFilterAction.setEnabled(hasView);
        this.closeOtherFiltersAction.setEnabled(hasView);
        this.closeAllFiltersAction.setEnabled(hasView);
        this.disconnectToolBarAction.setEnabled(isActive);
        this.scrollToBottomMenuAction.updateAction();
        this.editSourceNameMenuAction.updateAction();
        this.editConditionMenuAction.updateAction();
        this.pauseMenuAction.updateAction();
        this.attachMenuAction.updateAction();
        this.closeFilterAction.updateAction();
        this.closeOtherFiltersAction.updateAction();
        this.closeAllFiltersAction.updateAction();
        this.scrollToBottomButton.setSelected(this.isScrollingToBottom());
        this.pauseToolBarAction.updateAction();
        this.attachToolBarAction.updateAction();
        this.scrollToBottomToolBarAction.setEnabled(hasView);
        this.pauseToolBarAction.setEnabled(hasView);
        this.clearToolBarAction.setEnabled(hasView && !hasFilteredBuffer);
        this.findToolBarAction.setEnabled(hasView);
        this.statisticsToolBarAction.setEnabled(hasView);
        this.attachToolBarAction.setEnabled(hasView);
        this.disconnectToolBarAction.setEnabled(isActive);
        if (eventSource != null) {
            this.showUnfilteredEventAction.setEnabled(eventSource.getFilter() != null);
        } else {
            this.showUnfilteredEventAction.setEnabled(false);
        }
    }

    private void updateShowHideMenu() {
        EventWrapperViewTable table;
        EventWrapperViewPanel viewPanel;
        this.columnsMenu.removeAll();
        if (this.viewContainer != null && (viewPanel = this.viewContainer.getSelectedView()) != null && (table = viewPanel.getTable()) != null) {
            PersistentTableColumnModel tableColumnModel = table.getTableColumnModel();
            List<PersistentTableColumnModel.TableColumnLayoutInfo> cli = tableColumnModel.getColumnLayoutInfos();
            for (PersistentTableColumnModel.TableColumnLayoutInfo current : cli) {
                boolean visible = current.isVisible();
                JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(new ShowHideAction(tableColumnModel, current.getColumnName(), visible));
                cbmi.setSelected(visible);
                this.columnsMenu.add(cbmi);
            }
        }
    }

    void setShowingFilters(boolean showingFilters) {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.setShowingFilters(showingFilters);
        }
    }

    boolean isScrollingToBottom() {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            return eventWrapperViewPanel.isScrollingToBottom();
        }
        return false;
    }

    void setScrollingToBottom(boolean scrollingToBottom) {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.setScrollingToBottom(scrollingToBottom);
        }
    }

    boolean isPaused() {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            return eventWrapperViewPanel.isPaused();
        }
        return false;
    }

    void setPaused(boolean paused) {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.setPaused(paused);
        }
    }

    void clear() {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.clear();
        }
    }

    void focusTable() {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.focusTable();
        }
    }

    private void editCondition() {
        Condition condition;
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null && (condition = eventWrapperViewPanel.getCombinedCondition()) != null) {
            this.mainFrame.getPreferencesDialog().editCondition(condition);
        }
    }

    private void editSourceName() {
        String sourceIdentifier;
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null && !"global".equals(sourceIdentifier = eventWrapperViewPanel.getEventSource().getSourceIdentifier().getIdentifier()) && !"Lilith".equals(sourceIdentifier)) {
            this.mainFrame.getPreferencesDialog().editSourceName(sourceIdentifier);
        }
    }

    private void attachDetach() {
        EventWrapperViewPanel eventWrapperViewPanel;
        ViewContainer container = this.getViewContainer();
        if (container != null) {
            MainFrame mainFrame = container.getMainFrame();
            ViewWindow window = container.resolveViewWindow();
            if (window instanceof JFrame) {
                window.closeWindow();
                mainFrame.showInternalFrame(container);
            } else if (window instanceof JInternalFrame) {
                window.closeWindow();
                mainFrame.showFrame(container);
            }
        }
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.scrollToEvent();
        }
        this.focusTable();
    }

    private void showStatistics() {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            MainFrame mainFrame = this.viewContainer.getMainFrame();
            mainFrame.showStatistics(eventWrapperViewPanel.getEventSource().getSourceIdentifier());
        }
    }

    private void disconnect() {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.closeConnection(eventWrapperViewPanel.getEventSource().getSourceIdentifier());
        }
    }

    private void focusMessage() {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.focusMessagePane();
        }
    }

    private void focusEvents() {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.focusTable();
        }
    }

    private void findNext() {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.findNext(eventWrapperViewPanel.getSelectedRow(), eventWrapperViewPanel.getFilterCondition());
        }
    }

    private void findPrevious() {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.findPrevious(eventWrapperViewPanel.getSelectedRow(), eventWrapperViewPanel.getFilterCondition());
        }
    }

    private void resetFind() {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.resetFind();
        }
    }

    private void closeCurrentFilter() {
        if (this.viewContainer != null) {
            this.viewContainer.closeCurrentFilter();
        }
    }

    private void closeOtherFilters() {
        if (this.viewContainer != null) {
            this.viewContainer.closeOtherFilters();
        }
    }

    private void closeAllFilters() {
        if (this.viewContainer != null) {
            this.viewContainer.closeAllFilters();
        }
    }

    private void previousTab() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("PreviousTab");
        }
        if (this.viewContainer != null) {
            int viewCount = this.viewContainer.getViewCount();
            int viewIndex = this.viewContainer.getViewIndex();
            if (viewIndex > -1) {
                int newView = viewIndex - 1;
                if (newView < 0) {
                    newView = viewCount - 1;
                }
                if (newView >= 0 && newView < viewCount) {
                    this.viewContainer.setViewIndex(newView);
                }
            }
        }
    }

    private void nextTab() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("NextTab");
        }
        if (this.viewContainer != null) {
            int viewIndex = this.viewContainer.getViewIndex();
            int viewCount = this.viewContainer.getViewCount();
            if (viewIndex > -1) {
                int newView = viewIndex + 1;
                if (newView >= viewCount) {
                    newView = 0;
                }
                if (newView >= 0) {
                    this.viewContainer.setViewIndex(newView);
                }
            }
        }
    }

    private void showUnfilteredEvent() {
        EventWrapperViewPanel eventWrapperViewPanel;
        if (this.viewContainer != null && (eventWrapperViewPanel = this.viewContainer.getSelectedView()) != null) {
            eventWrapperViewPanel.showUnfilteredEvent();
        }
    }

    private void initPopup() {
        this.popup = new JPopupMenu();
        JMenuItem showUnfilteredMenuItem = new JMenuItem(this.showUnfilteredEventAction);
        Font f = showUnfilteredMenuItem.getFont();
        Font boldFont = f.deriveFont(1);
        showUnfilteredMenuItem.setFont(boldFont);
        this.popup.add(showUnfilteredMenuItem);
        JMenu copyMenuItem = new JMenu("Copy...");
        this.popup.add(copyMenuItem);
        copyMenuItem.add(new JMenuItem(this.copySelectionAction));
        copyMenuItem.addSeparator();
        copyMenuItem.add(new JMenuItem(this.copyEventAction));
        copyMenuItem.addSeparator();
        copyMenuItem.add(new JMenuItem(this.copyLoggingMessageAction));
        copyMenuItem.add(new JMenuItem(this.copyLoggerNameAction));
        copyMenuItem.add(new JMenuItem(this.copyLoggingThrowableAction));
        copyMenuItem.add(new JMenuItem(this.copyLoggingCallStackAction));
        copyMenuItem.add(new JMenuItem(this.copyLoggingMarkerAction));
        copyMenuItem.add(new JMenuItem(this.copyLoggingMdcAction));
        copyMenuItem.add(new JMenuItem(this.copyLoggingNdcAction));
        copyMenuItem.addSeparator();
        copyMenuItem.add(new JMenuItem(this.copyAccessUriAction));
        this.sendToMenuItem = new JMenu("Send to...");
        this.popup.add(this.sendToMenuItem);
        JMenuItem gotoSourceMenuItem = new JMenuItem(this.gotoSourceAction);
        this.popup.add(gotoSourceMenuItem);
    }

    private void setEventWrapper(EventWrapper wrapper) {
        this.eventWrapper = wrapper;
        this.gotoSourceAction.setEventWrapper(wrapper);
        this.copyEventAction.setEventWrapper(wrapper);
        this.copyLoggingMessageAction.setEventWrapper(wrapper);
        this.copyLoggerNameAction.setEventWrapper(wrapper);
        this.copyLoggingThrowableAction.setEventWrapper(wrapper);
        this.copyLoggingCallStackAction.setEventWrapper(wrapper);
        this.copyLoggingMarkerAction.setEventWrapper(wrapper);
        this.copyLoggingMdcAction.setEventWrapper(wrapper);
        this.copyLoggingNdcAction.setEventWrapper(wrapper);
        this.copyAccessUriAction.setEventWrapper(wrapper);
    }

    public void updateWindowMenu(JMenu windowMenu) {
        SwingUtilities.invokeLater(new UpdateWindowMenuRunnable(windowMenu));
    }

    public ActionListener getAboutAction() {
        return this.aboutAction;
    }

    public void updatePopup() {
        if (this.popup == null) {
            this.initPopup();
        }
        this.sendToMenuItem.removeAll();
        if (this.eventWrapper == null) {
            this.sendToMenuItem.setEnabled(false);
        } else {
            Serializable eventObj = this.eventWrapper.getEvent();
            if (eventObj instanceof LoggingEvent) {
                Map<String, EventSender<LoggingEvent>> senders = this.mainFrame.getLoggingEventSenders();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Senders: {}", senders);
                }
                if (senders.size() == 0) {
                    this.sendToMenuItem.setEnabled(false);
                } else {
                    this.sendToMenuItem.setEnabled(true);
                    for (Map.Entry<String, EventSender<LoggingEvent>> current : senders.entrySet()) {
                        SendAction<LoggingEvent> action = new SendAction<LoggingEvent>(current.getKey(), current.getValue(), this.eventWrapper);
                        JMenuItem menuItem = new JMenuItem(action);
                        this.sendToMenuItem.add(menuItem);
                    }
                }
            } else if (eventObj instanceof AccessEvent) {
                Map<String, EventSender<AccessEvent>> senders = this.mainFrame.getAccessEventSenders();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Senders: {}", senders);
                }
                if (senders.size() == 0) {
                    this.sendToMenuItem.setEnabled(false);
                } else {
                    this.sendToMenuItem.setEnabled(true);
                    for (Map.Entry<String, EventSender<AccessEvent>> current : senders.entrySet()) {
                        SendAction<AccessEvent> action = new SendAction<AccessEvent>(current.getKey(), current.getValue(), this.eventWrapper);
                        JMenuItem menuItem = new JMenuItem(action);
                        this.sendToMenuItem.add(menuItem);
                    }
                }
            } else {
                this.sendToMenuItem.setEnabled(false);
            }
        }
    }

    public JPopupMenu getPopupMenu() {
        this.updatePopup();
        return this.popup;
    }

    static /* synthetic */ Icon access$900() {
        return ATTACH_MENU_ICON;
    }

    static /* synthetic */ Icon access$1000() {
        return DETACH_MENU_ICON;
    }

    static /* synthetic */ Icon access$1200() {
        return ATTACH_TOOLBAR_ICON;
    }

    static /* synthetic */ Icon access$1300() {
        return DETACH_TOOLBAR_ICON;
    }

    static /* synthetic */ Icon access$1400() {
        return PAUSED_MENU_ICON;
    }

    static /* synthetic */ Icon access$1500() {
        return UNPAUSED_MENU_ICON;
    }

    static /* synthetic */ Icon access$1600() {
        return PAUSED_TOOLBAR_ICON;
    }

    static /* synthetic */ Icon access$1700() {
        return UNPAUSED_TOOLBAR_ICON;
    }

    static {
        URL url = ViewActions.class.getResource("/otherGraphics/empty16.png");
        ImageIcon icon = url != null ? new ImageIcon(url) : null;
        EMPTY_16_ICON = icon;
        url = ViewActions.class.getResource("/tango/16x16/actions/edit-clear.png");
        icon = url != null ? new ImageIcon(url) : null;
        CLEAR_MENU_ICON = icon;
        url = ViewActions.class.getResource("/tango/32x32/actions/edit-clear.png");
        icon = url != null ? new ImageIcon(url) : null;
        CLEAR_TOOLBAR_ICON = icon;
        url = ViewActions.class.getResource("/tango/16x16/actions/edit-undo.png");
        icon = url != null ? new ImageIcon(url) : null;
        ATTACH_MENU_ICON = icon;
        url = ViewActions.class.getResource("/tango/16x16/actions/edit-redo.png");
        icon = url != null ? new ImageIcon(url) : null;
        DETACH_MENU_ICON = icon;
        url = ViewActions.class.getResource("/tango/32x32/actions/edit-undo.png");
        icon = url != null ? new ImageIcon(url) : null;
        ATTACH_TOOLBAR_ICON = icon;
        url = ViewActions.class.getResource("/tango/32x32/actions/edit-redo.png");
        icon = url != null ? new ImageIcon(url) : null;
        DETACH_TOOLBAR_ICON = icon;
        url = ViewActions.class.getResource("/tango/16x16/actions/media-playback-start.png");
        icon = url != null ? new ImageIcon(url) : null;
        PAUSED_MENU_ICON = icon;
        url = ViewActions.class.getResource("/tango/16x16/actions/media-playback-pause.png");
        icon = url != null ? new ImageIcon(url) : null;
        UNPAUSED_MENU_ICON = icon;
        url = ViewActions.class.getResource("/tango/32x32/actions/media-playback-start.png");
        icon = url != null ? new ImageIcon(url) : null;
        PAUSED_TOOLBAR_ICON = icon;
        url = ViewActions.class.getResource("/tango/32x32/actions/media-playback-pause.png");
        icon = url != null ? new ImageIcon(url) : null;
        UNPAUSED_TOOLBAR_ICON = icon;
        url = ViewActions.class.getResource("/tango/16x16/actions/edit-find.png");
        icon = url != null ? new ImageIcon(url) : null;
        FIND_MENU_ITEM = icon;
        url = ViewActions.class.getResource("/tango/32x32/actions/edit-find.png");
        icon = url != null ? new ImageIcon(url) : null;
        FIND_TOOLBAR_ICON = icon;
        url = ViewActions.class.getResource("/tango/16x16/apps/utilities-system-monitor.png");
        icon = url != null ? new ImageIcon(url) : null;
        STATISTICS_MENU_ICON = icon;
        url = ViewActions.class.getResource("/tango/32x32/apps/utilities-system-monitor.png");
        icon = url != null ? new ImageIcon(url) : null;
        STATISTICS_TOOLBAR_ICON = icon;
        url = ViewActions.class.getResource("/tango/16x16/actions/media-eject.png");
        icon = url != null ? new ImageIcon(url) : null;
        DISCONNECT_MENU_ICON = icon;
        url = ViewActions.class.getResource("/tango/32x32/actions/media-eject.png");
        icon = url != null ? new ImageIcon(url) : null;
        DISCONNECT_TOOLBAR_ICON = icon;
        url = ViewActions.class.getResource("/tango/16x16/actions/go-down.png");
        icon = url != null ? new ImageIcon(url) : null;
        FIND_NEXT_MENU_ICON = icon;
        url = ViewActions.class.getResource("/tango/16x16/actions/go-up.png");
        icon = url != null ? new ImageIcon(url) : null;
        FIND_PREV_MENU_ICON = icon;
        url = ViewActions.class.getResource("/tango/16x16/actions/go-bottom.png");
        icon = url != null ? new ImageIcon(url) : null;
        TAIL_MENU_ICON = icon;
        url = ViewActions.class.getResource("/tango/32x32/actions/go-bottom.png");
        icon = url != null ? new ImageIcon(url) : null;
        TAIL_TOOLBAR_ICON = icon;
        url = ViewActions.class.getResource("/tango/16x16/apps/help-browser.png");
        icon = url != null ? new ImageIcon(url) : null;
        HELP_MENU_ICON = icon;
        url = ViewActions.class.getResource("/tango/16x16/actions/document-open.png");
        icon = url != null ? new ImageIcon(url) : null;
        OPEN_INACTIVE_MENU_ICON = icon;
        url = ViewActions.class.getResource("/tango/16x16/actions/system-log-out.png");
        icon = url != null ? new ImageIcon(url) : null;
        EXIT_MENU_ICON = icon;
        url = ViewActions.class.getResource("/tango/16x16/categories/preferences-system.png");
        icon = url != null ? new ImageIcon(url) : null;
        PREFERENCES_MENU_ICON = icon;
        url = ViewActions.class.getResource("/tango/32x32/categories/preferences-system.png");
        icon = url != null ? new ImageIcon(url) : null;
        PREFERENCES_TOOLBAR_ICON = icon;
    }

    private class ShowHideAction
    extends AbstractAction {
        private static final long serialVersionUID = 7775753128032553866L;
        private boolean visible;
        private String columnName;
        private PersistentTableColumnModel tableColumnModel;

        public ShowHideAction(PersistentTableColumnModel tableColumnModel, String columnName, boolean visible) {
            super(columnName);
            this.columnName = columnName;
            this.visible = visible;
            this.tableColumnModel = tableColumnModel;
        }

        public void actionPerformed(ActionEvent e) {
            this.visible = !this.visible;
            Iterator<TableColumn> iter = this.tableColumnModel.getColumns(false);
            TableColumn found = null;
            while (iter.hasNext()) {
                TableColumn current = iter.next();
                if (!this.columnName.equals(current.getIdentifier())) continue;
                found = current;
                break;
            }
            if (found != null) {
                this.tableColumnModel.setColumnVisible(found, this.visible);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SendAction<T extends Serializable>
    extends AbstractAction {
        private static final long serialVersionUID = 6612401555757959404L;
        private EventSender<T> sender;
        private T event;

        public SendAction(String name, EventSender<T> sender, EventWrapper<T> wrapper) {
            super(name);
            this.sender = sender;
            this.event = wrapper.getEvent();
            this.setEnabled(this.event != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.sender.send(this.event);
        }
    }

    private class GotoSourceAction
    extends AbstractAction {
        private static final long serialVersionUID = 4284532761807647658L;
        private ExtendedStackTraceElement stackTraceElement;

        public GotoSourceAction() {
            super("Go to source");
            this.putValue("ShortDescription", "Show source in IDEA if everything is ok ;)");
        }

        public void setEventWrapper(EventWrapper wrapper) {
            LoggingEvent loggingEvent;
            ExtendedStackTraceElement[] callStack;
            if (wrapper == null) {
                this.setStackTraceElement(null);
                return;
            }
            Serializable event = wrapper.getEvent();
            if (event instanceof LoggingEvent && (callStack = (loggingEvent = (LoggingEvent)event).getCallStack()) != null && callStack.length > 0) {
                this.setStackTraceElement(callStack[0]);
                return;
            }
            this.setStackTraceElement(null);
        }

        public void setStackTraceElement(ExtendedStackTraceElement stackTraceElement) {
            this.stackTraceElement = stackTraceElement;
            this.setEnabled(this.stackTraceElement != null);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.goToSource(this.stackTraceElement.getStackTraceElement());
        }
    }

    private class ShowUnfilteredEventAction
    extends AbstractAction {
        private static final long serialVersionUID = -3282222163767568550L;

        public ShowUnfilteredEventAction() {
            super("Show unfiltered");
            this.putValue("ShortDescription", "Show unfiltered event.");
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.showUnfilteredEvent();
        }
    }

    private class CopyAccessUriAction
    extends AbstractAction {
        private static final long serialVersionUID = -3535746663619981434L;
        private String requestUri;

        public CopyAccessUriAction() {
            super("Copy request URI");
            this.putValue("ShortDescription", "Copies the request URI of the access event to the clipboard.");
        }

        public void setEventWrapper(EventWrapper wrapper) {
            Serializable eventObj;
            String requestUrl = null;
            if (wrapper != null && wrapper.getEvent() != null && (eventObj = wrapper.getEvent()) instanceof AccessEvent) {
                AccessEvent accessEvent = (AccessEvent)eventObj;
                requestUrl = accessEvent.getRequestURI();
            }
            this.setRequestUri(requestUrl);
        }

        private void setRequestUri(String requestUri) {
            this.requestUri = requestUri;
            this.setEnabled(requestUri != null);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.copyText(this.requestUri);
        }
    }

    private class CopyLoggingNdcAction
    extends AbstractAction {
        private static final long serialVersionUID = -1530866703421390638L;
        private Message[] ndc;

        public CopyLoggingNdcAction() {
            super("Copy NDC");
            this.putValue("ShortDescription", "Copies the Nested Diagnostic Context of the logging event to the clipboard.");
        }

        public void setEventWrapper(EventWrapper wrapper) {
            Serializable eventObj;
            Message[] ndc = null;
            if (wrapper != null && wrapper.getEvent() != null && (eventObj = wrapper.getEvent()) instanceof LoggingEvent) {
                LoggingEvent loggingEvent = (LoggingEvent)eventObj;
                ndc = loggingEvent.getNdc();
            }
            this.setNdc(ndc);
        }

        private void setNdc(Message[] ndc) {
            this.ndc = ndc;
            this.setEnabled(ndc != null);
        }

        public void actionPerformed(ActionEvent e) {
            StringBuilder text = new StringBuilder();
            if (this.ndc != null) {
                for (Message current : this.ndc) {
                    text.append(current.getMessage()).append("\n");
                }
            }
            ViewActions.this.mainFrame.copyText(text.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CopyLoggingMdcAction
    extends AbstractAction {
        private static final long serialVersionUID = 2453432319268833157L;
        private Map<String, String> mdc;

        public CopyLoggingMdcAction() {
            super("Copy MDC");
            this.putValue("ShortDescription", "Copies the Mapped Diagnostic Context of the logging event to the clipboard.");
        }

        public void setEventWrapper(EventWrapper wrapper) {
            Serializable eventObj;
            Map mdc = null;
            if (wrapper != null && wrapper.getEvent() != null && (eventObj = wrapper.getEvent()) instanceof LoggingEvent) {
                LoggingEvent loggingEvent = (LoggingEvent)eventObj;
                mdc = loggingEvent.getMdc();
            }
            this.setMdc(mdc);
        }

        private void setMdc(Map<String, String> mdc) {
            this.mdc = mdc;
            this.setEnabled(mdc != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StringBuilder text = new StringBuilder();
            if (this.mdc != null) {
                TreeMap<String, String> sorted = new TreeMap<String, String>(this.mdc);
                for (Map.Entry current : sorted.entrySet()) {
                    text.append((String)current.getKey()).append("\t").append((String)current.getValue()).append("\n");
                }
            }
            ViewActions.this.mainFrame.copyText(text.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CopyLoggingMarkerAction
    extends AbstractAction {
        private static final long serialVersionUID = -3523674814363899315L;
        private Marker marker;

        public CopyLoggingMarkerAction() {
            super("Copy Marker");
            this.putValue("ShortDescription", "Copies the Marker of the logging event to the clipboard.");
        }

        public void setEventWrapper(EventWrapper wrapper) {
            Serializable eventObj;
            Marker marker = null;
            if (wrapper != null && wrapper.getEvent() != null && (eventObj = wrapper.getEvent()) instanceof LoggingEvent) {
                LoggingEvent loggingEvent = (LoggingEvent)eventObj;
                marker = loggingEvent.getMarker();
            }
            this.setMarker(marker);
        }

        private void setMarker(Marker marker) {
            this.marker = marker;
            this.setEnabled(marker != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StringBuilder text = new StringBuilder();
            this.buildMarker(text, 0, this.marker, new ArrayList<String>());
            ViewActions.this.mainFrame.copyText(text.toString());
        }

        private void buildMarker(StringBuilder text, int indent, Marker marker, ArrayList<String> handledMarkers) {
            if (ViewActions.this.logger.isInfoEnabled()) {
                ViewActions.this.logger.info("Implement!");
            }
            if (marker != null) {
                for (int i = 0; i < indent; ++i) {
                    text.append("  ");
                }
                String markerName = marker.getName();
                text.append("- ").append(markerName);
                if (handledMarkers.contains(markerName)) {
                    text.append(" [..]\n");
                } else {
                    text.append("\n");
                    handledMarkers.add(markerName);
                    Map references = marker.getReferences();
                    if (references != null) {
                        for (Map.Entry current : references.entrySet()) {
                            this.buildMarker(text, indent + 1, (Marker)current.getValue(), handledMarkers);
                        }
                    }
                }
            }
        }
    }

    private class CopyLoggingCallStackAction
    extends AbstractAction {
        private static final long serialVersionUID = -7271955597619779579L;
        private ExtendedStackTraceElement[] callStack;

        public CopyLoggingCallStackAction() {
            super("Copy call stack");
            this.putValue("ShortDescription", "Copies the call stack of the logging event to the clipboard.");
        }

        public void setEventWrapper(EventWrapper wrapper) {
            Serializable eventObj;
            ExtendedStackTraceElement[] callStack = null;
            if (wrapper != null && wrapper.getEvent() != null && (eventObj = wrapper.getEvent()) instanceof LoggingEvent) {
                LoggingEvent loggingEvent = (LoggingEvent)eventObj;
                callStack = loggingEvent.getCallStack();
            }
            this.setCallStack(callStack);
        }

        private void setCallStack(ExtendedStackTraceElement[] callStack) {
            this.callStack = callStack;
            this.setEnabled(callStack != null && callStack.length > 0);
        }

        public void actionPerformed(ActionEvent e) {
            StringBuilder text = new StringBuilder();
            ExtendedStackTraceElement[] cs = this.callStack;
            if (cs != null) {
                boolean first = true;
                for (ExtendedStackTraceElement current : cs) {
                    if (first) {
                        first = false;
                    } else {
                        text.append("\n");
                    }
                    text.append("\tat ").append(current);
                }
            }
            ViewActions.this.mainFrame.copyText(text.toString());
        }
    }

    private class CopyLoggingThrowableAction
    extends AbstractAction {
        private static final long serialVersionUID = -2869680200462202650L;
        private ThrowableInfo throwableInfo;

        public CopyLoggingThrowableAction() {
            super("Copy Throwable");
            this.putValue("ShortDescription", "Copies the Throwable of the logging event to the clipboard.");
        }

        public void setEventWrapper(EventWrapper wrapper) {
            Serializable eventObj;
            ThrowableInfo info = null;
            if (wrapper != null && wrapper.getEvent() != null && (eventObj = wrapper.getEvent()) instanceof LoggingEvent) {
                LoggingEvent loggingEvent = (LoggingEvent)eventObj;
                info = loggingEvent.getThrowable();
            }
            this.setThrowableInfo(info);
        }

        private void setThrowableInfo(ThrowableInfo info) {
            this.throwableInfo = info;
            this.setEnabled(info != null);
        }

        public void actionPerformed(ActionEvent e) {
            StringBuilder throwableText = new StringBuilder();
            ThrowableInfo info = this.throwableInfo;
            while (true) {
                ExtendedStackTraceElement[] st;
                throwableText.append("Exception: ").append(info.getName()).append("\n");
                String message = info.getMessage();
                if (message != null && !message.equals(info.getName())) {
                    throwableText.append("Message: ").append(message).append("\n");
                }
                if ((st = info.getStackTrace()) != null) {
                    throwableText.append("StackTrace:\n");
                    for (ExtendedStackTraceElement current : st) {
                        throwableText.append("\tat ").append(current.toString(true)).append("\n");
                    }
                }
                if ((info = info.getCause()) == null) break;
                throwableText.append("\nCaused by:\n");
            }
            ViewActions.this.mainFrame.copyText(throwableText.toString());
        }
    }

    private class CopyLoggerNameAction
    extends AbstractAction {
        private static final long serialVersionUID = 6056521432357588113L;
        private String loggerName;

        public CopyLoggerNameAction() {
            super("Copy logger name");
            this.putValue("ShortDescription", "Copies the logger name of the logging event to the clipboard.");
        }

        public void setEventWrapper(EventWrapper wrapper) {
            Serializable eventObj;
            String loggerName = null;
            if (wrapper != null && wrapper.getEvent() != null && (eventObj = wrapper.getEvent()) instanceof LoggingEvent) {
                LoggingEvent loggingEvent = (LoggingEvent)eventObj;
                loggerName = loggingEvent.getLogger();
            }
            this.setLoggerName(loggerName);
        }

        private void setLoggerName(String loggerName) {
            this.loggerName = loggerName;
            this.setEnabled(loggerName != null);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.copyText(this.loggerName);
        }
    }

    private class CopyLoggingMessageAction
    extends AbstractAction {
        private static final long serialVersionUID = -1147972057354807369L;
        private String message;

        public CopyLoggingMessageAction() {
            super("Copy message");
            this.putValue("ShortDescription", "Copies the message of the logging event to the clipboard.");
        }

        public void setEventWrapper(EventWrapper wrapper) {
            LoggingEvent loggingEvent;
            Message messageObj;
            Serializable eventObj;
            String message = null;
            if (wrapper != null && wrapper.getEvent() != null && (eventObj = wrapper.getEvent()) instanceof LoggingEvent && (messageObj = (loggingEvent = (LoggingEvent)eventObj).getMessage()) != null) {
                message = messageObj.getMessage();
            }
            this.setMessage(message);
        }

        private void setMessage(String message) {
            this.message = message;
            this.setEnabled(message != null);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.copyText(this.message);
        }
    }

    private class CopyEventAction
    extends AbstractAction {
        private static final long serialVersionUID = -551520865313383753L;
        private EventWrapper eventWrapper;

        public CopyEventAction() {
            super("Copy event");
            this.putValue("ShortDescription", "Copies the event to the clipboard.");
        }

        public void setEventWrapper(EventWrapper wrapper) {
            this.eventWrapper = wrapper;
            if (wrapper == null) {
                this.setEnabled(false);
            } else {
                Serializable eventObj = wrapper.getEvent();
                if (eventObj instanceof LoggingEvent || eventObj instanceof AccessEvent) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
            String message = ViewActions.this.mainFrame.createMessage(this.eventWrapper);
            ViewActions.this.mainFrame.copyHtml(message);
        }
    }

    private class CopySelectionAction
    extends AbstractAction {
        private static final long serialVersionUID = -551520865313383753L;
        private EventWrapperViewPanel view;

        public CopySelectionAction() {
            super("Copy selection");
            this.putValue("ShortDescription", "Copies the selection to the clipboard.");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command C");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            if (this.view != null) {
                this.view.copySelection();
            }
        }

        public void setView(EventWrapperViewPanel view) {
            this.view = view;
        }
    }

    private class NextTabAction
    extends AbstractAction {
        private static final long serialVersionUID = 6997026628818486446L;

        public NextTabAction() {
            super("Next tab");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command K");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("SmallIcon", EMPTY_16_ICON);
        }

        public void updateAction() {
            if (ViewActions.this.viewContainer != null) {
                int viewCount = ViewActions.this.viewContainer.getViewCount();
                if (viewCount > 1) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.nextTab();
        }
    }

    private class PreviousTabAction
    extends AbstractAction {
        private static final long serialVersionUID = 3841435361964210123L;

        public PreviousTabAction() {
            super("Previous tab");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command J");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("SmallIcon", EMPTY_16_ICON);
        }

        public void updateAction() {
            if (ViewActions.this.viewContainer != null) {
                int viewCount = ViewActions.this.viewContainer.getViewCount();
                if (viewCount > 1) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.previousTab();
        }
    }

    class CleanAllInactiveLogsMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 626049491764655228L;

        public CleanAllInactiveLogsMenuAction() {
            super("Clean all inactive logs");
            this.putValue("SmallIcon", CLEAR_MENU_ICON);
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command shift X");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("MnemonicKey", 99);
        }

        public void actionPerformed(ActionEvent e) {
            if (ViewActions.this.logger.isInfoEnabled()) {
                ViewActions.this.logger.info("Clean all inactive logs");
            }
            ViewActions.this.mainFrame.cleanAllInactiveLogs();
        }
    }

    class ImportMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 7500131416548647712L;

        public ImportMenuAction() {
            super("Import...");
            this.putValue("SmallIcon", OPEN_INACTIVE_MENU_ICON);
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command shift I");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("MnemonicKey", 105);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.importFile();
        }
    }

    class OpenMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 7500131416548647712L;

        public OpenMenuAction() {
            super("Open...");
            this.putValue("SmallIcon", OPEN_INACTIVE_MENU_ICON);
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command O");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("MnemonicKey", 111);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.open();
        }
    }

    class OpenInactiveLogMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 7500131416548647712L;

        public OpenInactiveLogMenuAction() {
            super("Open inactive log...");
            this.putValue("SmallIcon", OPEN_INACTIVE_MENU_ICON);
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command shift O");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("MnemonicKey", 111);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.openInactiveLogs();
        }
    }

    class ExitMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 6693131597277483031L;

        public ExitMenuAction() {
            super("Exit");
            this.putValue("SmallIcon", EXIT_MENU_ICON);
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command Q");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("MnemonicKey", 120);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.exit();
        }
    }

    class DebugAction
    extends AbstractAction {
        private static final long serialVersionUID = -1837786931224404611L;

        public DebugAction() {
            super("Debug");
            this.putValue("SmallIcon", EMPTY_16_ICON);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.showDebugDialog();
        }
    }

    class PreferencesToolBarAction
    extends AbstractAction {
        private static final long serialVersionUID = 8353604009441967874L;

        public PreferencesToolBarAction() {
            this.putValue("SmallIcon", PREFERENCES_TOOLBAR_ICON);
            this.putValue("ShortDescription", "Preferences...");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command COMMA");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("MnemonicKey", 112);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.showPreferencesDialog();
        }
    }

    class PreferencesMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = -196036112324455446L;

        public PreferencesMenuAction() {
            super("Preferences...");
            this.putValue("SmallIcon", PREFERENCES_MENU_ICON);
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command COMMA");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("MnemonicKey", 112);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.showPreferencesDialog();
        }
    }

    class KeyboardHelpAction
    extends AbstractAction {
        private static final long serialVersionUID = 6942092383339768508L;

        public KeyboardHelpAction() {
            super("Help Topics");
            this.putValue("SmallIcon", HELP_MENU_ICON);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.showHelp();
        }
    }

    class CheckForUpdateAction
    extends AbstractAction {
        private static final long serialVersionUID = 529742851501771901L;

        public CheckForUpdateAction() {
            super("Check for Update...");
            this.putValue("SmallIcon", EMPTY_16_ICON);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.checkForUpdate(true);
        }
    }

    class ResetLayoutAction
    extends AbstractAction {
        private static final long serialVersionUID = -8396518428359553649L;

        public ResetLayoutAction() {
            super("Reset layout");
            this.putValue("SmallIcon", EMPTY_16_ICON);
        }

        public void actionPerformed(ActionEvent e) {
            EventWrapperViewTable table;
            EventWrapperViewPanel viewPanel;
            if (ViewActions.this.viewContainer != null && (viewPanel = ViewActions.this.viewContainer.getSelectedView()) != null && (table = viewPanel.getTable()) != null) {
                table.resetLayout();
            }
        }
    }

    class SaveLayoutAction
    extends AbstractAction {
        private static final long serialVersionUID = 6135867758474252484L;

        public SaveLayoutAction() {
            super("Save layout");
            this.putValue("SmallIcon", EMPTY_16_ICON);
        }

        public void actionPerformed(ActionEvent e) {
            EventWrapperViewTable table;
            EventWrapperViewPanel viewPanel;
            if (ViewActions.this.viewContainer != null && (viewPanel = ViewActions.this.viewContainer.getSelectedView()) != null && (table = viewPanel.getTable()) != null) {
                table.saveLayout();
            }
        }
    }

    class AboutAction
    extends AbstractAction {
        private static final long serialVersionUID = -372250750198620913L;

        public AboutAction() {
            super("About...");
            this.putValue("SmallIcon", EMPTY_16_ICON);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.showAboutDialog();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class UpdateWindowMenuRunnable
    implements Runnable {
        private JMenu windowMenu;

        public UpdateWindowMenuRunnable(JMenu windowMenu) {
            this.windowMenu = windowMenu;
        }

        @Override
        public void run() {
            EventWrapperViewPanel<LoggingEvent> panel;
            JCheckBoxMenuItem menuItem;
            ViewContainer<LoggingEvent> value;
            JCheckBoxMenuItem menuItem2;
            ViewContainer<LoggingEvent> value2;
            SourceIdentifier si;
            EventSource<LoggingEvent> key;
            ViewActions.this.mainFrame.removeInactiveViews(true, false);
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("Updating Views-Menu.");
            }
            this.windowMenu.removeAll();
            JMenu statisticsMenu = this.createStatisticsMenu();
            this.windowMenu.add(statisticsMenu);
            this.windowMenu.add(ViewActions.this.showTaskManagerItem);
            this.windowMenu.addSeparator();
            this.windowMenu.add(ViewActions.this.closeAllItem);
            this.windowMenu.add(ViewActions.this.closeAllOtherItem);
            this.windowMenu.add(ViewActions.this.minimizeAllItem);
            this.windowMenu.add(ViewActions.this.minimizeAllOtherItem);
            this.windowMenu.add(ViewActions.this.removeInactiveItem);
            int activeCounter = 0;
            int inactiveCounter = 0;
            int viewCounter = 0;
            Font inactiveFont = this.windowMenu.getFont();
            inactiveFont = inactiveFont.deriveFont(0);
            SortedMap<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> sortedLoggingViews = ViewActions.this.mainFrame.getSortedLoggingViews();
            SortedMap<EventSource<AccessEvent>, ViewContainer<AccessEvent>> sortedAccessViews = ViewActions.this.mainFrame.getSortedAccessViews();
            boolean first = true;
            for (Map.Entry<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> entry : sortedLoggingViews.entrySet()) {
                key = entry.getKey();
                si = key.getSourceIdentifier();
                if (!"Lilith".equals(si.getIdentifier())) continue;
                ViewContainer<LoggingEvent> value22 = entry.getValue();
                if (value22.resolveViewWindow() != null) {
                    ++viewCounter;
                }
                if (first) {
                    first = false;
                    this.windowMenu.addSeparator();
                }
                JCheckBoxMenuItem menuItem22 = this.createLoggingMenuItem(key, value22);
                this.windowMenu.add(menuItem22);
            }
            for (Map.Entry<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> entry : sortedLoggingViews.entrySet()) {
                key = entry.getKey();
                si = key.getSourceIdentifier();
                if ("Lilith".equals(si.getIdentifier())) continue;
                value2 = entry.getValue();
                if (value2.resolveViewWindow() != null) {
                    ++viewCounter;
                }
                if (!key.isGlobal()) continue;
                if (first) {
                    first = false;
                    this.windowMenu.addSeparator();
                }
                menuItem2 = this.createLoggingMenuItem(key, value2);
                this.windowMenu.add(menuItem2);
            }
            for (Map.Entry<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> entry : sortedAccessViews.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                if (value.resolveViewWindow() != null) {
                    ++viewCounter;
                }
                if (!key.isGlobal()) continue;
                if (first) {
                    first = false;
                    this.windowMenu.addSeparator();
                }
                JCheckBoxMenuItem menuItem3 = this.createAccessMenuItem(key, value);
                this.windowMenu.add(menuItem3);
            }
            first = true;
            for (Map.Entry<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> entry : sortedLoggingViews.entrySet()) {
                key = entry.getKey();
                si = key.getSourceIdentifier();
                if ("Lilith".equals(si.getIdentifier())) continue;
                value2 = entry.getValue();
                EventWrapperViewPanel<LoggingEvent> panel2 = value2.getDefaultView();
                if (key.isGlobal() || LoggingViewState.ACTIVE != panel2.getState()) continue;
                if (first) {
                    first = false;
                    this.windowMenu.addSeparator();
                }
                menuItem = this.createLoggingMenuItem(key, value2);
                this.windowMenu.add(menuItem);
                ++activeCounter;
            }
            for (Map.Entry<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> entry : sortedLoggingViews.entrySet()) {
                key = entry.getKey();
                si = key.getSourceIdentifier();
                if ("Lilith".equals(si.getIdentifier())) continue;
                value2 = entry.getValue();
                EventWrapperViewPanel<LoggingEvent> panel2 = value2.getDefaultView();
                if (key.isGlobal() || LoggingViewState.ACTIVE == panel2.getState()) continue;
                if (first) {
                    first = false;
                    this.windowMenu.addSeparator();
                }
                menuItem = this.createLoggingMenuItem(key, value2);
                menuItem.setFont(inactiveFont);
                this.windowMenu.add(menuItem);
                ++inactiveCounter;
            }
            first = true;
            for (Map.Entry<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> entry : sortedAccessViews.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                panel = value.getDefaultView();
                if (key.isGlobal() || LoggingViewState.ACTIVE != panel.getState()) continue;
                if (first) {
                    first = false;
                    this.windowMenu.addSeparator();
                }
                menuItem2 = this.createAccessMenuItem(key, value);
                this.windowMenu.add(menuItem2);
                ++activeCounter;
            }
            for (Map.Entry<EventSource<LoggingEvent>, ViewContainer<LoggingEvent>> entry : sortedAccessViews.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                panel = value.getDefaultView();
                if (key.isGlobal() || LoggingViewState.ACTIVE == panel.getState()) continue;
                if (first) {
                    first = false;
                    this.windowMenu.addSeparator();
                }
                menuItem2 = this.createAccessMenuItem(key, value);
                menuItem2.setFont(inactiveFont);
                this.windowMenu.add(menuItem2);
                ++inactiveCounter;
            }
            boolean hasInactive = inactiveCounter != 0;
            ViewActions.this.removeInactiveAction.setEnabled(hasInactive);
            boolean bl = viewCounter != 0;
            ViewActions.this.minimizeAllAction.setEnabled(bl);
            ViewActions.this.closeAllAction.setEnabled(bl);
            if (ViewActions.this.viewContainer == null || viewCounter <= 1) {
                ViewActions.this.minimizeAllOtherAction.setEnabled(false);
                ViewActions.this.closeAllOtherAction.setEnabled(false);
            } else {
                ViewActions.this.minimizeAllOtherAction.setEnabled(true);
                ViewActions.this.closeAllOtherAction.setEnabled(true);
            }
            ViewActions.this.mainFrame.setActiveConnectionsCounter(activeCounter);
            if (this.windowMenu.isPopupMenuVisible()) {
                this.windowMenu.setPopupMenuVisible(false);
                this.windowMenu.setPopupMenuVisible(true);
            }
        }

        private JCheckBoxMenuItem createLoggingMenuItem(EventSource<LoggingEvent> key, ViewContainer<LoggingEvent> viewContainer) {
            JCheckBoxMenuItem result = new JCheckBoxMenuItem(new ViewLoggingAction(key));
            Container compParent = viewContainer.getParent();
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("\n\nParent for {}: {}\n", key.getSourceIdentifier(), (Object)compParent);
            }
            if (compParent == null) {
                result.setState(false);
            } else {
                result.setState(true);
            }
            return result;
        }

        private JCheckBoxMenuItem createAccessMenuItem(EventSource<AccessEvent> key, ViewContainer<AccessEvent> viewContainer) {
            JCheckBoxMenuItem result = new JCheckBoxMenuItem(new ViewAccessAction(key));
            Container compParent = viewContainer.getParent();
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("\n\nParent for {}: {}\n", key.getSourceIdentifier(), (Object)compParent);
            }
            if (compParent == null) {
                result.setState(false);
            } else {
                result.setState(true);
            }
            return result;
        }

        private JMenu createStatisticsMenu() {
            JMenu result = new JMenu(new StatisticsMenuAction());
            SortedMap<String, SourceIdentifier> sources = ViewActions.this.mainFrame.getAvailableStatistics();
            JMenuItem menuItem = new JMenuItem(new ViewStatisticsAction("Global", new SourceIdentifier("global")));
            result.add(menuItem);
            result.addSeparator();
            for (Map.Entry<String, SourceIdentifier> current : sources.entrySet()) {
                String key = current.getKey();
                SourceIdentifier value = current.getValue();
                JMenuItem menuItem2 = new JMenuItem(new ViewStatisticsAction(key, value));
                result.add(menuItem2);
            }
            return result;
        }
    }

    static class StatisticsSubMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = -8180660223848656769L;

        public StatisticsSubMenuAction() {
            super("Statistics");
            this.putValue("SmallIcon", STATISTICS_MENU_ICON);
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    class ViewStatisticsAction
    extends AbstractAction {
        private static final long serialVersionUID = 4453230971326526165L;
        private SourceIdentifier sourceIentifier;

        public ViewStatisticsAction(String name, SourceIdentifier sourceIdentifier) {
            super(name);
            this.sourceIentifier = sourceIdentifier;
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.showStatistics(this.sourceIentifier);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ViewAccessAction
    extends AbstractAction {
        private static final long serialVersionUID = 8054851261518410946L;
        private EventSource<AccessEvent> eventSource;

        public ViewAccessAction(EventSource<AccessEvent> eventSource) {
            super(ViewActions.this.mainFrame.getAccessSourceTitle(eventSource.getSourceIdentifier()));
            this.eventSource = eventSource;
            if (eventSource.isGlobal()) {
                KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command 2");
                if (ViewActions.this.logger.isDebugEnabled()) {
                    ViewActions.this.logger.debug("accelerator: {}", accelerator);
                }
                this.putValue("AcceleratorKey", accelerator);
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ViewActions.this.mainFrame.showAccessView(this.eventSource);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ViewLoggingAction
    extends AbstractAction {
        private static final long serialVersionUID = 6967472316665780683L;
        private EventSource<LoggingEvent> eventSource;

        public ViewLoggingAction(EventSource<LoggingEvent> eventSource) {
            super(ViewActions.this.mainFrame.getLoggingSourceTitle(eventSource.getSourceIdentifier()));
            this.eventSource = eventSource;
            if (eventSource.isGlobal()) {
                KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command 1");
                if (ViewActions.this.logger.isDebugEnabled()) {
                    ViewActions.this.logger.debug("accelerator: {}", accelerator);
                }
                this.putValue("AcceleratorKey", accelerator);
            } else {
                SourceIdentifier si = eventSource.getSourceIdentifier();
                if (si != null && "Lilith".equals(si.getIdentifier())) {
                    KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command 0");
                    if (ViewActions.this.logger.isDebugEnabled()) {
                        ViewActions.this.logger.debug("accelerator: {}", accelerator);
                    }
                    this.putValue("AcceleratorKey", accelerator);
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            ViewActions.this.mainFrame.showLoggingView(this.eventSource);
        }
    }

    private class CloseAllFiltersAction
    extends AbstractAction {
        private static final long serialVersionUID = 1212878326080544663L;

        public CloseAllFiltersAction() {
            super("Close all filters");
            this.putValue("SmallIcon", EMPTY_16_ICON);
            this.putValue("MnemonicKey", 97);
        }

        public void updateAction() {
            int viewCount = 0;
            if (ViewActions.this.viewContainer != null) {
                viewCount = ViewActions.this.viewContainer.getViewCount();
            }
            if (viewCount > 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.closeAllFilters();
        }
    }

    private class CloseOtherFiltersAction
    extends AbstractAction {
        private static final long serialVersionUID = -6399148183817841417L;

        public CloseOtherFiltersAction() {
            super("Close all other filters");
            this.putValue("SmallIcon", EMPTY_16_ICON);
            this.putValue("MnemonicKey", 111);
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command shift W");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void updateAction() {
            if (ViewActions.this.viewContainer != null) {
                int viewIndex = ViewActions.this.viewContainer.getViewIndex();
                int viewCount = ViewActions.this.viewContainer.getViewCount();
                if (viewIndex > -1 && (viewIndex == 0 && viewCount > 1 || viewCount > 2)) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.closeOtherFilters();
        }
    }

    private class CloseFilterAction
    extends AbstractAction {
        private static final long serialVersionUID = -842677137302613585L;

        public CloseFilterAction() {
            super("Close this filter");
            this.putValue("SmallIcon", EMPTY_16_ICON);
            this.putValue("MnemonicKey", 99);
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command W");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void updateAction() {
            if (ViewActions.this.viewContainer != null) {
                int viewIndex = ViewActions.this.viewContainer.getViewIndex();
                if (viewIndex > 0) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(false);
            }
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.closeCurrentFilter();
        }
    }

    private class ScrollToBottomToolBarAction
    extends AbstractAction {
        private static final long serialVersionUID = -7793074053120455264L;

        public ScrollToBottomToolBarAction() {
            this.putValue("SmallIcon", TAIL_TOOLBAR_ICON);
            this.putValue("ShortDescription", "Tail (\"scroll to bottom\")");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command T");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            boolean tail = !ViewActions.this.isScrollingToBottom();
            ViewActions.this.setScrollingToBottom(tail);
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("tail={}", tail);
            }
            ViewActions.this.focusTable();
        }
    }

    private class ScrollToBottomMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = -6698886479454486019L;
        private Icon selectedIcon;
        private Icon unselectedIcon;

        public ScrollToBottomMenuAction() {
            super("Tail");
            this.selectedIcon = TAIL_MENU_ICON;
            this.unselectedIcon = EMPTY_16_ICON;
            this.updateAction();
            this.putValue("ShortDescription", "Tail (\"scroll to bottom\")");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command T");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            boolean tail = !ViewActions.this.isScrollingToBottom();
            ViewActions.this.setScrollingToBottom(tail);
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("tail={}", tail);
            }
            ViewActions.this.focusTable();
        }

        public void updateAction() {
            if (ViewActions.this.isScrollingToBottom()) {
                this.putValue("SmallIcon", this.selectedIcon);
            } else {
                this.putValue("SmallIcon", this.unselectedIcon);
            }
        }
    }

    private class ResetFindAction
    extends AbstractAction {
        private static final long serialVersionUID = -1245378100755440576L;

        public ResetFindAction() {
            super("Reset find");
            this.putValue("SmallIcon", EMPTY_16_ICON);
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command shift F");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.resetFind();
        }
    }

    private class FindPreviousAction
    extends AbstractAction {
        private static final long serialVersionUID = -284066693780808511L;

        public FindPreviousAction() {
            super("Find previous");
            this.putValue("SmallIcon", FIND_PREV_MENU_ICON);
            this.putValue("ShortDescription", "Find previous match of the current filter.");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command G");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.findPrevious();
        }
    }

    private class FindNextAction
    extends AbstractAction {
        private static final long serialVersionUID = 4771628062043742857L;

        public FindNextAction() {
            super("Find next");
            this.putValue("SmallIcon", FIND_NEXT_MENU_ICON);
            this.putValue("ShortDescription", "Find next match of the current filter.");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command shift G");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.findNext();
        }
    }

    private class FocusEventsAction
    extends AbstractAction {
        private static final long serialVersionUID = 4207817900003297701L;

        public FocusEventsAction() {
            super("Focus events");
            this.putValue("SmallIcon", EMPTY_16_ICON);
            this.putValue("ShortDescription", "Focus the table containing the events.");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command E");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.focusEvents();
        }
    }

    private class FocusMessageAction
    extends AbstractAction {
        private static final long serialVersionUID = -421929316399318971L;

        public FocusMessageAction() {
            super("Focus message");
            this.putValue("SmallIcon", EMPTY_16_ICON);
            this.putValue("ShortDescription", "Focus detailed message view.");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command M");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.focusMessage();
        }
    }

    private class DisconnectToolBarAction
    extends AbstractAction {
        private static final long serialVersionUID = -8665004340745035737L;

        public DisconnectToolBarAction() {
            this.putValue("SmallIcon", DISCONNECT_TOOLBAR_ICON);
            this.putValue("ShortDescription", "Disconnect");
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.disconnect();
        }
    }

    private class DisconnectMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 8971640305824353589L;

        public DisconnectMenuAction() {
            super("Disconnect");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command shift D");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("SmallIcon", DISCONNECT_MENU_ICON);
            this.putValue("ShortDescription", "Terminates this connection");
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.disconnect();
        }
    }

    private class StatisticsToolBarAction
    extends AbstractAction {
        private static final long serialVersionUID = 2394035359331601001L;

        public StatisticsToolBarAction() {
            this.putValue("SmallIcon", STATISTICS_TOOLBAR_ICON);
            this.putValue("ShortDescription", "Statistics");
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.showStatistics();
        }
    }

    private class StatisticsMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = -6336357605789928345L;

        public StatisticsMenuAction() {
            super("Statistics");
            this.putValue("SmallIcon", STATISTICS_MENU_ICON);
            this.putValue("ShortDescription", "Statistics");
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.showStatistics();
        }
    }

    private class FindToolBarAction
    extends AbstractAction {
        private static final long serialVersionUID = -4080152597948489206L;

        public FindToolBarAction() {
            this.putValue("SmallIcon", FIND_TOOLBAR_ICON);
            this.putValue("ShortDescription", "Find");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command F");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.setShowingFilters(true);
        }
    }

    private class FindMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 2241714830900044485L;

        public FindMenuAction() {
            super("Find");
            this.putValue("SmallIcon", FIND_MENU_ITEM);
            this.putValue("ShortDescription", "Opens the Find panel.");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command F");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.setShowingFilters(true);
        }
    }

    private class PauseToolBarAction
    extends AbstractAction {
        private static final long serialVersionUID = -5118623805829814815L;
        private Icon pausedIcon = ViewActions.access$1600();
        private Icon unpausedIcon = ViewActions.access$1700();

        public PauseToolBarAction() {
            this.updateAction();
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command P");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.setPaused(!ViewActions.this.isPaused());
            this.updateAction();
            ViewActions.this.focusTable();
        }

        public void updateAction() {
            if (ViewActions.this.isPaused()) {
                this.putValue("SmallIcon", this.pausedIcon);
                this.putValue("ShortDescription", "Unpause");
            } else {
                this.putValue("SmallIcon", this.unpausedIcon);
                this.putValue("ShortDescription", "Pause");
            }
        }
    }

    private class PauseMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = -5242236903640590549L;
        private Icon pausedIcon = ViewActions.access$1400();
        private Icon unpausedIcon = ViewActions.access$1500();

        public PauseMenuAction() {
            this.updateAction();
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command P");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.setPaused(!ViewActions.this.isPaused());
            this.updateAction();
            ViewActions.this.focusTable();
        }

        public void updateAction() {
            if (ViewActions.this.isPaused()) {
                this.putValue("SmallIcon", this.pausedIcon);
                this.putValue("Name", "Unpause");
            } else {
                this.putValue("SmallIcon", this.unpausedIcon);
                this.putValue("Name", "Pause");
            }
        }
    }

    private class AttachToolBarAction
    extends AbstractAction {
        private static final long serialVersionUID = -6338324258055926639L;
        private Icon attachIcon = ViewActions.access$1200();
        private Icon detachIcon = ViewActions.access$1300();

        public AttachToolBarAction() {
            this.updateAction();
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.attachDetach();
            this.updateAction();
        }

        public void updateAction() {
            ViewContainer container = ViewActions.this.getViewContainer();
            if (container != null) {
                ViewWindow window = container.resolveViewWindow();
                if (window instanceof JInternalFrame) {
                    this.putValue("SmallIcon", this.detachIcon);
                    this.putValue("ShortDescription", "Detach");
                    return;
                }
                if (window instanceof JFrame) {
                    this.putValue("SmallIcon", this.attachIcon);
                    this.putValue("ShortDescription", "Attach");
                    return;
                }
            }
            this.putValue("SmallIcon", this.detachIcon);
            this.putValue("ShortDescription", "Detach");
        }
    }

    private class AttachMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = -6686061036755515933L;
        private Icon attachIcon = ViewActions.access$900();
        private Icon detachIcon = ViewActions.access$1000();

        public AttachMenuAction() {
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command shift A");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
            this.updateAction();
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.attachDetach();
            this.updateAction();
        }

        public void updateAction() {
            ViewContainer container = ViewActions.this.getViewContainer();
            if (container != null) {
                ViewWindow window = container.resolveViewWindow();
                if (window instanceof JInternalFrame) {
                    this.putValue("SmallIcon", this.detachIcon);
                    this.putValue("Name", "Detach");
                } else if (window instanceof JFrame) {
                    this.putValue("SmallIcon", this.attachIcon);
                    this.putValue("Name", "Attach");
                }
            }
        }
    }

    private class EditSourceNameMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 2807692748192366344L;

        public EditSourceNameMenuAction() {
            super("Edit source name...");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command B");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("SmallIcon", EMPTY_16_ICON);
            this.putValue("ShortDescription", "Edit the source name of the current view.");
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.editSourceName();
        }

        public void updateAction() {
            String sourceIdentifier;
            EventWrapperViewPanel eventWrapperViewPanel;
            boolean enable = false;
            if (ViewActions.this.viewContainer != null && (eventWrapperViewPanel = ViewActions.this.viewContainer.getSelectedView()) != null && !"global".equals(sourceIdentifier = eventWrapperViewPanel.getEventSource().getSourceIdentifier().getIdentifier()) && !"Lilith".equals(sourceIdentifier)) {
                enable = true;
            }
            this.setEnabled(enable);
        }
    }

    private class EditConditionMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = -8380709624103338783L;

        public EditConditionMenuAction() {
            super("Add condition...");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command I");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("SmallIcon", EMPTY_16_ICON);
            this.putValue("ShortDescription", "Add the condition of the current view.");
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.editCondition();
        }

        public void updateAction() {
            Condition condition;
            EventWrapperViewPanel eventWrapperViewPanel;
            boolean enable = false;
            if (ViewActions.this.viewContainer != null && (eventWrapperViewPanel = ViewActions.this.viewContainer.getSelectedView()) != null && (condition = eventWrapperViewPanel.getCombinedCondition()) != null) {
                enable = true;
            }
            this.setEnabled(enable);
        }
    }

    private class ClearMenuAction
    extends AbstractAction {
        private static final long serialVersionUID = 776175842981192877L;

        public ClearMenuAction() {
            super("Clear");
            this.putValue("SmallIcon", CLEAR_MENU_ICON);
            this.putValue("ShortDescription", "Clear this view.");
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.clear();
        }
    }

    private class ClearToolBarAction
    extends AbstractAction {
        private static final long serialVersionUID = -4713267797278778997L;

        public ClearToolBarAction() {
            this.putValue("SmallIcon", CLEAR_TOOLBAR_ICON);
            this.putValue("ShortDescription", "Clear");
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.clear();
        }
    }

    private class MinimizeAllOtherAction
    extends AbstractAction {
        private static final long serialVersionUID = -2357859864329239268L;

        public MinimizeAllOtherAction() {
            super("Minimize all other");
            this.putValue("SmallIcon", EMPTY_16_ICON);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.minimizeAllViews(ViewActions.this.viewContainer);
            ViewActions.this.mainFrame.updateWindowMenus();
        }
    }

    private class MinimizeAllAction
    extends AbstractAction {
        private static final long serialVersionUID = -8828005158469519472L;

        public MinimizeAllAction() {
            super("Minimize all");
            this.putValue("SmallIcon", EMPTY_16_ICON);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.minimizeAllViews(null);
            ViewActions.this.mainFrame.updateWindowMenus();
        }
    }

    private class CloseAllOtherAction
    extends AbstractAction {
        private static final long serialVersionUID = -3031217070975763827L;

        public CloseAllOtherAction() {
            super("Close all other");
            this.putValue("SmallIcon", EMPTY_16_ICON);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.closeAllViews(ViewActions.this.viewContainer);
            ViewActions.this.mainFrame.updateWindowMenus();
        }
    }

    private class CloseAllAction
    extends AbstractAction {
        private static final long serialVersionUID = -1587444647880660196L;

        public CloseAllAction() {
            super("Close all");
            this.putValue("SmallIcon", EMPTY_16_ICON);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.closeAllViews(null);
            ViewActions.this.mainFrame.updateWindowMenus();
        }
    }

    private class ShowTaskManagerAction
    extends AbstractAction {
        private static final long serialVersionUID = -8228641057263498624L;

        public ShowTaskManagerAction() {
            super("Task Manager");
            this.putValue("SmallIcon", EMPTY_16_ICON);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.showTaskManager();
        }
    }

    private class RemoveInactiveAction
    extends AbstractAction {
        private static final long serialVersionUID = -6662970580652310690L;

        public RemoveInactiveAction() {
            super("Remove inactive");
            this.putValue("SmallIcon", EMPTY_16_ICON);
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"command R");
            if (ViewActions.this.logger.isDebugEnabled()) {
                ViewActions.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("MnemonicKey", 114);
        }

        public void actionPerformed(ActionEvent e) {
            ViewActions.this.mainFrame.removeInactiveViews(false, false);
            ViewActions.this.mainFrame.updateWindowMenus();
        }
    }
}

