/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.consumers;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.engine.EventConsumer;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDbPool;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.Sample;
import org.rrd4j.core.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RrdLoggingEventConsumer
implements EventConsumer<LoggingEvent> {
    private final Logger logger = LoggerFactory.getLogger(RrdLoggingEventConsumer.class);
    public static final String TRACE = "" + LoggingEvent.Level.TRACE;
    public static final String DEBUG = "" + LoggingEvent.Level.DEBUG;
    public static final String INFO = "" + LoggingEvent.Level.INFO;
    public static final String WARN = "" + LoggingEvent.Level.WARN;
    public static final String ERROR = "" + LoggingEvent.Level.ERROR;
    public static final String TOTAL = "TOTAL";
    public static final String TRACE_DS_NAME = TRACE + "!";
    public static final String DEBUG_DS_NAME = DEBUG + "!";
    public static final String INFO_DS_NAME = INFO + "!";
    public static final String WARN_DS_NAME = WARN + "!";
    public static final String ERROR_DS_NAME = ERROR + "!";
    public static final String TOTAL_DS_NAME = "TOTAL!";
    private RrdDbPool pool = RrdDbPool.getInstance();
    private File basePath;

    public File getBasePath() {
        return this.basePath;
    }

    public void setBasePath(File basePath) {
        this.basePath = basePath;
    }

    public void consume(List<EventWrapper<LoggingEvent>> events) {
        HashMap<String, EventCounter> eventCounters = new HashMap<String, EventCounter>();
        EventCounter globalCounter = new EventCounter();
        for (EventWrapper<LoggingEvent> wrapper : events) {
            EventCounter eventCounter;
            LoggingEvent event = (LoggingEvent)wrapper.getEvent();
            if (event == null) continue;
            SourceIdentifier si = wrapper.getSourceIdentifier();
            String primary = si.getIdentifier();
            if (eventCounters.containsKey(primary)) {
                eventCounter = (EventCounter)eventCounters.get(primary);
            } else {
                eventCounter = new EventCounter();
                eventCounters.put(primary, eventCounter);
            }
            eventCounter.counters.get(TOTAL_DS_NAME).increase();
            globalCounter.counters.get(TOTAL_DS_NAME).increase();
            LoggingEvent.Level level = event.getLevel();
            if (LoggingEvent.Level.TRACE.equals((Object)level)) {
                eventCounter.counters.get(TRACE_DS_NAME).increase();
                globalCounter.counters.get(TRACE_DS_NAME).increase();
                continue;
            }
            if (LoggingEvent.Level.DEBUG.equals((Object)level)) {
                eventCounter.counters.get(DEBUG_DS_NAME).increase();
                globalCounter.counters.get(DEBUG_DS_NAME).increase();
                continue;
            }
            if (LoggingEvent.Level.INFO.equals((Object)level)) {
                eventCounter.counters.get(INFO_DS_NAME).increase();
                globalCounter.counters.get(INFO_DS_NAME).increase();
                continue;
            }
            if (LoggingEvent.Level.WARN.equals((Object)level)) {
                eventCounter.counters.get(WARN_DS_NAME).increase();
                globalCounter.counters.get(WARN_DS_NAME).increase();
                continue;
            }
            if (!LoggingEvent.Level.ERROR.equals((Object)level)) continue;
            eventCounter.counters.get(ERROR_DS_NAME).increase();
            globalCounter.counters.get(ERROR_DS_NAME).increase();
        }
        eventCounters.put("global", globalCounter);
        this.updateRrdFile(eventCounters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRrdFile(Map<String, EventCounter> eventCounters) {
        if (eventCounters.size() > 0) {
            long timestamp = Util.getTime();
            for (Map.Entry<String, EventCounter> current : eventCounters.entrySet()) {
                File rrdFile;
                EventCounter eventCounter;
                block17: {
                    String primary = current.getKey();
                    eventCounter = current.getValue();
                    rrdFile = new File(this.basePath, primary + ".rrd");
                    if (!rrdFile.isFile()) {
                        try {
                            this.createRrdFile(rrdFile, timestamp - 1L);
                        }
                        catch (IOException ex) {
                            if (!this.logger.isWarnEnabled()) break block17;
                            this.logger.warn("Exception while creating rrd-db '" + rrdFile.getAbsolutePath() + "'!", ex);
                        }
                    }
                }
                RrdDb rrd = null;
                try {
                    rrd = this.pool.requestRrdDb(rrdFile.getAbsolutePath());
                    Sample sample = rrd.createSample(timestamp);
                    for (Map.Entry<String, Counter> curCount : eventCounter.counters.entrySet()) {
                        String name = curCount.getKey();
                        Counter counter = curCount.getValue();
                        int counterValue = counter.getValue();
                        sample.setValue(name, (double)counterValue);
                        if (!this.logger.isDebugEnabled()) continue;
                        this.logger.debug("Setting rrd-db '{}' with counterValue[{}] {}.", new Object[]{rrdFile.getAbsolutePath(), name, counterValue});
                    }
                    sample.update();
                }
                catch (IOException ex) {
                    if (!this.logger.isWarnEnabled()) continue;
                    this.logger.warn("Exception while updating rrd-db '" + rrdFile.getAbsolutePath() + "'!", ex);
                }
                finally {
                    if (rrd == null) continue;
                    try {
                        this.pool.release(rrd);
                    }
                    catch (IOException ex) {
                        if (!this.logger.isWarnEnabled()) continue;
                        this.logger.warn("Exception while releasing rrd-db '" + rrdFile.getAbsolutePath() + "'!", ex);
                    }
                }
            }
        }
    }

    private void createRrdFile(File rrdFile, long timestamp) throws IOException {
        int stepSize = 2;
        int heartbeat = 4;
        File parent = rrdFile.getParentFile();
        parent.mkdirs();
        RrdDef rrdDef = new RrdDef(rrdFile.getAbsolutePath());
        rrdDef.setStartTime(timestamp);
        rrdDef.setStep(2L);
        rrdDef.addDatasource(TRACE_DS_NAME, DsType.ABSOLUTE, 4L, Double.NaN, Double.NaN);
        rrdDef.addDatasource(DEBUG_DS_NAME, DsType.ABSOLUTE, 4L, Double.NaN, Double.NaN);
        rrdDef.addDatasource(INFO_DS_NAME, DsType.ABSOLUTE, 4L, Double.NaN, Double.NaN);
        rrdDef.addDatasource(WARN_DS_NAME, DsType.ABSOLUTE, 4L, Double.NaN, Double.NaN);
        rrdDef.addDatasource(ERROR_DS_NAME, DsType.ABSOLUTE, 4L, Double.NaN, Double.NaN);
        rrdDef.addDatasource(TOTAL_DS_NAME, DsType.ABSOLUTE, 4L, Double.NaN, Double.NaN);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.5, 1, 650);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.7, 6, 650);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.8, 30, 650);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.999, 72, 650);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.999, 2160, 650);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.999, 6480, 650);
        rrdDef.addArchive(ConsolFun.AVERAGE, 0.999, 26352, 650);
        rrdDef.addArchive(ConsolFun.MAX, 0.5, 1, 650);
        rrdDef.addArchive(ConsolFun.MAX, 0.7, 6, 650);
        rrdDef.addArchive(ConsolFun.MAX, 0.8, 30, 650);
        rrdDef.addArchive(ConsolFun.MAX, 0.999, 72, 650);
        rrdDef.addArchive(ConsolFun.MAX, 0.999, 2160, 650);
        rrdDef.addArchive(ConsolFun.MAX, 0.999, 6480, 650);
        rrdDef.addArchive(ConsolFun.MAX, 0.999, 26352, 650);
        RrdDb rrdDb = new RrdDb(rrdDef);
        rrdDb.close();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Created rrd-db '" + rrdFile.getAbsolutePath() + "'.");
        }
    }

    private static class Counter {
        private int value = 0;

        private Counter() {
        }

        public void increase() {
            ++this.value;
        }

        public int getValue() {
            return this.value;
        }
    }

    private static class EventCounter {
        public final Map<String, Counter> counters = new HashMap<String, Counter>(6);

        public EventCounter() {
            this.counters.put(TRACE_DS_NAME, new Counter());
            this.counters.put(DEBUG_DS_NAME, new Counter());
            this.counters.put(INFO_DS_NAME, new Counter());
            this.counters.put(WARN_DS_NAME, new Counter());
            this.counters.put(ERROR_DS_NAME, new Counter());
            this.counters.put(RrdLoggingEventConsumer.TOTAL_DS_NAME, new Counter());
        }
    }
}

