/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging.xml;

import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import de.huxhorn.lilith.data.logging.LoggerContext;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.Marker;
import de.huxhorn.lilith.data.logging.Message;
import de.huxhorn.lilith.data.logging.ThreadInfo;
import de.huxhorn.lilith.data.logging.ThrowableInfo;
import de.huxhorn.lilith.data.logging.xml.LoggingEventSchemaConstants;
import de.huxhorn.lilith.data.logging.xml.StackTraceElementWriter;
import de.huxhorn.sulky.stax.DateTimeFormatter;
import de.huxhorn.sulky.stax.GenericStreamWriter;
import de.huxhorn.sulky.stax.StaxUtilities;
import de.huxhorn.sulky.stax.WhiteSpaceHandling;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingEventWriter
implements GenericStreamWriter<LoggingEvent>,
LoggingEventSchemaConstants {
    private String preferredPrefix;
    private String prefix;
    private boolean sortingMdcValues;
    private DateTimeFormatter dateTimeFormatter = new DateTimeFormatter();
    private boolean writingSchemaLocation;
    private TimeStampType timeStampType = TimeStampType.BOTH;

    public TimeStampType getTimeStampType() {
        return this.timeStampType;
    }

    public void setTimeStampType(TimeStampType timeStampType) {
        this.timeStampType = timeStampType;
    }

    public boolean isSortingMdcValues() {
        return this.sortingMdcValues;
    }

    public void setSortingMdcValues(boolean sortingMdcValues) {
        this.sortingMdcValues = sortingMdcValues;
    }

    public boolean isWritingSchemaLocation() {
        return this.writingSchemaLocation;
    }

    public void setWritingSchemaLocation(boolean writingSchemaLocation) {
        this.writingSchemaLocation = writingSchemaLocation;
    }

    public String getPreferredPrefix() {
        return this.preferredPrefix;
    }

    public void setPreferredPrefix(String prefix) {
        this.preferredPrefix = prefix;
    }

    public void write(XMLStreamWriter writer, LoggingEvent event, boolean isRoot) throws XMLStreamException {
        Message message;
        Long timeStamp;
        ThreadInfo threadInfo;
        if (isRoot) {
            writer.writeStartDocument("utf-8", "1.0");
        }
        StaxUtilities.NamespaceInfo ni = StaxUtilities.setNamespace((XMLStreamWriter)writer, (String)this.preferredPrefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"log");
        this.prefix = ni.getPrefix();
        StaxUtilities.writeStartElement((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"LoggingEvent");
        if (ni.isCreated()) {
            StaxUtilities.writeNamespace((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13");
        }
        if (isRoot && this.writingSchemaLocation) {
            ni = StaxUtilities.setNamespace((XMLStreamWriter)writer, (String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance", (String)"xsi");
            if (ni.isCreated()) {
                StaxUtilities.writeNamespace((XMLStreamWriter)writer, (String)ni.getPrefix(), (String)"http://www.w3.org/2001/XMLSchema-instance");
            }
            StaxUtilities.writeAttribute((XMLStreamWriter)writer, (boolean)true, (String)ni.getPrefix(), (String)"http://www.w3.org/2001/XMLSchema-instance", (String)"schemaLocation", (String)"http://lilith.sf.net/schema/logging/13 http://lilith.sf.net/schema/logging/13/LoggingEvent.xsd");
        }
        StaxUtilities.writeAttribute((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"logger", (String)event.getLogger());
        StaxUtilities.writeAttribute((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"level", (String)("" + event.getLevel()));
        Long sequence = event.getSequenceNumber();
        if (sequence != null) {
            StaxUtilities.writeAttribute((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"sequence", (String)sequence.toString());
        }
        if ((threadInfo = event.getThreadInfo()) != null) {
            Long id = threadInfo.getId();
            String name = threadInfo.getName();
            Long groupId = threadInfo.getGroupId();
            String groupName = threadInfo.getGroupName();
            if (name != null) {
                StaxUtilities.writeAttributeIfNotNull((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"threadName", (String)name);
            }
            if (id != null) {
                StaxUtilities.writeAttributeIfNotNull((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"threadId", (String)("" + id));
            }
            if (groupName != null) {
                StaxUtilities.writeAttributeIfNotNull((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"threadGroup", (String)groupName);
            }
            if (groupId != null) {
                StaxUtilities.writeAttributeIfNotNull((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"threadGroupId", (String)("" + groupId));
            }
        }
        if ((timeStamp = event.getTimeStamp()) != null) {
            if (this.timeStampType == TimeStampType.ONLY_TIMESTAMP || this.timeStampType == TimeStampType.BOTH) {
                StaxUtilities.writeAttribute((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"timeStamp", (String)this.dateTimeFormatter.format(new Date(timeStamp)));
            }
            if (this.timeStampType == TimeStampType.ONLY_MILLIS || this.timeStampType == TimeStampType.BOTH) {
                StaxUtilities.writeAttribute((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"timeStampMillis", (String)("" + timeStamp));
            }
        }
        if ((message = event.getMessage()) != null) {
            String messagePattern = message.getMessagePattern();
            if (messagePattern != null) {
                StaxUtilities.writeSimpleTextNode((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"Message", (String)messagePattern);
            }
            this.writeArguments(writer, message.getArguments());
        }
        this.writeThrowable(writer, event);
        this.writeStringMap(writer, event.getMdc(), "MDC");
        this.writeNdc(writer, event);
        this.writeMarker(writer, event);
        this.writeCallStack(writer, event);
        this.writeLoggerContext(writer, event);
        writer.writeEndElement();
        if (isRoot) {
            writer.writeEndDocument();
        }
    }

    private void writeLoggerContext(XMLStreamWriter writer, LoggingEvent event) throws XMLStreamException {
        Long timeStamp;
        LoggerContext context = event.getLoggerContext();
        if (context == null) {
            return;
        }
        StaxUtilities.writeStartElement((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"LoggerContext");
        String name = context.getName();
        if (name != null) {
            StaxUtilities.writeAttribute((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"name", (String)name);
        }
        if ((timeStamp = context.getBirthTime()) != null) {
            if (this.timeStampType == TimeStampType.ONLY_TIMESTAMP || this.timeStampType == TimeStampType.BOTH) {
                StaxUtilities.writeAttribute((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"birthTime", (String)this.dateTimeFormatter.format(new Date(timeStamp)));
            }
            if (this.timeStampType == TimeStampType.ONLY_MILLIS || this.timeStampType == TimeStampType.BOTH) {
                StaxUtilities.writeAttribute((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"birthTimeMillis", (String)("" + timeStamp));
            }
        }
        this.writeStringMap(writer, context.getProperties(), "Properties");
        writer.writeEndElement();
    }

    private void writeCallStack(XMLStreamWriter writer, LoggingEvent event) throws XMLStreamException {
        this.writeStackTraceNode(writer, event.getCallStack(), "CallStack");
    }

    private void writeMarker(XMLStreamWriter writer, LoggingEvent event) throws XMLStreamException {
        Marker marker = event.getMarker();
        if (marker != null) {
            ArrayList<String> handledMarkers = new ArrayList<String>();
            this.writeMarkerNode(writer, marker, handledMarkers);
        }
    }

    private void writeMarkerNode(XMLStreamWriter writer, Marker marker, List<String> handledMarkers) throws XMLStreamException {
        String markerName = marker.getName();
        if (handledMarkers.contains(markerName)) {
            StaxUtilities.writeEmptyElement((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"MarkerReference");
            StaxUtilities.writeAttribute((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"ref", (String)markerName);
        } else {
            handledMarkers.add(markerName);
            boolean hasChildren = marker.hasReferences();
            if (hasChildren) {
                StaxUtilities.writeStartElement((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"Marker");
            } else {
                StaxUtilities.writeEmptyElement((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"Marker");
            }
            StaxUtilities.writeAttribute((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"name", (String)markerName);
            if (hasChildren) {
                Map children = marker.getReferences();
                for (Map.Entry current : children.entrySet()) {
                    this.writeMarkerNode(writer, (Marker)current.getValue(), handledMarkers);
                }
                writer.writeEndElement();
            }
        }
    }

    private void writeStringMap(XMLStreamWriter writer, Map<String, String> map, String nodeName) throws XMLStreamException {
        if (map != null) {
            if (this.sortingMdcValues) {
                map = new TreeMap<String, String>(map);
            }
            StaxUtilities.writeStartElement((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)nodeName);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                StaxUtilities.writeStartElement((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"Entry");
                StaxUtilities.writeAttribute((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"key", (String)entry.getKey(), (WhiteSpaceHandling)WhiteSpaceHandling.PRESERVE_NORMALIZE_NEWLINE);
                StaxUtilities.writeText((XMLStreamWriter)writer, (String)entry.getValue());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeNdc(XMLStreamWriter writer, LoggingEvent event) throws XMLStreamException {
        Message[] ndc = event.getNdc();
        if (ndc != null) {
            StaxUtilities.writeStartElement((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"NDC");
            for (Message entry : ndc) {
                StaxUtilities.writeStartElement((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"Entry");
                StaxUtilities.writeSimpleTextNode((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"Message", (String)entry.getMessagePattern());
                this.writeArguments(writer, entry.getArguments());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeArguments(XMLStreamWriter writer, String[] arguments) throws XMLStreamException {
        if (arguments != null) {
            StaxUtilities.writeStartElement((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"Arguments");
            for (String current : arguments) {
                if (current == null) {
                    StaxUtilities.writeEmptyElement((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"null");
                    continue;
                }
                StaxUtilities.writeSimpleTextNode((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"Argument", (String)current);
            }
            writer.writeEndElement();
        }
    }

    private void writeThrowable(XMLStreamWriter writer, LoggingEvent event) throws XMLStreamException {
        ThrowableInfo throwable = event.getThrowable();
        this.writeThrowableNode(writer, throwable, "Throwable");
    }

    private void writeThrowableNode(XMLStreamWriter writer, ThrowableInfo throwable, String nodeName) throws XMLStreamException {
        if (throwable != null) {
            StaxUtilities.writeStartElement((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)nodeName);
            StaxUtilities.writeAttribute((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"name", (String)throwable.getName());
            int omitted = throwable.getOmittedElements();
            if (omitted != 0) {
                StaxUtilities.writeAttribute((XMLStreamWriter)writer, (boolean)false, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"omittedElements", (String)("" + throwable.getOmittedElements()));
            }
            StaxUtilities.writeSimpleTextNode((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)"Message", (String)throwable.getMessage());
            this.writeStackTraceNode(writer, throwable.getStackTrace(), "StackTrace");
            this.writeThrowableNode(writer, throwable.getCause(), "Cause");
            writer.writeEndElement();
        }
    }

    private void writeStackTraceNode(XMLStreamWriter writer, ExtendedStackTraceElement[] ste, String nodeName) throws XMLStreamException {
        if (ste != null) {
            StaxUtilities.writeStartElement((XMLStreamWriter)writer, (String)this.prefix, (String)"http://lilith.sf.net/schema/logging/13", (String)nodeName);
            StackTraceElementWriter steWriter = new StackTraceElementWriter();
            steWriter.setPreferredPrefix(this.prefix);
            for (ExtendedStackTraceElement elem : ste) {
                steWriter.write(writer, elem, false);
            }
            writer.writeEndElement();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TimeStampType {
        ONLY_TIMESTAMP,
        ONLY_MILLIS,
        BOTH;

    }
}

