/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging.protobuf;

import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import de.huxhorn.lilith.data.logging.LoggerContext;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.Marker;
import de.huxhorn.lilith.data.logging.Message;
import de.huxhorn.lilith.data.logging.ThreadInfo;
import de.huxhorn.lilith.data.logging.ThrowableInfo;
import de.huxhorn.lilith.data.logging.protobuf.generated.LoggingProto;
import de.huxhorn.sulky.codec.Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingEventProtobufEncoder
implements Encoder<LoggingEvent> {
    private boolean compressing;

    public LoggingEventProtobufEncoder(boolean compressing) {
        this.compressing = compressing;
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
    }

    public byte[] encode(LoggingEvent event) {
        LoggingProto.LoggingEvent converted = LoggingEventProtobufEncoder.convert(event);
        if (converted == null) {
            return null;
        }
        if (!this.compressing) {
            return converted.toByteArray();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gos = new GZIPOutputStream(out);
            converted.writeTo(gos);
            gos.flush();
            gos.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static LoggingProto.Marker convert(Marker marker) {
        if (marker == null) {
            return null;
        }
        ArrayList<String> handledMarkers = new ArrayList<String>();
        return LoggingEventProtobufEncoder.convert(marker, handledMarkers);
    }

    private static LoggingProto.Marker convert(Marker marker, List<String> handledMarkers) {
        String markerName = marker.getName();
        LoggingProto.Marker.Builder builder = LoggingProto.Marker.newBuilder().setName(markerName);
        if (handledMarkers.contains(markerName)) {
            return builder.build();
        }
        handledMarkers.add(markerName);
        boolean hasReferences = marker.hasReferences();
        if (hasReferences) {
            Map refs = marker.getReferences();
            for (Map.Entry current : refs.entrySet()) {
                builder.addReference(LoggingEventProtobufEncoder.convert((Marker)current.getValue(), handledMarkers));
            }
        }
        return builder.build();
    }

    public static LoggingProto.StackTraceElement convert(ExtendedStackTraceElement ste) {
        String version;
        String fileName;
        String className;
        if (ste == null) {
            return null;
        }
        LoggingProto.StackTraceElement.Builder builder = LoggingProto.StackTraceElement.newBuilder();
        String methodName = ste.getMethodName();
        if (methodName != null) {
            builder.setMethodName(methodName);
        }
        if ((className = ste.getClassName()) != null) {
            builder.setClassName(className);
        }
        if ((fileName = ste.getFileName()) != null) {
            builder.setFileName(fileName);
        }
        int lineNumber = ste.getLineNumber();
        builder.setLineNumber(lineNumber);
        String codeLocation = ste.getCodeLocation();
        if (codeLocation != null) {
            builder.setCodeLocation(codeLocation);
        }
        if ((version = ste.getVersion()) != null) {
            builder.setVersion(version);
        }
        builder.setExact(ste.isExact());
        return builder.build();
    }

    public static LoggingProto.Throwable convert(ThrowableInfo throwableInfo) {
        ExtendedStackTraceElement[] stackTrace;
        ThrowableInfo cause;
        int omittedElements;
        String message;
        if (throwableInfo == null) {
            return null;
        }
        LoggingProto.Throwable.Builder builder = LoggingProto.Throwable.newBuilder();
        String name = throwableInfo.getName();
        if (name != null) {
            builder.setThrowableClass(name);
        }
        if ((message = throwableInfo.getMessage()) != null) {
            builder.setMessage(message);
        }
        if ((omittedElements = throwableInfo.getOmittedElements()) > 0) {
            builder.setOmittedElements(omittedElements);
        }
        if ((cause = throwableInfo.getCause()) != null) {
            builder.setCause(LoggingEventProtobufEncoder.convert(cause));
        }
        if ((stackTrace = throwableInfo.getStackTrace()) != null) {
            for (ExtendedStackTraceElement current : stackTrace) {
                if (current == null) continue;
                builder.addStackTraceElement(LoggingEventProtobufEncoder.convert(current));
            }
        }
        return builder.build();
    }

    public static LoggingProto.Message convert(Message message) {
        if (message == null) {
            return null;
        }
        LoggingProto.Message.Builder messageBuilder = LoggingProto.Message.newBuilder();
        messageBuilder.setMessagePattern(message.getMessagePattern());
        String[] arguments = message.getArguments();
        if (arguments != null) {
            for (String current : arguments) {
                LoggingProto.MessageArgument.Builder argumentBuilder = LoggingProto.MessageArgument.newBuilder();
                if (current != null) {
                    argumentBuilder.setValue(current);
                }
                messageBuilder.addArgument(argumentBuilder.build());
            }
        }
        return messageBuilder.build();
    }

    public static LoggingProto.ThreadInfo convert(ThreadInfo threadInfo) {
        Long id;
        if (threadInfo == null) {
            return null;
        }
        LoggingProto.ThreadInfo.Builder builder = LoggingProto.ThreadInfo.newBuilder();
        String name = threadInfo.getName();
        if (name != null) {
            builder.setName(name);
        }
        if ((id = threadInfo.getId()) != null) {
            builder.setId(id);
        }
        if ((name = threadInfo.getGroupName()) != null) {
            builder.setGroupName(name);
        }
        if ((id = threadInfo.getGroupId()) != null) {
            builder.setGroupId(id);
        }
        return builder.build();
    }

    public static LoggingProto.LoggerContext convert(LoggerContext context) {
        Map map;
        Long birthTime;
        if (context == null) {
            return null;
        }
        LoggingProto.LoggerContext.Builder builder = LoggingProto.LoggerContext.newBuilder();
        String name = context.getName();
        if (name != null) {
            builder.setName(name);
        }
        if ((birthTime = context.getBirthTime()) != null) {
            builder.setBirthTime(birthTime);
        }
        if ((map = context.getProperties()) != null && map.size() > 0) {
            builder.setProperties(LoggingEventProtobufEncoder.convert(map));
        }
        return builder.build();
    }

    public static LoggingProto.StringMap convert(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        LoggingProto.StringMap.Builder builder = LoggingProto.StringMap.newBuilder();
        for (Map.Entry<String, String> current : map.entrySet()) {
            LoggingProto.StringMapEntry.Builder entryBuilder = LoggingProto.StringMapEntry.newBuilder().setKey(current.getKey());
            String value = current.getValue();
            if (value != null) {
                entryBuilder.setValue(value);
            }
            builder.addEntry(entryBuilder.build());
        }
        return builder.build();
    }

    public static LoggingProto.LoggingEvent convert(LoggingEvent event) {
        Message[] ndc;
        Map mdc;
        Message message;
        Long timeStamp;
        ExtendedStackTraceElement[] callStack;
        Marker marker;
        ThrowableInfo throwable;
        LoggerContext context;
        LoggingEvent.Level level;
        ThreadInfo threadInfo;
        Long sequence;
        if (event == null) {
            return null;
        }
        LoggingProto.LoggingEvent.Builder eventBuilder = LoggingProto.LoggingEvent.newBuilder();
        String loggerName = event.getLogger();
        if (loggerName != null) {
            eventBuilder.setLoggerName(loggerName);
        }
        if ((sequence = event.getSequenceNumber()) != null) {
            eventBuilder.setSequenceNumber(sequence);
        }
        if ((threadInfo = event.getThreadInfo()) != null) {
            eventBuilder.setThreadInfo(LoggingEventProtobufEncoder.convert(threadInfo));
        }
        if ((level = event.getLevel()) != null) {
            switch (level) {
                case TRACE: {
                    eventBuilder.setLevel(LoggingProto.Level.TRACE);
                    break;
                }
                case DEBUG: {
                    eventBuilder.setLevel(LoggingProto.Level.DEBUG);
                    break;
                }
                case INFO: {
                    eventBuilder.setLevel(LoggingProto.Level.INFO);
                    break;
                }
                case WARN: {
                    eventBuilder.setLevel(LoggingProto.Level.WARN);
                    break;
                }
                case ERROR: {
                    eventBuilder.setLevel(LoggingProto.Level.ERROR);
                }
            }
        }
        if ((context = event.getLoggerContext()) != null) {
            eventBuilder.setLoggerContext(LoggingEventProtobufEncoder.convert(context));
        }
        if ((throwable = event.getThrowable()) != null) {
            eventBuilder.setThrowable(LoggingEventProtobufEncoder.convert(throwable));
        }
        if ((marker = event.getMarker()) != null) {
            eventBuilder.setMarker(LoggingEventProtobufEncoder.convert(marker));
        }
        if ((callStack = event.getCallStack()) != null) {
            for (ExtendedStackTraceElement current : callStack) {
                if (current == null) continue;
                eventBuilder.addCallStackElement(LoggingEventProtobufEncoder.convert(current));
            }
        }
        if ((timeStamp = event.getTimeStamp()) != null) {
            eventBuilder.setTimeStamp(timeStamp);
        }
        if ((message = event.getMessage()) != null) {
            eventBuilder.setMessage(LoggingEventProtobufEncoder.convert(message));
        }
        if ((mdc = event.getMdc()) != null && mdc.size() > 0) {
            eventBuilder.setMappedDiagnosticContext(LoggingEventProtobufEncoder.convert(mdc));
        }
        if ((ndc = event.getNdc()) != null && ndc.length > 0) {
            LoggingProto.NestedDiagnosticContext.Builder ndcBuilder = LoggingProto.NestedDiagnosticContext.newBuilder();
            for (Message currentMessage : ndc) {
                ndcBuilder.addEntry(LoggingEventProtobufEncoder.convert(currentMessage));
            }
            eventBuilder.setNestedDiagnosticContext(ndcBuilder.build());
        }
        return eventBuilder.build();
    }
}

