/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.taskmanager.table;

import de.huxhorn.sulky.tasks.Task;
import java.awt.Component;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskProgressRenderer
implements TableCellRenderer {
    private final Logger logger = LoggerFactory.getLogger(TaskProgressRenderer.class);
    private JProgressBar progressBar = new JProgressBar();

    public TaskProgressRenderer() {
        this.progressBar.setStringPainted(true);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
        int progress = -1;
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Object: {}", value);
        }
        if (value instanceof Integer) {
            progress = (Integer)value;
        } else if (value instanceof Task) {
            Task task = (Task)value;
            progress = task.getProgress();
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Progress: {}", progress);
        }
        if (progress < 0) {
            this.progressBar.setValue(0);
            this.progressBar.setString("Unknown");
        } else {
            this.progressBar.setValue(progress);
            this.progressBar.setString("" + progress + "%");
        }
        return this.progressBar;
    }
}

