/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.taskmanager;

import de.huxhorn.lilith.swing.taskmanager.table.TaskTable;
import de.huxhorn.sulky.swing.Tables;
import de.huxhorn.sulky.tasks.Task;
import de.huxhorn.sulky.tasks.TaskManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskManagerPanel<T>
extends JPanel {
    private final Logger logger = LoggerFactory.getLogger(TaskManagerPanel.class);
    private static final Icon CANCEL_TOOLBAR_ICON;
    private CancelTaskAction cancelAction;
    private TaskTable<T> table;
    private JPopupMenu popup;
    private JTextArea details;

    public TaskManagerPanel(TaskManager<T> taskManager) {
        this.setLayout(new BorderLayout());
        this.table = new TaskTable<T>(taskManager);
        ListSelectionModel rowSM = this.table.getSelectionModel();
        rowSM.addListSelectionListener(new TaskSelectionListener());
        this.table.addMouseListener(new TaskTableMouseListener());
        this.cancelAction = new CancelTaskAction();
        JToolBar toolBar = new JToolBar();
        toolBar.add(this.cancelAction);
        toolBar.setFloatable(false);
        this.details = new JTextArea();
        this.details.setLineWrap(true);
        this.details.setWrapStyleWord(true);
        this.details.setEditable(false);
        JScrollPane tableScrollPane = new JScrollPane(this.table);
        JScrollPane detailsScrollPane = new JScrollPane(this.details, 20, 31);
        JSplitPane splitPane = new JSplitPane(0, tableScrollPane, detailsScrollPane);
        splitPane.setResizeWeight(0.5);
        splitPane.setOneTouchExpandable(true);
        this.add((Component)toolBar, "North");
        this.add((Component)splitPane, "Center");
        this.popup = new JPopupMenu();
        this.popup.add(this.cancelAction);
    }

    public void setPaused(boolean paused) {
        this.table.setPaused(paused);
    }

    public boolean isPaused() {
        return this.table.isPaused();
    }

    private void setSelectedTask(Task<T> task) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Selected task {}.", task);
        }
        this.cancelAction.setTask(task);
        if (task != null && task.getDescription() != null) {
            this.details.setText(task.getDescription());
        } else {
            this.details.setText("");
        }
    }

    static {
        URL url = TaskManagerPanel.class.getResource("/tango/16x16/actions/process-stop.png");
        ImageIcon icon = url != null ? new ImageIcon(url) : null;
        CANCEL_TOOLBAR_ICON = icon;
    }

    private class TaskTableMouseListener
    implements MouseListener {
        private TaskTableMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e.getPoint());
            } else if (e.getButton() == 1 && e.getClickCount() > 1) {
                TaskManagerPanel.this.cancelAction.actionPerformed(null);
            }
        }

        public void mousePressed(MouseEvent e) {
            Point p = e.getPoint();
            TaskManagerPanel.this.table.getTaskAt(p, true);
            if (e.isPopupTrigger()) {
                this.showPopup(e.getPoint());
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e.getPoint());
            }
        }

        public void mouseEntered(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e.getPoint());
            }
        }

        public void mouseExited(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e.getPoint());
            }
        }

        private void showPopup(Point p) {
            TaskManagerPanel.this.popup.show(TaskManagerPanel.this.table, p.x, p.y);
        }
    }

    class CancelTaskAction
    extends AbstractAction {
        private static final long serialVersionUID = -2004455657443480819L;
        private Task task;

        public CancelTaskAction() {
            super("Cancel task");
            this.putValue("SmallIcon", CANCEL_TOOLBAR_ICON);
            this.putValue("ShortDescription", "Cancels the selected task.");
            this.setEnabled(false);
        }

        public Task getTask() {
            return this.task;
        }

        public void setTask(Task task) {
            this.task = task;
            this.setEnabled(this.task != null);
        }

        public void actionPerformed(ActionEvent e) {
            if (this.task != null) {
                if (TaskManagerPanel.this.logger.isInfoEnabled()) {
                    TaskManagerPanel.this.logger.info("Cancel task {}.", this.task);
                }
                this.task.getFuture().cancel(true);
            }
        }
    }

    private class TaskSelectionListener
    implements ListSelectionListener {
        private TaskSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (lsm.isSelectionEmpty()) {
                TaskManagerPanel.this.setSelectedTask(null);
            } else {
                int selectedRow = lsm.getMinSelectionIndex();
                selectedRow = Tables.convertRowIndexToModel((JTable)TaskManagerPanel.this.table, (int)selectedRow);
                Task task = TaskManagerPanel.this.table.getTaskTableModel().getValueAt(selectedRow);
                TaskManagerPanel.this.setSelectedTask(task);
            }
        }
    }
}

