/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.table.renderer;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.swing.table.Colors;
import de.huxhorn.lilith.swing.table.ColorsProvider;
import de.huxhorn.lilith.swing.table.renderer.LabelCellRenderer;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class IdRenderer
implements TableCellRenderer {
    private LabelCellRenderer renderer = new LabelCellRenderer();

    public IdRenderer() {
        this.renderer.setHorizontalAlignment(4);
        this.renderer.setHorizontalAlignment(0);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
        if (!isSelected) {
            boolean bl = isSelected = rowIndex == LabelCellRenderer.getSelectedRow(table);
        }
        if (!hasFocus && isSelected) {
            hasFocus = table.isFocusOwner();
        }
        this.renderer.setSelected(isSelected);
        this.renderer.setFocused(hasFocus);
        Color foreground = Color.BLACK;
        String text = "";
        if (value instanceof EventWrapper) {
            EventWrapper wrapper = (EventWrapper)value;
            text = "" + wrapper.getLocalId();
        }
        this.renderer.setText(text);
        this.renderer.setToolTipText(null);
        this.renderer.setIcon(null);
        boolean colorsInitialized = false;
        if (value instanceof EventWrapper) {
            EventWrapper wrapper = (EventWrapper)value;
            if (table instanceof ColorsProvider) {
                ColorsProvider cp = (ColorsProvider)((Object)table);
                Colors colors = cp.resolveColors(wrapper, rowIndex, vColIndex);
                colorsInitialized = this.renderer.updateColors(colors);
            }
        }
        if (!colorsInitialized) {
            this.renderer.setForeground(foreground);
        }
        this.renderer.correctRowHeight(table);
        return this.renderer;
    }
}

