/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.statistics;

import de.huxhorn.lilith.consumers.RrdLoggingEventConsumer;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.statistics.AbstractGraphImageProducer;
import java.awt.Color;
import java.awt.Paint;
import org.rrd4j.ConsolFun;
import org.rrd4j.graph.RrdGraphDef;

public class SevenDaysProducer
extends AbstractGraphImageProducer {
    public SevenDaysProducer(MainFrame mainFrame) {
        super(mainFrame);
    }

    public RrdGraphDef getGraphDef(long nowInSeconds, SourceIdentifier sourceIdentifier, boolean showMax) {
        String description;
        ConsolFun consolFun;
        String absoluteRrdPath = this.getRrdFile(sourceIdentifier).getAbsolutePath();
        RrdGraphDef graphDef = new RrdGraphDef();
        graphDef.setColor(0, (Paint)new Color(204, 204, 204));
        graphDef.setNoMinorGrid(true);
        graphDef.setShowSignature(false);
        graphDef.setMinValue(0.0);
        graphDef.setAltAutoscaleMax(true);
        graphDef.setAltYGrid(false);
        graphDef.setTimeAxis(11, 1, 11, 6, 5, 1, 0, "yyyy-MM-dd");
        graphDef.setFilename("-");
        graphDef.setImageFormat("PNG");
        if (showMax) {
            consolFun = ConsolFun.MAX;
            description = " (max.)";
        } else {
            consolFun = ConsolFun.AVERAGE;
            description = " (avg.)";
        }
        graphDef.setVerticalLabel("Events/s" + description);
        graphDef.datasource(RrdLoggingEventConsumer.TRACE, absoluteRrdPath, RrdLoggingEventConsumer.TRACE_DS_NAME, consolFun);
        graphDef.datasource(RrdLoggingEventConsumer.DEBUG, absoluteRrdPath, RrdLoggingEventConsumer.DEBUG_DS_NAME, consolFun);
        graphDef.datasource(RrdLoggingEventConsumer.INFO, absoluteRrdPath, RrdLoggingEventConsumer.INFO_DS_NAME, consolFun);
        graphDef.datasource(RrdLoggingEventConsumer.WARN, absoluteRrdPath, RrdLoggingEventConsumer.WARN_DS_NAME, consolFun);
        graphDef.datasource(RrdLoggingEventConsumer.ERROR, absoluteRrdPath, RrdLoggingEventConsumer.ERROR_DS_NAME, consolFun);
        graphDef.area(RrdLoggingEventConsumer.TRACE, (Paint)new Color(0, 0, 255), RrdLoggingEventConsumer.TRACE);
        graphDef.stack(RrdLoggingEventConsumer.DEBUG, (Paint)new Color(0, 255, 0), RrdLoggingEventConsumer.DEBUG);
        graphDef.stack(RrdLoggingEventConsumer.INFO, (Paint)new Color(255, 255, 255), RrdLoggingEventConsumer.INFO);
        graphDef.stack(RrdLoggingEventConsumer.WARN, (Paint)new Color(255, 255, 0), RrdLoggingEventConsumer.WARN);
        graphDef.stack(RrdLoggingEventConsumer.ERROR, (Paint)new Color(255, 0, 0), RrdLoggingEventConsumer.ERROR);
        if (showMax) {
            graphDef.datasource("TOTAL", absoluteRrdPath, "TOTAL!", consolFun);
            graphDef.line("TOTAL", (Paint)Color.BLACK, "TOTAL");
        }
        graphDef.setAntiAliasing(true);
        graphDef.setLazy(false);
        String sourceTitle = this.createGraphTitle(sourceIdentifier);
        long before = nowInSeconds - 604800L;
        graphDef.setTimeSpan(before, nowInSeconds);
        graphDef.setTitle(sourceTitle);
        graphDef.setWidth(this.graphSize.width);
        graphDef.setHeight(this.graphSize.height);
        return graphDef;
    }
}

