/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.EventWrapperViewPanel;
import de.huxhorn.lilith.swing.filefilters.Mp3FileFilter;
import de.huxhorn.lilith.swing.preferences.PreferencesDialog;
import de.huxhorn.lilith.swing.preferences.SoundLocationTableModel;
import de.huxhorn.sulky.sounds.Sounds;
import de.huxhorn.sulky.sounds.jlayer.JLayerSounds;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoundsPanel
extends JPanel {
    final Logger logger = LoggerFactory.getLogger(SoundsPanel.class);
    private BrowseSoundAction browseSoundAction;
    private PlaySoundAction playSoundAction;
    private JCheckBox muteCheckbox;
    private JFileChooser soundFileChooser;
    private SoundLocationTableModel soundLocationTableModel;
    private JTable soundLocationTable;
    private Sounds sounds;
    private PreferencesDialog preferencesDialog;
    private ApplicationPreferences applicationPreferences;

    public SoundsPanel(PreferencesDialog preferencesDialog) {
        this.preferencesDialog = preferencesDialog;
        this.applicationPreferences = preferencesDialog.getApplicationPreferences();
        this.sounds = new JLayerSounds();
        this.createUI();
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        this.muteCheckbox = new JCheckBox("Mute");
        this.muteCheckbox.addActionListener(new MuteActionListener());
        this.soundFileChooser = new JFileChooser();
        this.soundFileChooser.setFileSelectionMode(0);
        Mp3FileFilter mp3FileFilter = new Mp3FileFilter();
        this.soundFileChooser.setFileFilter(mp3FileFilter);
        HashMap<String, String> soundLocations = new HashMap<String, String>();
        this.soundLocationTableModel = new SoundLocationTableModel(soundLocations);
        this.soundLocationTable = new JTable(this.soundLocationTableModel);
        this.soundLocationTable.setRowSelectionAllowed(true);
        this.soundLocationTable.setColumnSelectionAllowed(false);
        ListSelectionModel soundRowSelectionModel = this.soundLocationTable.getSelectionModel();
        soundRowSelectionModel.setSelectionMode(0);
        soundRowSelectionModel.addListSelectionListener(new SoundLocationTableRowSelectionListener());
        JScrollPane soundLocationTableScrollPane = new JScrollPane(this.soundLocationTable);
        JPanel soundLocationsPanel = new JPanel(new GridLayout(1, 1));
        soundLocationsPanel.add(soundLocationTableScrollPane);
        JToolBar soundLocationsToolbar = new JToolBar();
        soundLocationsToolbar.setFloatable(false);
        this.playSoundAction = new PlaySoundAction();
        this.browseSoundAction = new BrowseSoundAction();
        JButton browseSoundButton = new JButton(this.browseSoundAction);
        JButton playButton = new JButton(this.playSoundAction);
        soundLocationsToolbar.add(browseSoundButton);
        soundLocationsToolbar.add(playButton);
        soundLocationsToolbar.add(this.muteCheckbox);
        this.add((Component)soundLocationsToolbar, "North");
        this.add((Component)soundLocationsPanel, "Center");
    }

    public void initUI() {
        boolean mute = this.applicationPreferences.isMute();
        Map<String, String> soundLocations = this.applicationPreferences.getSoundLocations();
        if (soundLocations == null) {
            soundLocations = new HashMap<String, String>();
        }
        this.soundLocationTableModel.setData(soundLocations);
        this.sounds.setSoundLocations(soundLocations);
        this.updateSounds(mute);
    }

    public void saveSettings() {
        this.applicationPreferences.setMute(this.muteCheckbox.isSelected());
        this.applicationPreferences.setSoundLocations(this.soundLocationTableModel.getData());
    }

    private void updateSounds(boolean mute) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Updating mute settings... mute={}", mute);
        }
        this.muteCheckbox.setSelected(mute);
        this.soundLocationTable.setEnabled(!mute);
        int selectedRow = this.soundLocationTable.getSelectedRow();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("selectedRow={}", selectedRow);
        }
        this.playSoundAction.setEnabled(!mute && selectedRow != -1);
        this.browseSoundAction.setEnabled(!mute && selectedRow != -1);
    }

    private class BrowseSoundAction
    extends AbstractAction {
        public BrowseSoundAction() {
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/actions/document-open.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Browse for a sound file.");
        }

        public void actionPerformed(ActionEvent e) {
            SoundsPanel.this.soundFileChooser.setCurrentDirectory(SoundsPanel.this.applicationPreferences.getSoundPath());
            int returnVal = SoundsPanel.this.soundFileChooser.showDialog(SoundsPanel.this.preferencesDialog, "Select");
            if (returnVal == 0) {
                File file = SoundsPanel.this.soundFileChooser.getSelectedFile();
                String selectedFile = file.getAbsolutePath();
                int row = SoundsPanel.this.soundLocationTable.getSelectedRow();
                if (row != -1) {
                    SoundsPanel.this.soundLocationTable.setValueAt(selectedFile, row, 1);
                    if (SoundsPanel.this.logger.isDebugEnabled()) {
                        SoundsPanel.this.logger.debug("Set sound to {}.", (Object)selectedFile);
                    }
                }
                File parent = file.getParentFile();
                SoundsPanel.this.applicationPreferences.setSoundPath(parent);
            }
        }
    }

    private class PlaySoundAction
    extends AbstractAction {
        public PlaySoundAction() {
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/actions/media-playback-start.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Play the selected sound.");
        }

        public void actionPerformed(ActionEvent e) {
            int row;
            if (SoundsPanel.this.logger.isDebugEnabled()) {
                SoundsPanel.this.logger.debug("Play");
            }
            if (SoundsPanel.this.sounds != null && (row = SoundsPanel.this.soundLocationTable.getSelectedRow()) != -1) {
                String eventName = (String)SoundsPanel.this.soundLocationTable.getValueAt(row, 0);
                SoundsPanel.this.sounds.play(eventName);
            }
        }
    }

    private class SoundLocationTableRowSelectionListener
    implements ListSelectionListener {
        private SoundLocationTableRowSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            boolean mute = SoundsPanel.this.muteCheckbox.isSelected();
            SoundsPanel.this.updateSounds(mute);
        }
    }

    private class MuteActionListener
    implements ActionListener {
        private MuteActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            boolean mute = SoundsPanel.this.muteCheckbox.isSelected();
            SoundsPanel.this.updateSounds(mute);
        }
    }
}

