/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.EventWrapperViewPanel;
import de.huxhorn.lilith.swing.preferences.PreferencesDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class GeneralPanel
extends JPanel {
    private PreferencesDialog preferencesDialog;
    private ApplicationPreferences applicationPreferences;
    private JCheckBox internalFramesCheckbox;
    private JCheckBox scrollingToBottomCheckbox;
    private JCheckBox autoOpenCheckbox;
    private JCheckBox autoCloseCheckbox;
    private JCheckBox autoFocusCheckbox;
    private JCheckBox showIdentifierCheckbox;
    private JCheckBox showFullCallstackCheckbox;
    private JCheckBox checkForUpdateCheckbox;
    private JCheckBox cleaningLogsOnExitCheckbox;
    private JFileChooser applicationPathFileChooser;
    private JTextField appPathTextField;
    private JComboBox lookAndFeelCombo;

    public GeneralPanel(PreferencesDialog preferencesDialog) {
        this.preferencesDialog = preferencesDialog;
        this.applicationPreferences = preferencesDialog.getApplicationPreferences();
        this.createUI();
    }

    private void createUI() {
        this.internalFramesCheckbox = new JCheckBox("Use internal frames.");
        this.showIdentifierCheckbox = new JCheckBox("Show identifier for named sources.");
        this.showFullCallstackCheckbox = new JCheckBox("Show full Callstack.");
        this.cleaningLogsOnExitCheckbox = new JCheckBox("Clean logs on exit.");
        this.autoOpenCheckbox = new JCheckBox("Automatically open new views on connection.");
        this.autoCloseCheckbox = new JCheckBox("Automatically close inactive views on disconnection.");
        this.autoFocusCheckbox = new JCheckBox("Automatically focus window of new view.");
        this.checkForUpdateCheckbox = new JCheckBox("Check for updates on startup.");
        this.scrollingToBottomCheckbox = new JCheckBox("Initial 'Scrolling to Bottom' setting");
        this.applicationPathFileChooser = new JFileChooser();
        this.applicationPathFileChooser.setFileSelectionMode(1);
        this.appPathTextField = new JTextField();
        this.appPathTextField.setEditable(false);
        BrowseApplicationPathAction browseAppPathAction = new BrowseApplicationPathAction();
        JButton browseAppPathButton = new JButton(browseAppPathAction);
        JPanel appPathPanel = new JPanel();
        appPathPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Application Path"));
        appPathPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        appPathPanel.add((Component)this.appPathTextField, gbc);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        appPathPanel.add((Component)browseAppPathButton, gbc);
        this.lookAndFeelCombo = new JComboBox();
        JPanel windowPanel = new JPanel(new GridLayout(5, 1));
        windowPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Frames"));
        windowPanel.add(this.internalFramesCheckbox);
        windowPanel.add(this.autoOpenCheckbox);
        windowPanel.add(this.autoFocusCheckbox);
        windowPanel.add(this.autoCloseCheckbox);
        windowPanel.add(this.showIdentifierCheckbox);
        JPanel viewPanel = new JPanel(new GridLayout(1, 1));
        viewPanel.setBorder(new TitledBorder(new EtchedBorder(1), "View"));
        viewPanel.add(this.scrollingToBottomCheckbox);
        JPanel detailsPanel = new JPanel(new GridLayout(1, 1));
        detailsPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Details View"));
        detailsPanel.add(this.showFullCallstackCheckbox);
        JPanel startupShutdownPanel = new JPanel(new GridLayout(2, 1));
        startupShutdownPanel.add(this.checkForUpdateCheckbox);
        startupShutdownPanel.add(this.cleaningLogsOnExitCheckbox);
        startupShutdownPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Startup & Shutdown"));
        this.lookAndFeelCombo.setBorder(new TitledBorder(new EtchedBorder(1), "Look & Feel"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.gridwidth = 1;
        gbc2.weightx = 1.0;
        gbc2.fill = 2;
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        this.add((Component)windowPanel, gbc2);
        gbc2.gridy = 1;
        this.add((Component)viewPanel, gbc2);
        gbc2.gridy = 2;
        this.add((Component)detailsPanel, gbc2);
        gbc2.gridy = 3;
        this.add((Component)startupShutdownPanel, gbc2);
        gbc2.gridy = 4;
        this.add((Component)this.lookAndFeelCombo, gbc2);
        gbc2.gridy = 5;
        this.add((Component)appPathPanel, gbc2);
    }

    public void initUI() {
        int idx;
        this.internalFramesCheckbox.setSelected(this.applicationPreferences.isUsingInternalFrames());
        this.scrollingToBottomCheckbox.setSelected(this.applicationPreferences.isScrollingToBottom());
        String appPath = this.applicationPreferences.getApplicationPath().getAbsolutePath();
        this.appPathTextField.setText(appPath);
        this.appPathTextField.setToolTipText(appPath);
        this.autoOpenCheckbox.setSelected(this.applicationPreferences.isAutoOpening());
        this.autoCloseCheckbox.setSelected(this.applicationPreferences.isAutoClosing());
        this.autoFocusCheckbox.setSelected(this.applicationPreferences.isAutoFocusingWindow());
        this.checkForUpdateCheckbox.setSelected(this.applicationPreferences.isCheckingForUpdate());
        this.showIdentifierCheckbox.setSelected(this.applicationPreferences.isShowingIdentifier());
        this.showFullCallstackCheckbox.setSelected(this.applicationPreferences.isShowingFullCallstack());
        this.cleaningLogsOnExitCheckbox.setSelected(this.applicationPreferences.isCleaningLogsOnExit());
        ArrayList<String> lookAndFeels = new ArrayList<String>();
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            lookAndFeels.add(info.getName());
        }
        Collections.sort(lookAndFeels);
        int selectedIndex = 0;
        String lookAndFeel = this.applicationPreferences.getLookAndFeel();
        if (lookAndFeel == null || "".equals(lookAndFeel)) {
            lookAndFeel = UIManager.getLookAndFeel().getName();
        }
        if ((idx = lookAndFeels.indexOf(lookAndFeel)) > -1) {
            selectedIndex = idx;
        } else {
            idx = lookAndFeels.indexOf(ApplicationPreferences.STARTUP_LOOK_AND_FEEL);
            if (idx > -1) {
                selectedIndex = idx;
            }
        }
        this.lookAndFeelCombo.setModel(new DefaultComboBoxModel<Object>(lookAndFeels.toArray()));
        this.lookAndFeelCombo.setSelectedIndex(selectedIndex);
    }

    public void saveSettings() {
        this.applicationPreferences.setUsingInternalFrames(this.internalFramesCheckbox.isSelected());
        this.applicationPreferences.setScrollingToBottom(this.scrollingToBottomCheckbox.isSelected());
        this.applicationPreferences.setAutoOpening(this.autoOpenCheckbox.isSelected());
        this.applicationPreferences.setAutoClosing(this.autoCloseCheckbox.isSelected());
        this.applicationPreferences.setAutoFocusingWindow(this.autoFocusCheckbox.isSelected());
        this.applicationPreferences.setCheckingForUpdate(this.checkForUpdateCheckbox.isSelected());
        this.applicationPreferences.setApplicationPath(new File(this.appPathTextField.getText()));
        this.applicationPreferences.setShowingIdentifier(this.showIdentifierCheckbox.isSelected());
        this.applicationPreferences.setShowingFullCallstack(this.showFullCallstackCheckbox.isSelected());
        this.applicationPreferences.setCleaningLogsOnExit(this.cleaningLogsOnExitCheckbox.isSelected());
        this.applicationPreferences.setLookAndFeel((String)this.lookAndFeelCombo.getSelectedItem());
    }

    private class BrowseApplicationPathAction
    extends AbstractAction {
        public BrowseApplicationPathAction() {
            URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/actions/document-open.png");
            ImageIcon icon = url != null ? new ImageIcon(url) : null;
            this.putValue("SmallIcon", icon);
            this.putValue("ShortDescription", "Browse for the application path.");
        }

        public void actionPerformed(ActionEvent e) {
            GeneralPanel.this.applicationPathFileChooser.setCurrentDirectory(GeneralPanel.this.applicationPreferences.getApplicationPath());
            int returnVal = GeneralPanel.this.applicationPathFileChooser.showDialog(GeneralPanel.this.preferencesDialog, "Select");
            if (returnVal == 0) {
                File file = GeneralPanel.this.applicationPathFileChooser.getSelectedFile();
                String appPath = file.getAbsolutePath();
                GeneralPanel.this.appPathTextField.setText(appPath);
                GeneralPanel.this.appPathTextField.setToolTipText(appPath);
            }
        }
    }
}

