/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import de.huxhorn.lilith.swing.preferences.SavedCondition;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionTableModel
implements TableModel {
    private final Logger logger = LoggerFactory.getLogger(ConditionTableModel.class);
    public static final int CONDITION_COLUMN = 0;
    private List<SavedCondition> data;
    private final EventListenerList eventListenerList = new EventListenerList();

    public ConditionTableModel(List<SavedCondition> data) {
        this.setData(data);
    }

    public void setData(List<SavedCondition> data) {
        this.data = data;
        this.fireTableChange(new TableModelEvent(this));
    }

    public List<SavedCondition> getData() {
        return this.data;
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.size();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Condition";
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return SavedCondition.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return false;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.data == null || columnIndex > 0 || rowIndex < 0 || rowIndex >= this.data.size()) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return this.data.get(rowIndex);
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.data == null || columnIndex > 0 || rowIndex < 0 || rowIndex >= this.data.size()) {
            return;
        }
        switch (columnIndex) {
            case 0: {
                SavedCondition newValue = (SavedCondition)aValue;
                this.data.set(rowIndex, newValue);
                this.fireTableChange(new TableModelEvent(this, rowIndex, rowIndex, -1, 0));
            }
        }
    }

    public void remove(int row) {
        if (row >= 0 && row < this.data.size()) {
            this.data.remove(row);
            this.fireTableChange(new TableModelEvent(this, row, row, -1, -1));
        }
    }

    public int moveUp(int row) {
        int result = -1;
        if (row >= 0) {
            int newRow = row - 1;
            if (row < this.data.size() && newRow >= 0 && newRow < this.data.size()) {
                SavedCondition prev = this.data.set(newRow, this.data.get(row));
                this.data.set(row, prev);
                this.fireTableChange(new TableModelEvent(this, row, row, -1, 0));
                this.fireTableChange(new TableModelEvent(this, newRow, newRow, -1, 0));
                result = newRow;
            }
        }
        return result;
    }

    public int moveDown(int row) {
        int result = -1;
        if (row >= 0) {
            int newRow = row + 1;
            if (row < this.data.size() && newRow >= 0 && newRow < this.data.size()) {
                SavedCondition prev = this.data.set(newRow, this.data.get(row));
                this.data.set(row, prev);
                this.fireTableChange(new TableModelEvent(this, row, row, -1, 0));
                this.fireTableChange(new TableModelEvent(this, newRow, newRow, -1, 0));
                result = newRow;
            }
        }
        return result;
    }

    private void fireTableChange(TableModelEvent evt) {
        FireTableChangeRunnable r = new FireTableChangeRunnable(evt);
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public void set(int row, SavedCondition savedCondition) {
        if (row > -1 && row < this.data.size()) {
            this.data.set(row, savedCondition);
            this.fireTableChange(new TableModelEvent(this, row, row, -1, 0));
        }
    }

    public int add(SavedCondition savedCondition) {
        this.data.add(savedCondition);
        int row = this.data.size() - 1;
        this.fireTableChange(new TableModelEvent(this, row, row, -1, 1));
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTableModelListener(TableModelListener l) {
        EventListenerList eventListenerList = this.eventListenerList;
        synchronized (eventListenerList) {
            this.eventListenerList.add(TableModelListener.class, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTableModelListener(TableModelListener l) {
        EventListenerList eventListenerList = this.eventListenerList;
        synchronized (eventListenerList) {
            this.eventListenerList.remove(TableModelListener.class, l);
        }
    }

    private class FireTableChangeRunnable
    implements Runnable {
        private TableModelEvent event;

        public FireTableChangeRunnable(TableModelEvent event) {
            this.event = event;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object[] listeners;
            EventListenerList eventListenerList = ConditionTableModel.this.eventListenerList;
            synchronized (eventListenerList) {
                listeners = ConditionTableModel.this.eventListenerList.getListenerList();
            }
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != TableModelListener.class) continue;
                TableModelListener listener = (TableModelListener)listeners[i + 1];
                if (ConditionTableModel.this.logger.isDebugEnabled()) {
                    ConditionTableModel.this.logger.debug("Firing TableChange at {}.", (Object)listener.getClass().getName());
                }
                try {
                    listener.tableChanged(this.event);
                    continue;
                }
                catch (Throwable ex) {
                    if (!ConditionTableModel.this.logger.isWarnEnabled()) continue;
                    ConditionTableModel.this.logger.warn("Exception while firing change!", ex);
                }
            }
        }
    }
}

