/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.preferences;

import de.huxhorn.lilith.swing.preferences.SavedCondition;
import de.huxhorn.lilith.swing.preferences.table.ConditionPreviewRenderer;
import de.huxhorn.lilith.swing.table.ColorScheme;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorSchemeEditorPanel
extends JPanel {
    private final Logger logger = LoggerFactory.getLogger(ColorSchemeEditorPanel.class);
    private JColorChooser textChooser;
    private JColorChooser backgroundChooser;
    private JColorChooser borderChooser;
    private ColorChangeListener colorChangeListener;
    private ConditionPreviewRenderer previewDummyRenderer;
    private ColorScheme colorScheme;

    public ColorSchemeEditorPanel() {
        this.createUI();
    }

    private void createUI() {
        JPanel emptyPreview = new JPanel();
        emptyPreview.setMinimumSize(new Dimension(0, 0));
        emptyPreview.setPreferredSize(new Dimension(0, 0));
        emptyPreview.setMaximumSize(new Dimension(0, 0));
        this.colorChangeListener = new ColorChangeListener();
        this.textChooser = new JColorChooser();
        this.textChooser.setPreviewPanel(emptyPreview);
        this.attachChangeListener(this.textChooser);
        this.backgroundChooser = new JColorChooser();
        this.backgroundChooser.setPreviewPanel(emptyPreview);
        this.attachChangeListener(this.backgroundChooser);
        this.borderChooser = new JColorChooser();
        this.borderChooser.setPreviewPanel(emptyPreview);
        this.attachChangeListener(this.borderChooser);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Text", this.textChooser);
        tabbedPane.add("Background", this.backgroundChooser);
        tabbedPane.add("Border", this.borderChooser);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        this.add((Component)tabbedPane, gbc);
        this.previewDummyRenderer = new ConditionPreviewRenderer();
        Component previewComponent = this.previewDummyRenderer.getTableCellRendererComponent(null, null, false, false, 0, 0);
        JPanel previewPanel = new JPanel(new GridLayout(1, 1));
        previewPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Preview"));
        previewPanel.add(previewComponent);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 2;
        this.add((Component)previewPanel, gbc);
    }

    public void saveColors() {
        this.colorScheme = new ColorScheme(this.textChooser.getColor(), this.backgroundChooser.getColor(), this.borderChooser.getColor());
    }

    public void resetColors() {
        if (this.colorScheme == null) {
            this.colorScheme = new ColorScheme();
        }
        this.textChooser.setColor(this.colorScheme.getTextColor());
        this.backgroundChooser.setColor(this.colorScheme.getBackgroundColor());
        this.borderChooser.setColor(this.colorScheme.getBorderColor());
    }

    public ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public void setColorScheme(ColorScheme colorScheme) {
        if (colorScheme == null) {
            throw new IllegalArgumentException("colorScheme must not be null!");
        }
        this.colorScheme = colorScheme;
        this.resetColors();
    }

    private void attachChangeListener(JColorChooser chooser) {
        AbstractColorChooserPanel[] panels = chooser.getChooserPanels();
        if (panels != null) {
            for (AbstractColorChooserPanel current : panels) {
                current.getColorSelectionModel().addChangeListener(this.colorChangeListener);
            }
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("No chooser panels!");
        }
    }

    private class ColorChangeListener
    implements ChangeListener {
        private SavedCondition dummyCondition = new SavedCondition();

        private ColorChangeListener() {
            this.dummyCondition.setColorScheme(new ColorScheme());
        }

        public void stateChanged(ChangeEvent e) {
            ColorScheme cs = this.dummyCondition.getColorScheme();
            cs.setTextColor(ColorSchemeEditorPanel.this.textChooser.getColor());
            cs.setBackgroundColor(ColorSchemeEditorPanel.this.backgroundChooser.getColor());
            cs.setBorderColor(ColorSchemeEditorPanel.this.borderChooser.getColor());
            if (ColorSchemeEditorPanel.this.logger.isDebugEnabled()) {
                ColorSchemeEditorPanel.this.logger.debug("initializing to {}...", this.dummyCondition);
            }
            ColorSchemeEditorPanel.this.previewDummyRenderer.getTableCellRendererComponent(null, this.dummyCondition, false, false, 0, 0);
        }
    }
}

