/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.callables;

import de.huxhorn.sulky.codec.filebuffer.DefaultFileHeaderStrategy;
import de.huxhorn.sulky.codec.filebuffer.FileHeader;
import de.huxhorn.sulky.tasks.AbstractProgressingCallable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexingCallable
extends AbstractProgressingCallable<Long> {
    private final Logger logger = LoggerFactory.getLogger(IndexingCallable.class);
    private File dataFile;
    private File indexFile;

    public IndexingCallable(File dataFile, File indexFile) {
        this.dataFile = dataFile;
        this.indexFile = indexFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Long call() throws Exception {
        block12: {
            if (!this.dataFile.exists()) {
                throw new FileNotFoundException("File '" + this.dataFile.getAbsolutePath() + "' does not exist!");
            }
            if (!this.dataFile.isFile()) {
                throw new FileNotFoundException("File '" + this.dataFile.getAbsolutePath() + "' is not a file!");
            }
            long fileSize = this.dataFile.length();
            this.setNumberOfSteps(fileSize);
            DefaultFileHeaderStrategy fhs = new DefaultFileHeaderStrategy();
            FileHeader fileHeader = fhs.readFileHeader(this.dataFile);
            if (fileHeader == null) break block12;
            long offset = fileHeader.getDataOffset();
            RandomAccessFile dataRAFile = null;
            RandomAccessFile indexRAFile = null;
            Exception ex = null;
            long counter = 0L;
            try {
                dataRAFile = new RandomAccessFile(this.dataFile, "r");
                indexRAFile = new RandomAccessFile(this.indexFile, "rw");
                indexRAFile.setLength(0L);
                while (offset < fileSize) {
                    dataRAFile.seek(offset);
                    indexRAFile.writeLong(offset);
                    ++counter;
                    int dataSize = dataRAFile.readInt();
                    offset = offset + (long)dataSize + 4L;
                    this.setCurrentStep(offset);
                }
            }
            catch (IOException e) {
                ex = e;
                IndexingCallable.closeQuietly(dataRAFile);
                IndexingCallable.closeQuietly(indexRAFile);
            }
            catch (InterruptedException e2) {
                ex = e2;
                {
                    catch (Throwable throwable) {
                        IndexingCallable.closeQuietly(dataRAFile);
                        IndexingCallable.closeQuietly(indexRAFile);
                        throw throwable;
                    }
                }
                IndexingCallable.closeQuietly(dataRAFile);
                IndexingCallable.closeQuietly(indexRAFile);
            }
            IndexingCallable.closeQuietly(dataRAFile);
            IndexingCallable.closeQuietly(indexRAFile);
            if (ex != null) {
                if (!this.indexFile.delete() && this.logger.isWarnEnabled()) {
                    this.logger.warn("Failed to delete index file '{}'!", (Object)this.indexFile.getAbsolutePath());
                }
                throw ex;
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("File '{}' has {} entries.", (Object)this.dataFile.getAbsolutePath(), (Object)counter);
            }
            return counter;
        }
        throw new IllegalArgumentException("File '" + this.dataFile.getAbsolutePath() + "' is not a valid file!");
    }

    public File getDataFile() {
        return this.dataFile;
    }

    public File getIndexFile() {
        return this.indexFile;
    }

    private static void closeQuietly(RandomAccessFile file) {
        if (file != null) {
            try {
                file.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

