/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing.callables;

import de.huxhorn.lilith.buffers.FilteringBuffer;
import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.conditions.Condition;
import de.huxhorn.sulky.tasks.AbstractProgressingCallable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringCallable<E>
extends AbstractProgressingCallable<Long> {
    private final Logger logger = LoggerFactory.getLogger(FilteringCallable.class);
    private int filterDelay;
    private long lastFilteredElement;
    private FilteringBuffer<E> filteringBuffer;

    public FilteringCallable(FilteringBuffer<E> filteringBuffer, int filterDelay) {
        this.filterDelay = filterDelay;
        this.filteringBuffer = filteringBuffer;
    }

    public void run() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Runnable finished.");
        }
    }

    public Long call() throws Exception {
        while (true) {
            Buffer<E> sourceBuffer = this.filteringBuffer.getSourceBuffer();
            Condition condition = this.filteringBuffer.getCondition();
            boolean disposed = this.filteringBuffer.isDisposed();
            if (disposed) break;
            long currentSize = sourceBuffer.getSize();
            long filterStartIndex = this.lastFilteredElement;
            if (currentSize < this.lastFilteredElement) {
                filterStartIndex = 0L;
                this.filteringBuffer.clearFilteredIndices();
            }
            this.setNumberOfSteps(currentSize);
            this.setCurrentStep(filterStartIndex);
            if (currentSize != this.lastFilteredElement + 1L) {
                long i = filterStartIndex;
                while (i < currentSize && !(disposed = this.filteringBuffer.isDisposed())) {
                    Object current = sourceBuffer.get(i);
                    if (current != null && condition != null && condition.isTrue(current)) {
                        this.filteringBuffer.addFilteredIndex(i);
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("Added index: {}", i);
                        }
                    }
                    this.setCurrentStep(i);
                    this.lastFilteredElement = i++;
                }
            }
            try {
                Thread.sleep(this.filterDelay);
            }
            catch (InterruptedException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Interrupted...", e);
                }
                return this.lastFilteredElement;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Callable finished.");
        }
        return this.lastFilteredElement;
    }
}

