/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.lilith.buffers.FilteringBuffer;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.engine.EventSource;
import de.huxhorn.lilith.engine.impl.EventSourceImpl;
import de.huxhorn.lilith.swing.EventWrapperViewPanel;
import de.huxhorn.lilith.swing.LoggingViewState;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.ProgressGlassPane;
import de.huxhorn.lilith.swing.ViewWindow;
import de.huxhorn.lilith.swing.callables.CallableMetaData;
import de.huxhorn.lilith.swing.callables.FilteringCallable;
import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.buffers.DisposeOperation;
import de.huxhorn.sulky.conditions.Condition;
import de.huxhorn.sulky.tasks.Task;
import de.huxhorn.sulky.tasks.TaskListener;
import de.huxhorn.sulky.tasks.TaskManager;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ViewContainer<T extends Serializable>
extends JPanel
implements DisposeOperation {
    public static final String SELECTED_EVENT_PROPERTY_NAME = "selectedEvent";
    private static final ImageIcon globalFrameImageIcon;
    private static final Map<LoggingViewState, ImageIcon> frameIconImages;
    private final List<ChangeListener> changeListeners = new LinkedList<ChangeListener>();
    private EventWrapperViewPanel<T> defaultView;
    private MainFrame mainFrame;
    private TaskManager<Long> taskManager;
    private Map<Callable<Long>, EventWrapperViewPanel<T>> filterMapping;
    private FilterTaskListener filterTaskListener;

    public ViewContainer(MainFrame mainFrame, EventSource<T> eventSource) {
        this.mainFrame = mainFrame;
        this.taskManager = mainFrame.getLongWorkManager();
        this.filterMapping = new HashMap<Callable<Long>, EventWrapperViewPanel<T>>();
        this.filterTaskListener = new FilterTaskListener();
        this.taskManager.addTaskListener((TaskListener)this.filterTaskListener);
        this.defaultView = this.createViewPanel(eventSource);
        this.defaultView.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("state".equals(evt.getPropertyName())) {
                    ViewContainer.this.updateContainerIcon();
                }
            }
        });
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    protected abstract EventWrapperViewPanel<T> createViewPanel(EventSource<T> var1);

    public abstract EventWrapperViewPanel<T> getViewAt(int var1);

    public abstract EventWrapperViewPanel<T> getSelectedView();

    public abstract void addView(EventWrapperViewPanel<T> var1);

    public abstract void removeView(EventWrapperViewPanel<T> var1, boolean var2);

    public abstract void showDefaultView();

    public abstract Class getWrappedClass();

    public EventWrapperViewPanel<T> getDefaultView() {
        return this.defaultView;
    }

    public void dispose() {
        this.taskManager.removeTaskListener((TaskListener)this.filterTaskListener);
    }

    protected Condition resolveCombinedCondition(EventWrapperViewPanel<T> original) {
        Condition currentFilter = original.getTable().getFilterCondition();
        if (currentFilter == null) {
            return null;
        }
        Condition previousClone = original.getBufferCondition();
        Condition filter = original.getCombinedCondition();
        if (filter == null || filter.equals(previousClone)) {
            return null;
        }
        return filter;
    }

    public void addFilteredView(EventWrapperViewPanel<T> original) {
        Condition filter = this.resolveCombinedCondition(original);
        if (filter == null) {
            return;
        }
        Buffer<EventWrapper<T>> originalBuffer = original.getSourceBuffer();
        FilteringBuffer<EventWrapper<T>> filteredBuffer = new FilteringBuffer<EventWrapper<T>>(originalBuffer, filter);
        FilteringCallable<EventWrapper<T>> callable = new FilteringCallable<EventWrapper<T>>(filteredBuffer, 500);
        EventSource<T> originalEventSource = original.getEventSource();
        Map<String, String> metaData = CallableMetaData.createFilteringMetaData(filter, originalEventSource);
        EventSourceImpl newEventSource = new EventSourceImpl(originalEventSource.getSourceIdentifier(), filteredBuffer, filter, originalEventSource.isGlobal());
        EventWrapperViewPanel<T> newViewPanel = this.createViewPanel((EventSource<T>)newEventSource);
        this.filterMapping.put((Callable<Long>)((Object)callable), newViewPanel);
        this.addView(newViewPanel);
        this.taskManager.startTask(callable, "Filtering", "Filtering " + metaData.get("SourceIdentifier") + " on condition " + metaData.get("Condition") + ".", metaData);
    }

    public void replaceFilteredView(EventWrapperViewPanel<T> original) {
        Condition filter = this.resolveCombinedCondition(original);
        if (filter == null) {
            return;
        }
        EventSource<T> eventSource = original.getEventSource();
        Buffer buffer = eventSource.getBuffer();
        if (buffer instanceof FilteringBuffer) {
            Callable<Long> found = null;
            for (Map.Entry<Callable<Long>, EventWrapperViewPanel<T>> current : this.filterMapping.entrySet()) {
                if (current.getValue() != original) continue;
                found = current.getKey();
                break;
            }
            if (found != null) {
                this.filterMapping.remove(found);
                Task task = this.taskManager.getTaskByCallable(found);
                if (task != null) {
                    task.getFuture().cancel(true);
                }
                Buffer<EventWrapper<T>> originalBuffer = original.getSourceBuffer();
                FilteringBuffer<EventWrapper<T>> filteredBuffer = new FilteringBuffer<EventWrapper<T>>(originalBuffer, filter);
                FilteringCallable<EventWrapper<T>> callable = new FilteringCallable<EventWrapper<T>>(filteredBuffer, 500);
                EventSource<T> originalEventSource = original.getEventSource();
                Map<String, String> metaData = CallableMetaData.createFilteringMetaData(filter, originalEventSource);
                EventSourceImpl newEventSource = new EventSourceImpl(originalEventSource.getSourceIdentifier(), filteredBuffer, filter, originalEventSource.isGlobal());
                original.setEventSource((EventSource<T>)newEventSource);
                this.filterMapping.put((Callable<Long>)((Object)callable), original);
                this.taskManager.startTask(callable, "Filtering", "Filtering " + metaData.get("SourceIdentifier") + " on condition " + metaData.get("Condition") + ".", metaData);
            }
        } else {
            this.addFilteredView(original);
        }
    }

    public ViewWindow resolveViewWindow() {
        Container parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof ViewWindow); parent = parent.getParent()) {
        }
        return (ViewWindow)((Object)parent);
    }

    private void updateContainerIcon() {
        ViewWindow window = this.resolveViewWindow();
        if (window instanceof JFrame) {
            JFrame frame = (JFrame)((Object)window);
            this.updateFrameIcon(frame);
        } else if (window instanceof JInternalFrame) {
            JInternalFrame frame = (JInternalFrame)((Object)window);
            this.updateInternalFrameIcon(frame);
        }
    }

    private static ImageIcon resolveIconForState(LoggingViewState state) {
        ImageIcon result = globalFrameImageIcon;
        if (state != null) {
            result = frameIconImages.get((Object)state);
        }
        return result;
    }

    private void updateFrameIcon(JFrame frame) {
        ImageIcon frameImageIcon = ViewContainer.resolveIconForState(this.defaultView.getState());
        if (frameImageIcon != null) {
            frame.setIconImage(frameImageIcon.getImage());
        }
    }

    private void updateInternalFrameIcon(JInternalFrame iframe) {
        ImageIcon frameImageIcon = ViewContainer.resolveIconForState(this.defaultView.getState());
        if (frameImageIcon != null) {
            iframe.setFrameIcon(frameImageIcon);
            iframe.repaint();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.updateContainerIcon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener listener) {
        boolean changed = false;
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            if (!this.changeListeners.contains(listener)) {
                this.changeListeners.add(listener);
                changed = true;
            }
        }
        if (changed) {
            this.fireChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener listener) {
        boolean changed = false;
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            if (this.changeListeners.contains(listener)) {
                this.changeListeners.remove(listener);
                changed = true;
            }
        }
        if (changed) {
            this.fireChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChange() {
        ArrayList<ChangeListener> clone;
        List<ChangeListener> list = this.changeListeners;
        synchronized (list) {
            clone = new ArrayList<ChangeListener>(this.changeListeners);
        }
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : clone) {
            listener.stateChanged(event);
        }
    }

    public abstract void closeCurrentFilter();

    public abstract void closeOtherFilters();

    public abstract void closeAllFilters();

    public abstract int getViewCount();

    public abstract void setViewIndex(int var1);

    public abstract int getViewIndex();

    public abstract void hideSearchPanel();

    public abstract void showSearchPanel(Task<Long> var1);

    public abstract boolean isSearching();

    public abstract void cancelSearching();

    public abstract ProgressGlassPane getProgressPanel();

    public abstract EventWrapper<T> getSelectedEvent();

    public abstract void updateViews();

    public abstract void scrollToEvent();

    static {
        URL url = EventWrapperViewPanel.class.getResource("/tango/16x16/categories/applications-internet.png");
        globalFrameImageIcon = url != null ? new ImageIcon(url) : null;
        frameIconImages = new HashMap<LoggingViewState, ImageIcon>();
        url = EventWrapperViewPanel.class.getResource("/tango/16x16/status/network-receive.png");
        if (url != null) {
            frameIconImages.put(LoggingViewState.ACTIVE, new ImageIcon(url));
        }
        if ((url = EventWrapperViewPanel.class.getResource("/tango/16x16/status/network-offline.png")) != null) {
            frameIconImages.put(LoggingViewState.INACTIVE, new ImageIcon(url));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FilterTaskListener
    implements TaskListener<Long> {
        private final Logger logger = LoggerFactory.getLogger(FilterTaskListener.class);

        FilterTaskListener() {
        }

        public void taskCreated(Task<Long> longTask) {
        }

        public void executionFailed(Task<Long> task, ExecutionException exception) {
            EventWrapperViewPanel view = (EventWrapperViewPanel)ViewContainer.this.filterMapping.get(task.getCallable());
            if (view != null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Filter execution failed!", exception);
                }
                this.finished(view);
            }
        }

        public void executionFinished(Task<Long> task, Long result) {
            EventWrapperViewPanel view = (EventWrapperViewPanel)ViewContainer.this.filterMapping.get(task.getCallable());
            if (view != null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Filter execution finished: {}!", result);
                }
                this.finished(view);
            }
        }

        public void executionCanceled(Task<Long> task) {
            EventWrapperViewPanel view = (EventWrapperViewPanel)ViewContainer.this.filterMapping.get(task.getCallable());
            if (view != null) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Filter execution canceled.");
                }
                this.finished(view);
            }
        }

        public void progressUpdated(Task<Long> task, int progress) {
        }

        private void finished(EventWrapperViewPanel<T> view) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Executing FilterTaskListener.finished().");
            }
            ViewContainer.this.removeView(view, true);
        }
    }
}

