/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplashScreen
extends JWindow {
    private final Logger logger = LoggerFactory.getLogger(SplashScreen.class);
    private JLabel statusLabel;
    private JPanel contentPane;

    public SplashScreen(String applicationTitle) {
        this.initUI(applicationTitle);
    }

    private void initUI(String applicationTitle) {
        block4: {
            this.contentPane = new JPanel(true);
            this.contentPane.setLayout(new BorderLayout());
            URL url = SplashScreen.class.getResource("/splash/splash.jpg");
            if (url != null) {
                try {
                    BufferedImage image = ImageIO.read(url);
                    if (image != null) {
                        ImagePanel imagePanel = new ImagePanel(image);
                        this.contentPane.add((Component)imagePanel, "Center");
                    }
                }
                catch (IOException ex) {
                    if (!this.logger.isWarnEnabled()) break block4;
                    this.logger.warn("Exception while loading image!", ex);
                }
            }
        }
        this.statusLabel = new JLabel();
        this.statusLabel.setOpaque(true);
        this.statusLabel.setForeground(Color.BLACK);
        this.statusLabel.setBackground(Color.WHITE);
        this.statusLabel.setHorizontalAlignment(0);
        JLabel titleLabel = new JLabel(applicationTitle);
        titleLabel.setOpaque(true);
        titleLabel.setForeground(Color.BLACK);
        titleLabel.setBackground(Color.WHITE);
        titleLabel.setHorizontalAlignment(0);
        this.contentPane.add((Component)titleLabel, "North");
        this.contentPane.add((Component)this.statusLabel, "South");
        this.statusLabel.setText("Initializing...");
        this.setContentPane(this.contentPane);
    }

    public void setStatusText(String statusText) {
        this.statusLabel.setText(statusText);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Status: {}", (Object)statusText);
        }
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        this.toFront();
        Rectangle bounds = this.contentPane.getBounds();
        int height = this.statusLabel.getHeight();
        this.contentPane.paintImmediately(0, bounds.height - height, bounds.width, height);
    }

    private class ImagePanel
    extends JComponent {
        private BufferedImage image;

        public ImagePanel(BufferedImage image) {
            this.image = image;
            this.setPreferredSize(new Dimension(this.image.getWidth(), this.image.getHeight()));
        }

        public void paint(Graphics g) {
            if (SplashScreen.this.logger.isInfoEnabled()) {
                SplashScreen.this.logger.info("paint");
            }
            g.drawImage(this.image, 0, 0, this);
        }

        public void update(Graphics g) {
            if (SplashScreen.this.logger.isInfoEnabled()) {
                SplashScreen.this.logger.info("update");
            }
            this.paint(g);
        }

        protected void paintComponent(Graphics g) {
            this.paint(g);
        }

        public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
            if (SplashScreen.this.logger.isInfoEnabled()) {
                SplashScreen.this.logger.info("imageUpdate");
            }
            this.repaint();
            return (infoflags & 0xA0) == 0;
        }
    }
}

