/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.swing;

import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.engine.LogFileFactory;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.sulky.formatting.HumanReadable;
import de.huxhorn.sulky.swing.KeyStrokes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenPreviousDialog
extends JDialog {
    private final Logger logger = LoggerFactory.getLogger(OpenPreviousDialog.class);
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private MainFrame mainFrame;
    private OpenAction openAction;
    private JTabbedPane tabbedPane;
    private OpenPreviousPanel loggingPanel;
    private OpenPreviousPanel accessPanel;

    public OpenPreviousDialog(MainFrame owner) {
        super((Frame)owner, "Open previous log...");
        this.mainFrame = owner;
        this.createUI();
    }

    private void createUI() {
        this.openAction = new OpenAction();
        CancelAction cancelAction = new CancelAction();
        this.tabbedPane = new JTabbedPane();
        this.loggingPanel = new OpenPreviousPanel(this.mainFrame.getLoggingFileFactory(), EventType.LOGGING);
        this.accessPanel = new OpenPreviousPanel(this.mainFrame.getAccessFileFactory(), EventType.ACCESS);
        this.tabbedPane.add(this.loggingPanel.getPanelName(), this.loggingPanel);
        this.tabbedPane.add(this.accessPanel.getPanelName(), this.accessPanel);
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        buttonPanel.add(new JButton(this.openAction));
        buttonPanel.add(new JButton(cancelAction));
        JPanel contentPane = new JPanel(new BorderLayout());
        KeyStrokes.registerCommand((JComponent)contentPane, (Action)this.openAction, (String)"OPEN_ACTION");
        KeyStrokes.registerCommand((JComponent)contentPane, (Action)cancelAction, (String)"CANCEL_ACTION");
        contentPane.add((Component)this.tabbedPane, "Center");
        contentPane.add((Component)buttonPanel, "South");
        this.setContentPane(contentPane);
        this.tabbedPane.addChangeListener(new TabChangeListener());
    }

    public void setVisible(boolean b) {
        if (b) {
            this.initUI();
        }
        super.setVisible(b);
    }

    private void initUI() {
        this.loggingPanel.initUI();
        this.accessPanel.initUI();
        this.initOpenAction();
    }

    private void initOpenAction() {
        Component comp = this.tabbedPane.getSelectedComponent();
        if (comp instanceof OpenPreviousPanel) {
            OpenPreviousPanel panel = (OpenPreviousPanel)comp;
            SourceIdentifier selectedSource = panel.getSelectedSource();
            this.openAction.setEnabled(selectedSource != null);
        }
    }

    public void openSelection() {
        OpenPreviousPanel panel;
        SourceIdentifier selectedSource;
        Component comp = this.tabbedPane.getSelectedComponent();
        if (comp instanceof OpenPreviousPanel && (selectedSource = (panel = (OpenPreviousPanel)comp).getSelectedSource()) != null) {
            if (panel.getEventType() == EventType.LOGGING) {
                this.mainFrame.openPreviousLogging(selectedSource);
            } else {
                this.mainFrame.openPreviousAccess(selectedSource);
            }
        }
        this.setVisible(false);
    }

    private class OpenPreviousPanel
    extends JPanel {
        private ArrayList<List<SourceIdentifier>> secondaries;
        private JList primaryList;
        private JList secondaryList;
        private JTextArea infoArea;
        private DecimalFormat eventCountFormat;
        private LogFileFactory fileFactory;
        private EventType eventType;
        private SourceIdentifier selectedSource;

        public OpenPreviousPanel(LogFileFactory fileFactory, EventType eventType) {
            this.fileFactory = fileFactory;
            this.eventType = eventType;
            this.eventCountFormat = new DecimalFormat("#,###");
            this.createUI();
        }

        public SourceIdentifier getSelectedSource() {
            return this.selectedSource;
        }

        public String getPanelName() {
            return this.eventType.getTypeName();
        }

        public EventType getEventType() {
            return this.eventType;
        }

        private void setSelectedSource(SourceIdentifier selected) {
            if (OpenPreviousDialog.this.logger.isDebugEnabled()) {
                OpenPreviousDialog.this.logger.debug("Selected source: {}", selected);
            }
            this.selectedSource = selected;
            OpenPreviousDialog.this.initOpenAction();
            this.updateInfoArea();
        }

        private void createUI() {
            this.primaryList = new JList();
            this.secondaryList = new JList();
            this.primaryList.setSelectionMode(0);
            this.primaryList.addListSelectionListener(new PrimaryListSelectionListener());
            this.secondaryList.setSelectionMode(0);
            this.secondaryList.addListSelectionListener(new SecondaryListSelectionListener());
            this.secondaryList.addMouseListener(new SecondaryMouseListener());
            JScrollPane primaryPane = new JScrollPane(this.primaryList);
            primaryPane.setBorder(new TitledBorder(new EtchedBorder(1), "Primary"));
            primaryPane.setPreferredSize(new Dimension(200, 300));
            JScrollPane secondaryPane = new JScrollPane(this.secondaryList);
            secondaryPane.setPreferredSize(new Dimension(300, 300));
            secondaryPane.setBorder(new TitledBorder(new EtchedBorder(1), "Secondary"));
            JSplitPane filePane = new JSplitPane(1, true, primaryPane, secondaryPane);
            this.setLayout(new BorderLayout());
            this.add((Component)filePane, "Center");
            JPanel infoPanel = new JPanel(new GridLayout(1, 1));
            this.infoArea = new JTextArea(3, 40);
            this.infoArea.setEditable(false);
            infoPanel.add(this.infoArea);
            infoPanel.setBorder(new TitledBorder(new EtchedBorder(1), "Log Informations"));
            this.add((Component)infoPanel, "South");
        }

        public void initUI() {
            List<SourceIdentifier> inactives = OpenPreviousDialog.this.mainFrame.collectInactiveLogs(this.fileFactory);
            TreeMap<String, ArrayList<SourceIdentifier>> inactiveMap = new TreeMap<String, ArrayList<SourceIdentifier>>();
            for (SourceIdentifier current : inactives) {
                String primary = OpenPreviousDialog.this.mainFrame.getPrimarySourceTitle(current);
                ArrayList<SourceIdentifier> sourceList = (ArrayList<SourceIdentifier>)inactiveMap.get(primary);
                if (sourceList == null) {
                    sourceList = new ArrayList<SourceIdentifier>();
                    inactiveMap.put(primary, sourceList);
                }
                sourceList.add(current);
            }
            int primaryCount = inactiveMap.size();
            if (primaryCount > 0) {
                ArrayList primaries = new ArrayList(primaryCount);
                this.secondaries = new ArrayList(primaryCount);
                for (Map.Entry current : inactiveMap.entrySet()) {
                    primaries.add(current.getKey());
                    List value = (List)current.getValue();
                    Collections.reverse(value);
                    this.secondaries.add(value);
                }
                this.primaryList.setListData(primaries.toArray());
                this.secondaryList.setListData(this.secondaries.toArray());
                this.primaryList.setSelectedIndex(0);
            } else {
                this.primaryList.setListData(EMPTY_OBJECT_ARRAY);
                this.secondaryList.setListData(EMPTY_OBJECT_ARRAY);
            }
        }

        private String getLogInfo(SourceIdentifier selectedSource) {
            if (selectedSource == null) {
                return "";
            }
            StringBuilder result = new StringBuilder();
            result.append(OpenPreviousDialog.this.mainFrame.getPrimarySourceTitle(selectedSource));
            String secondary = selectedSource.getSecondaryIdentifier();
            if (secondary != null) {
                result.append(" - ").append(selectedSource.getSecondaryIdentifier());
            }
            result.append("\n");
            result.append("Number of events: ").append(this.eventCountFormat.format(this.fileFactory.getNumberOfEvents(selectedSource))).append("\n");
            result.append("Size: ").append(HumanReadable.getHumanReadableSize((long)this.fileFactory.getSizeOnDisk(selectedSource), (boolean)true, (boolean)false)).append("bytes");
            return result.toString();
        }

        public void updateInfoArea() {
            this.infoArea.setText(this.getLogInfo(this.selectedSource));
        }

        private class SecondaryMouseListener
        extends MouseAdapter {
            private SecondaryMouseListener() {
            }

            public void mouseClicked(MouseEvent e) {
                Component component;
                if (e.getButton() == 1 && e.getClickCount() > 1 && (component = OpenPreviousPanel.this.secondaryList.getComponentAt(e.getPoint())) != null) {
                    OpenPreviousDialog.this.openSelection();
                }
            }
        }

        private class SecondaryListSelectionListener
        implements ListSelectionListener {
            private SecondaryListSelectionListener() {
            }

            public void valueChanged(ListSelectionEvent e) {
                Rectangle selectRect;
                SourceIdentifier selected = (SourceIdentifier)OpenPreviousPanel.this.secondaryList.getSelectedValue();
                int selectedIndex = OpenPreviousPanel.this.secondaryList.getSelectedIndex();
                if (selectedIndex != -1 && (selectRect = OpenPreviousPanel.this.secondaryList.getCellBounds(selectedIndex, selectedIndex)) != null) {
                    OpenPreviousPanel.this.secondaryList.scrollRectToVisible(selectRect);
                }
                OpenPreviousPanel.this.setSelectedSource(selected);
            }
        }

        private class PrimaryListSelectionListener
        implements ListSelectionListener {
            private PrimaryListSelectionListener() {
            }

            public void valueChanged(ListSelectionEvent e) {
                JList source = (JList)e.getSource();
                int selectedIndex = source.getSelectedIndex();
                if (selectedIndex >= 0 && selectedIndex < OpenPreviousPanel.this.secondaries.size()) {
                    List sources = (List)OpenPreviousPanel.this.secondaries.get(selectedIndex);
                    OpenPreviousPanel.this.secondaryList.setListData(sources.toArray());
                    OpenPreviousPanel.this.secondaryList.setSelectedIndex(0);
                } else {
                    OpenPreviousPanel.this.secondaryList.setListData(EMPTY_OBJECT_ARRAY);
                }
            }
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"ESCAPE");
            if (OpenPreviousDialog.this.logger.isDebugEnabled()) {
                OpenPreviousDialog.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            OpenPreviousDialog.this.setVisible(false);
        }
    }

    private class OpenAction
    extends AbstractAction {
        public OpenAction() {
            super("Open");
            KeyStroke accelerator = KeyStrokes.resolveAcceleratorKeyStroke((String)"ENTER");
            if (OpenPreviousDialog.this.logger.isDebugEnabled()) {
                OpenPreviousDialog.this.logger.debug("accelerator: {}", accelerator);
            }
            this.putValue("AcceleratorKey", accelerator);
        }

        public void actionPerformed(ActionEvent e) {
            OpenPreviousDialog.this.openSelection();
            OpenPreviousDialog.this.setVisible(false);
        }
    }

    private class TabChangeListener
    implements ChangeListener {
        private TabChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            if (OpenPreviousDialog.this.logger.isDebugEnabled()) {
                OpenPreviousDialog.this.logger.debug("stateChanged");
            }
            OpenPreviousDialog.this.initOpenAction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum EventType {
        LOGGING("Logging"),
        ACCESS("Access");

        private String typeName;

        private EventType(String typeName) {
            this.typeName = typeName;
        }

        public String getTypeName() {
            return this.typeName;
        }
    }
}

