/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.services.sender;

import de.huxhorn.lilith.data.access.AccessEvent;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.engine.impl.sourceproducer.SerializingMessageBasedServerSocketEventSourceProducer;
import de.huxhorn.lilith.services.sender.AbstractEventSender;
import de.huxhorn.lilith.services.sender.AccessEventSender;
import de.huxhorn.lilith.services.sender.EventSender;
import de.huxhorn.lilith.services.sender.LoggingEventSender;
import de.huxhorn.lilith.swing.MainFrame;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SenderService {
    private final Logger logger = LoggerFactory.getLogger(SenderService.class);
    private final Map<String, EventSender<LoggingEvent>> loggingEventSenders;
    private final Map<String, EventSender<AccessEvent>> accessEventSenders;
    private final Map<String, JmDNS> registries;
    private String mDnsName;
    private BonjourListener bonjourListener;
    private MainFrame mainFrame;
    private NetworkWatchdogRunnable networkWatchdogRunnable;
    private Set<SerializingMessageBasedServerSocketEventSourceProducer<AccessEvent>> accessProducers;
    private Set<SerializingMessageBasedServerSocketEventSourceProducer<LoggingEvent>> loggingProducers;

    public SenderService(MainFrame mainFrame) {
        this(mainFrame, null);
    }

    public SenderService(MainFrame mainFrame, String mDnsName) {
        this.mDnsName = mDnsName;
        if (this.mDnsName == null) {
            this.mDnsName = System.getProperty("user.name");
        }
        this.mainFrame = mainFrame;
        this.loggingEventSenders = new HashMap<String, EventSender<LoggingEvent>>();
        this.accessEventSenders = new HashMap<String, EventSender<AccessEvent>>();
        this.registries = new HashMap<String, JmDNS>();
        this.accessProducers = new HashSet<SerializingMessageBasedServerSocketEventSourceProducer<AccessEvent>>();
        this.loggingProducers = new HashSet<SerializingMessageBasedServerSocketEventSourceProducer<LoggingEvent>>();
        this.bonjourListener = new BonjourListener();
    }

    public void start() {
        this.networkWatchdogRunnable = new NetworkWatchdogRunnable();
        Thread t = new Thread((Runnable)this.networkWatchdogRunnable, "NetworkWatchdogRunnable");
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Unregistering services...");
        }
        if (this.networkWatchdogRunnable != null) {
            this.networkWatchdogRunnable.shutDown();
        }
        Map<String, JmDNS> map = this.registries;
        synchronized (map) {
            for (Map.Entry<String, JmDNS> current : this.registries.entrySet()) {
                String key = current.getKey();
                JmDNS jmDns = current.getValue();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Unregistering services for {}...", (Object)key);
                }
                jmDns.unregisterAllServices();
            }
            this.registries.clear();
        }
    }

    private JmDNS createJmDNS(InetAddress address) throws IOException {
        JmDNS jmDns = JmDNS.create((InetAddress)address);
        jmDns.addServiceListener("_logging._tcp.local.", (ServiceListener)this.bonjourListener);
        jmDns.addServiceListener("_access._tcp.local.", (ServiceListener)this.bonjourListener);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Created new JmDNS instance for {}.", address);
        }
        return jmDns;
    }

    private void registerServices(JmDNS jmDns, List<ServiceInfo> serviceInfos) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Registering services for {}.", (Object)jmDns.getHostName());
        }
        ServiceRegistrationRunnable r = new ServiceRegistrationRunnable(jmDns, serviceInfos);
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterServices(JmDNS dns) {
        EventSender<Object> sender;
        ArrayList<String> obsoleteSenders;
        Map<String, EventSender<LoggingEvent>> map = this.loggingEventSenders;
        synchronized (map) {
            obsoleteSenders = new ArrayList<String>();
            for (Map.Entry<String, EventSender<LoggingEvent>> entry : this.loggingEventSenders.entrySet()) {
                sender = entry.getValue();
                if (sender.getJmDNS() != dns) continue;
                sender.discard();
                obsoleteSenders.add(entry.getKey());
            }
            for (String string : obsoleteSenders) {
                this.loggingEventSenders.remove(string);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Removed loggingEventSender for key {}.", (Object)string);
            }
        }
        map = this.accessEventSenders;
        synchronized (map) {
            obsoleteSenders = new ArrayList();
            for (Map.Entry<String, EventSender<Object>> entry : this.accessEventSenders.entrySet()) {
                sender = entry.getValue();
                if (sender.getJmDNS() != dns) continue;
                sender.discard();
                obsoleteSenders.add(entry.getKey());
            }
            for (String string : obsoleteSenders) {
                this.accessEventSenders.remove(string);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Removed accessEventSender for key {}.", (Object)string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Serializable> Map<String, EventSender<T>> getEventSenders(Map<String, EventSender<T>> senders) {
        HashMap<String, EventSender<T>> serviceNameSenderMapping;
        Map<String, EventSender<T>> map = senders;
        synchronized (map) {
            serviceNameSenderMapping = new HashMap<String, EventSender<T>>(senders);
        }
        TreeMap<String, EventSender<T>> result = new TreeMap<String, EventSender<T>>();
        for (Map.Entry current : serviceNameSenderMapping.entrySet()) {
            AbstractEventSender aes;
            EventSender value = (EventSender)current.getValue();
            String hostName = value.getHostAddress();
            EventSender prevValue = (EventSender)result.get(hostName = this.mainFrame.getPrimarySourceTitle(hostName));
            if (prevValue == null) {
                result.put(hostName, value);
                continue;
            }
            if (!(value instanceof AbstractEventSender) || !(aes = (AbstractEventSender)value).isCompressing()) continue;
            result.put(hostName, value);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Replaced previous sender with compressing one.");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("EventSenders: {}", result);
        }
        return result;
    }

    public Map<String, EventSender<LoggingEvent>> getLoggingEventSenders() {
        return this.getEventSenders(this.loggingEventSenders);
    }

    public Map<String, EventSender<AccessEvent>> getAccessEventSenders() {
        return this.getEventSenders(this.accessEventSenders);
    }

    public static Set<InetAddress> resolveInetAddresses() {
        HashSet<InetAddress> inetAddresses;
        Logger logger;
        block5: {
            logger = LoggerFactory.getLogger(SenderService.class);
            inetAddresses = new HashSet<InetAddress>();
            try {
                Enumeration<NetworkInterface> netIfcs = NetworkInterface.getNetworkInterfaces();
                while (netIfcs.hasMoreElements()) {
                    NetworkInterface ni = netIfcs.nextElement();
                    Enumeration<InetAddress> inetAddrs = ni.getInetAddresses();
                    while (inetAddrs.hasMoreElements()) {
                        InetAddress iadd = inetAddrs.nextElement();
                        if (iadd.isLoopbackAddress()) continue;
                        inetAddresses.add(iadd);
                    }
                }
            }
            catch (SocketException ex) {
                if (!logger.isWarnEnabled()) break block5;
                logger.warn("Exception while retrieving InetAddresses!", ex);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("InetAddresses: {}", inetAddresses);
        }
        return inetAddresses;
    }

    public void addLoggingProducer(SerializingMessageBasedServerSocketEventSourceProducer<LoggingEvent> producer) {
        this.loggingProducers.add(producer);
    }

    public void addAccessProducer(SerializingMessageBasedServerSocketEventSourceProducer<AccessEvent> producer) {
        this.accessProducers.add(producer);
    }

    public List<ServiceInfo> createServiceInfos() {
        ServiceInfo serviceInfo;
        int priority;
        int weight;
        int port;
        Hashtable<String, String> props;
        ArrayList<ServiceInfo> result = new ArrayList<ServiceInfo>();
        for (SerializingMessageBasedServerSocketEventSourceProducer<LoggingEvent> serializingMessageBasedServerSocketEventSourceProducer : this.loggingProducers) {
            props = new Hashtable<String, String>();
            port = serializingMessageBasedServerSocketEventSourceProducer.getPort();
            props.put("compressed", "" + serializingMessageBasedServerSocketEventSourceProducer.isCompressing());
            weight = 0;
            priority = serializingMessageBasedServerSocketEventSourceProducer.isCompressing() ? 65535 : 0;
            serviceInfo = ServiceInfo.create((String)"_logging._tcp.local.", (String)this.mDnsName, (int)port, (int)weight, (int)priority, props);
            result.add(serviceInfo);
        }
        for (SerializingMessageBasedServerSocketEventSourceProducer<LoggingEvent> serializingMessageBasedServerSocketEventSourceProducer : this.accessProducers) {
            props = new Hashtable();
            port = serializingMessageBasedServerSocketEventSourceProducer.getPort();
            props.put("compressed", "" + serializingMessageBasedServerSocketEventSourceProducer.isCompressing());
            weight = 0;
            priority = serializingMessageBasedServerSocketEventSourceProducer.isCompressing() ? 65535 : 0;
            serviceInfo = ServiceInfo.create((String)"_access._tcp.local.", (String)this.mDnsName, (int)port, (int)weight, (int)priority, props);
            result.add(serviceInfo);
        }
        return result;
    }

    private class NetworkWatchdogRunnable
    implements Runnable {
        private boolean shutDown = false;

        private NetworkWatchdogRunnable() {
        }

        public void shutDown() {
            this.shutDown = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.shutDown) {
                Set<InetAddress> inetAddresses = SenderService.resolveInetAddresses();
                HashSet<InetAddress> newAddresses = new HashSet<InetAddress>();
                HashSet obsoleteDns = new HashSet();
                Map map = SenderService.this.registries;
                synchronized (map) {
                    HashSet<String> obsoleteAddresses = new HashSet<String>();
                    for (Map.Entry entry : SenderService.this.registries.entrySet()) {
                        String key = (String)entry.getKey();
                        boolean found = false;
                        for (InetAddress add : inetAddresses) {
                            if (!add.getHostAddress().equals(key)) continue;
                            found = true;
                        }
                        if (found) continue;
                        obsoleteAddresses.add(key);
                        obsoleteDns.add(entry.getValue());
                    }
                    for (InetAddress inetAddress : inetAddresses) {
                        if (SenderService.this.registries.containsKey(inetAddress.getHostAddress())) continue;
                        newAddresses.add(inetAddress);
                    }
                    for (String string : obsoleteAddresses) {
                        SenderService.this.registries.remove(string);
                        if (!SenderService.this.logger.isDebugEnabled()) continue;
                        SenderService.this.logger.debug("Removed {} from registry.", (Object)string);
                    }
                }
                for (JmDNS current : obsoleteDns) {
                    if (SenderService.this.logger.isDebugEnabled()) {
                        SenderService.this.logger.debug("Unregistering all services for {}.", current);
                    }
                    SenderService.this.unregisterServices(current);
                    current.close();
                }
                HashSet<JmDNS> newDns = new HashSet<JmDNS>();
                for (InetAddress inetAddress : newAddresses) {
                    try {
                        JmDNS jmDNS = SenderService.this.createJmDNS(inetAddress);
                        newDns.add(jmDNS);
                    }
                    catch (IOException iOException) {
                        if (!SenderService.this.logger.isWarnEnabled()) continue;
                        SenderService.this.logger.warn("Exception while creating new JmDNS instance for address " + inetAddress + "!", iOException);
                    }
                }
                if (newDns.size() > 0) {
                    Iterator i$ = SenderService.this.registries;
                    synchronized (i$) {
                        for (JmDNS jmDNS : newDns) {
                            try {
                                SenderService.this.registries.put(jmDNS.getInterface().getHostAddress(), jmDNS);
                            }
                            catch (IOException ex) {
                                if (!SenderService.this.logger.isWarnEnabled()) continue;
                                SenderService.this.logger.warn("Exception while resolving interface of existing JmDNS instance!", ex);
                            }
                        }
                        if (SenderService.this.logger.isDebugEnabled()) {
                            SenderService.this.logger.debug("Registry after adding: {}", SenderService.this.registries);
                        }
                    }
                    for (JmDNS jmDNS : newDns) {
                        SenderService.this.registerServices(jmDNS, SenderService.this.createServiceInfos());
                    }
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    if (!SenderService.this.logger.isInfoEnabled()) break;
                    SenderService.this.logger.info("Exiting network watchdog thread because of interruption.", e);
                    break;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ServiceRegistrationRunnable
    implements Runnable {
        private List<ServiceInfo> serviceInfos;
        private JmDNS jmDns;

        public ServiceRegistrationRunnable(JmDNS jmDns, List<ServiceInfo> serviceInfos) {
            this.jmDns = jmDns;
            this.serviceInfos = serviceInfos;
        }

        @Override
        public void run() {
            if (this.jmDns != null) {
                for (ServiceInfo current : this.serviceInfos) {
                    try {
                        this.jmDns.registerService(current);
                        if (!SenderService.this.logger.isDebugEnabled()) continue;
                        SenderService.this.logger.debug("Registered {}.", current);
                    }
                    catch (IOException e) {
                        if (SenderService.this.logger.isWarnEnabled()) {
                            SenderService.this.logger.warn("Exception while registering service!", e);
                        }
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    class GetServiceInfoRunnable
    implements Runnable {
        private ServiceEvent serviceEvent;

        public GetServiceInfoRunnable(ServiceEvent serviceEvent) {
            this.serviceEvent = serviceEvent;
        }

        public void run() {
            JmDNS dns = this.serviceEvent.getDNS();
            ServiceInfo serviceInfo = dns.getServiceInfo(this.serviceEvent.getType(), this.serviceEvent.getName());
            if (SenderService.this.logger.isInfoEnabled()) {
                SenderService.this.logger.info("serviceInfo: {}", serviceInfo);
            }
        }
    }

    private class BonjourListener
    implements ServiceListener {
        private BonjourListener() {
        }

        public void serviceAdded(ServiceEvent serviceEvent) {
            if (SenderService.this.logger.isInfoEnabled()) {
                SenderService.this.logger.info("serviceAdded!");
            }
            GetServiceInfoRunnable r = new GetServiceInfoRunnable(serviceEvent);
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceRemoved(ServiceEvent serviceEvent) {
            if (SenderService.this.logger.isInfoEnabled()) {
                SenderService.this.logger.info("serviceRemoved!");
            }
            String type = serviceEvent.getType();
            String name = serviceEvent.getName();
            if (name != null) {
                if ("_logging._tcp.local.".equals(type)) {
                    EventSender sender;
                    Map map = SenderService.this.loggingEventSenders;
                    synchronized (map) {
                        sender = (EventSender)SenderService.this.loggingEventSenders.remove(name);
                    }
                    if (sender != null) {
                        sender.discard();
                        if (SenderService.this.logger.isInfoEnabled()) {
                            SenderService.this.logger.info("LoggingEventSender discarded.");
                        }
                    }
                } else if ("_access._tcp.local.".equals(type)) {
                    EventSender sender;
                    Map map = SenderService.this.accessEventSenders;
                    synchronized (map) {
                        sender = (EventSender)SenderService.this.accessEventSenders.remove(name);
                    }
                    if (sender != null) {
                        sender.discard();
                        if (SenderService.this.logger.isInfoEnabled()) {
                            SenderService.this.logger.info("AccessEventSender discarded.");
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceResolved(ServiceEvent serviceEvent) {
            if (SenderService.this.logger.isInfoEnabled()) {
                SenderService.this.logger.info("serviceResolved!");
            }
            JmDNS jmDns = serviceEvent.getDNS();
            ServiceInfo info = serviceEvent.getInfo();
            if (SenderService.this.logger.isInfoEnabled()) {
                SenderService.this.logger.info("Info: {}", info);
            }
            String type = serviceEvent.getType();
            String name = serviceEvent.getName();
            if (name != null && info != null) {
                String compressedStr = info.getPropertyString("compressed");
                boolean compressed = Boolean.valueOf(compressedStr);
                if ("_logging._tcp.local.".equals(type)) {
                    EventSender<LoggingEvent> sender = new LoggingEventSender(jmDns, name, info.getHostAddress(), info.getPort(), compressed);
                    Map map = SenderService.this.loggingEventSenders;
                    synchronized (map) {
                        sender = SenderService.this.loggingEventSenders.put(name, sender);
                        if (SenderService.this.logger.isInfoEnabled()) {
                            SenderService.this.logger.info("LoggingEventSender created.");
                        }
                    }
                    if (sender != null) {
                        sender.discard();
                        if (SenderService.this.logger.isInfoEnabled()) {
                            SenderService.this.logger.info("Previous LoggingEventSender discarded.");
                        }
                    }
                } else if ("_access._tcp.local.".equals(type)) {
                    EventSender<AccessEvent> sender = new AccessEventSender(jmDns, name, info.getHostAddress(), info.getPort(), compressed);
                    Map map = SenderService.this.accessEventSenders;
                    synchronized (map) {
                        sender = SenderService.this.accessEventSenders.put(name, sender);
                        if (SenderService.this.logger.isInfoEnabled()) {
                            SenderService.this.logger.info("AccessEventSender created.");
                        }
                    }
                    if (sender != null) {
                        sender.discard();
                        if (SenderService.this.logger.isInfoEnabled()) {
                            SenderService.this.logger.info("Previous AccessEventSender discarded.");
                        }
                    }
                }
            }
        }
    }
}

