/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.debug;

import de.huxhorn.lilith.debug.AbstractDebugRunnable;
import de.huxhorn.lilith.debug.LogStuffRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LogParamThrowableRunnable
extends AbstractDebugRunnable {
    private final Logger logger = LoggerFactory.getLogger(LogStuffRunnable.class);
    private Throwable throwable;

    public LogParamThrowableRunnable(int delay, Throwable throwable) {
        super(delay);
        this.throwable = throwable;
    }

    public void runIt() throws InterruptedException {
        MDC.put("type", "varargs");
        Object[] params = new Object[]{"One", "Two", "Three", this.throwable};
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("A trace message. param1={}, param2={}, param3={}", params);
        }
        this.sleep();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("A debug message. param1={}, param2={}, param3={}", params);
        }
        this.sleep();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("A info message. param1={}, param2={}, param3={}", params);
        }
        this.sleep();
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("A warn message. param1={}, param2={}, param3={}", params);
        }
        this.sleep();
        if (this.logger.isErrorEnabled()) {
            this.logger.error("A error message. param1={}, param2={}, param3={}", params);
        }
        this.sleep();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("A info message. param1={}, param2={}, param3={}, exceptionString={}", params);
        }
        this.sleep();
        MDC.remove("type");
    }
}

