/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.consumers;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.engine.EventConsumer;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdoutEventConsumer<T extends Serializable>
implements EventConsumer<T>,
Runnable {
    final Logger logger = LoggerFactory.getLogger(StdoutEventConsumer.class);
    private List<EventWrapper> events = new LinkedList<EventWrapper>();
    private Lock lock = new ReentrantLock();
    private long writeInterval = 2000L;

    public long getWriteInterval() {
        return this.writeInterval;
    }

    public void setWriteInterval(long writeInterval) {
        this.writeInterval = writeInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(List<EventWrapper<T>> events) {
        this.lock.lock();
        try {
            this.events.addAll(events);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            this.lock.lock();
            int eventCount = 0;
            try {
                if (this.events.size() > 0) {
                    EventWrapper event = this.events.remove(0);
                    System.out.println("Event: " + event);
                    eventCount = this.events.size();
                }
            }
            finally {
                this.lock.unlock();
            }
            if (eventCount != 0) continue;
            try {
                Thread.sleep(this.writeInterval);
            }
            catch (InterruptedException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Interrupted...");
                }
                return;
            }
        }
    }
}

