/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.consumers;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.engine.EventConsumer;
import de.huxhorn.lilith.engine.EventSource;
import de.huxhorn.lilith.engine.FileBufferFactory;
import de.huxhorn.lilith.engine.SourceManager;
import de.huxhorn.lilith.engine.impl.EventSourceImpl;
import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.buffers.FileBuffer;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSplitterEventConsumer<T extends Serializable>
implements EventConsumer<T> {
    private final Logger logger = LoggerFactory.getLogger(FileSplitterEventConsumer.class);
    private FileBufferFactory<T> fileBufferFactory;
    private ConcurrentMap<SourceIdentifier, FileBuffer<EventWrapper<T>>> fileBuffers;
    private SourceManager<T> sourceManager;

    public FileSplitterEventConsumer(FileBufferFactory<T> fileBufferFactory, SourceManager<T> sourceManager) {
        this.fileBufferFactory = fileBufferFactory;
        this.fileBuffers = new ConcurrentHashMap<SourceIdentifier, FileBuffer<EventWrapper<T>>>();
        this.sourceManager = sourceManager;
    }

    public void consume(List<EventWrapper<T>> events) {
        if (events != null && events.size() > 0) {
            SourceIdentifier si;
            HashMap<SourceIdentifier, ArrayList<EventWrapper<T>>> splittedEvents = new HashMap<SourceIdentifier, ArrayList<EventWrapper<T>>>();
            for (EventWrapper<T> eventWrapper : events) {
                si = eventWrapper.getSourceIdentifier();
                ArrayList<EventWrapper<T>> sourceList = (ArrayList<EventWrapper<T>>)splittedEvents.get(si);
                if (sourceList == null) {
                    sourceList = new ArrayList<EventWrapper<T>>();
                    splittedEvents.put(si, sourceList);
                }
                sourceList.add(eventWrapper);
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Split {} events to {} sources.", events.size(), (Object)splittedEvents.size());
            }
            for (Map.Entry entry : splittedEvents.entrySet()) {
                si = (SourceIdentifier)entry.getKey();
                List value = (List)entry.getValue();
                int valueCount = value.size();
                EventWrapper lastEvent = (EventWrapper)value.get(valueCount - 1);
                FileBuffer<EventWrapper<T>> buffer = this.resolveBuffer(si);
                buffer.addAll(value);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Wrote {} events for source '{}'.", valueCount, (Object)si);
                }
                if (lastEvent.getEvent() != null) continue;
                if (this.sourceManager != null) {
                    this.sourceManager.removeSource(si);
                }
                File activeFile = this.fileBufferFactory.getLogFileFactory().getActiveFile(si);
                activeFile.delete();
                this.fileBuffers.remove(si);
            }
        }
    }

    private FileBuffer<EventWrapper<T>> resolveBuffer(SourceIdentifier si) {
        FileBuffer result = (FileBuffer)this.fileBuffers.get(si);
        if (result == null) {
            result = this.fileBufferFactory.createActiveBuffer(si);
            FileBuffer contained = this.fileBuffers.putIfAbsent(si, result);
            if (contained != null) {
                result = contained;
            } else if (this.sourceManager != null) {
                this.sourceManager.addSource((EventSource)new EventSourceImpl(si, (Buffer)result, false));
            }
        }
        return result;
    }
}

