/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.consumers;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.engine.EventConsumer;
import de.huxhorn.lilith.engine.FileBufferFactory;
import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.buffers.FileBuffer;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDumpEventConsumer<T extends Serializable>
implements EventConsumer<T> {
    private final Logger logger = LoggerFactory.getLogger(FileDumpEventConsumer.class);
    private FileBuffer<EventWrapper<T>> fileBuffer;

    public FileDumpEventConsumer(SourceIdentifier sourceIdentifier, FileBufferFactory<T> fileBufferFactory) {
        this.fileBuffer = fileBufferFactory.createActiveBuffer(sourceIdentifier);
    }

    public void consume(List<EventWrapper<T>> events) {
        this.fileBuffer.addAll(events);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Wrote {} events to file.", events.size());
        }
    }

    public Buffer<EventWrapper<T>> getBuffer() {
        return this.fileBuffer;
    }
}

