/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.buffers;

import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.buffers.Dispose;
import de.huxhorn.sulky.buffers.DisposeOperation;
import de.huxhorn.sulky.buffers.Reset;
import de.huxhorn.sulky.buffers.ResetOperation;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftReferenceCachingBuffer<E>
implements Buffer<E>,
ResetOperation,
DisposeOperation {
    private final Logger logger = LoggerFactory.getLogger(SoftReferenceCachingBuffer.class);
    private static final ReferenceQueue refQueue = new ReferenceQueue();
    private Buffer<E> buffer;
    private Map<Long, MySoftReference<E>> cache;
    private boolean disposed = false;

    public SoftReferenceCachingBuffer(Buffer<E> buffer) {
        this.buffer = buffer;
        this.cache = new ConcurrentHashMap<Long, MySoftReference<E>>();
    }

    Buffer<E> getWrappedBuffer() {
        return this.buffer;
    }

    public E get(long index) {
        Object result;
        if (this.disposed) {
            return null;
        }
        SoftReference softy = this.cache.get(index);
        if (softy != null) {
            result = softy.get();
            if (result == null) {
                this.cache.remove(index);
            } else {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Retrieved {} from cache.", index);
                }
                return (E)result;
            }
        }
        if ((result = this.buffer.get(index)) != null) {
            this.cache.put(index, new MySoftReference<E>(this.cache, index, result));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Added {} to cache.", index);
            }
        }
        return (E)result;
    }

    public long getSize() {
        return this.buffer.getSize();
    }

    public Iterator<E> iterator() {
        return this.buffer.iterator();
    }

    public void reset() {
        Reset.reset(this.buffer);
        this.cache.clear();
    }

    public void dispose() {
        this.disposed = true;
        this.cache.clear();
        Dispose.dispose(this.buffer);
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    static {
        Thread cleanupThread = new Thread((Runnable)new ReferenceQueueRunnable(), "ReferenceQueue-Cleanup");
        cleanupThread.setDaemon(true);
        cleanupThread.start();
        Logger logger = LoggerFactory.getLogger(SoftReferenceCachingBuffer.class);
        if (logger.isInfoEnabled()) {
            logger.info("Started thread {}.", cleanupThread);
        }
    }

    private static class ReferenceQueueRunnable
    implements Runnable {
        private ReferenceQueueRunnable() {
        }

        public void run() {
            try {
                while (true) {
                    Reference ref;
                    if ((ref = refQueue.remove()) instanceof MySoftReference) {
                        MySoftReference reference = (MySoftReference)ref;
                        reference.removeFromCache();
                        continue;
                    }
                    Logger logger = LoggerFactory.getLogger(SoftReferenceCachingBuffer.class);
                    if (!logger.isWarnEnabled()) continue;
                    logger.warn("Unexpected reference!! {}", ref);
                }
            }
            catch (InterruptedException e) {
                block4: {
                    Logger logger = LoggerFactory.getLogger(SoftReferenceCachingBuffer.class);
                    if (!logger.isInfoEnabled()) break block4;
                    logger.info("Interrupted ReferenceQueueRunnable...");
                }
                return;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MySoftReference<E>
    extends SoftReference<E> {
        private long index;
        private Map<Long, MySoftReference<E>> cache;

        public MySoftReference(Map<Long, MySoftReference<E>> cache, long index, E referent) {
            super(referent, refQueue);
            this.index = index;
            this.cache = cache;
        }

        public long getIndex() {
            return this.index;
        }

        public void removeFromCache() {
            this.cache.remove(this.index);
            Logger logger = LoggerFactory.getLogger(SoftReferenceCachingBuffer.class);
            if (logger.isDebugEnabled()) {
                logger.debug("Removed {} from cache.", this.index);
            }
        }
    }
}

