/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.buffers;

import de.huxhorn.lilith.swing.callables.FilteringCallable;
import de.huxhorn.sulky.buffers.BasicBufferIterator;
import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.buffers.DisposeOperation;
import de.huxhorn.sulky.conditions.Condition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringBuffer<E>
implements Buffer<E>,
DisposeOperation {
    private final Logger logger = LoggerFactory.getLogger(FilteringCallable.class);
    private Buffer<E> sourceBuffer;
    private Condition condition;
    private ReentrantReadWriteLock indicesLock = new ReentrantReadWriteLock();
    private final List<Long> filteredIndices;
    private boolean disposed;

    public static <E> Buffer<E> resolveSourceBuffer(Buffer<E> buffer) {
        while (buffer instanceof FilteringBuffer) {
            buffer = ((FilteringBuffer)buffer).getSourceBuffer();
        }
        return buffer;
    }

    public FilteringBuffer(Buffer<E> sourceBuffer, Condition condition) {
        this.sourceBuffer = sourceBuffer;
        this.condition = condition;
        this.filteredIndices = new ArrayList<Long>();
        this.disposed = false;
    }

    public E get(long index) {
        long realIndex = this.getSourceIndex(index);
        if (realIndex >= 0L) {
            return (E)this.sourceBuffer.get(realIndex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSourceIndex(long index) {
        long realIndex = -1L;
        ReentrantReadWriteLock.ReadLock lock = this.indicesLock.readLock();
        lock.lock();
        try {
            if (index >= 0L && index < (long)this.filteredIndices.size()) {
                realIndex = this.filteredIndices.get((int)index);
            }
        }
        finally {
            lock.unlock();
        }
        return realIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        ReentrantReadWriteLock.ReadLock lock = this.indicesLock.readLock();
        lock.lock();
        try {
            long l = this.filteredIndices.size();
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilteredIndex(long index) {
        long size = this.sourceBuffer.getSize();
        if ((index < 0L || index >= this.sourceBuffer.getSize()) && this.logger.isInfoEnabled()) {
            this.logger.info("Invalid filtered index {} (size={})!", index, (Object)size);
        }
        ReentrantReadWriteLock.WriteLock lock = this.indicesLock.writeLock();
        lock.lock();
        try {
            this.filteredIndices.add(index);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFilteredIndices() {
        ReentrantReadWriteLock.WriteLock lock = this.indicesLock.writeLock();
        lock.lock();
        try {
            this.filteredIndices.clear();
        }
        finally {
            lock.unlock();
        }
    }

    public Iterator<E> iterator() {
        return new BasicBufferIterator((Buffer)this);
    }

    public Buffer<E> getSourceBuffer() {
        return this.sourceBuffer;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public synchronized void dispose() {
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }
}

