/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.appender;

import ch.qos.logback.core.AppenderBase;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.logback.LogbackLoggingAdapter;
import de.huxhorn.lilith.engine.LogFileFactory;
import de.huxhorn.lilith.engine.LoggingFileBufferFactory;
import de.huxhorn.lilith.engine.impl.LogFileFactoryImpl;
import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.buffers.FileBuffer;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalLilithAppender
extends AppenderBase<ch.qos.logback.classic.spi.LoggingEvent> {
    private static final FileBuffer<EventWrapper<LoggingEvent>> fileBuffer;
    private static final SourceIdentifier sourceIdentifier;
    private LogbackLoggingAdapter adapter = new LogbackLoggingAdapter();
    private long localId = 0L;

    public static Buffer<EventWrapper<LoggingEvent>> getBuffer() {
        return fileBuffer;
    }

    public static SourceIdentifier getSourceIdentifier() {
        try {
            return sourceIdentifier.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    protected void append(ch.qos.logback.classic.spi.LoggingEvent event) {
        if (event != null && fileBuffer != null) {
            ++this.localId;
            event.getCallerData();
            LoggingEvent lilithEvent = this.adapter.convert(event, true);
            EventWrapper wrapper = new EventWrapper(sourceIdentifier, this.localId, (Serializable)lilithEvent);
            fileBuffer.add((Object)wrapper);
        }
    }

    static {
        sourceIdentifier = new SourceIdentifier("Lilith");
        LogFileFactoryImpl logFileFactory = new LogFileFactoryImpl(new File(ApplicationPreferences.DEFAULT_APPLICATION_PATH, "logs/logging"));
        HashMap<String, String> loggingMetaData = new HashMap<String, String>();
        loggingMetaData.put("contentType", "logging");
        loggingMetaData.put("contentFormat", "protobuf");
        loggingMetaData.put("compression", "GZIP");
        LoggingFileBufferFactory fileBufferFactory = new LoggingFileBufferFactory((LogFileFactory)logFileFactory, loggingMetaData);
        fileBuffer = fileBufferFactory.createActiveBuffer(sourceIdentifier);
    }
}

