/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import de.huxhorn.lilith.appender.InternalLilithAppender;
import de.huxhorn.lilith.handler.Slf4JHandler;
import de.huxhorn.lilith.swing.ApplicationPreferences;
import de.huxhorn.lilith.swing.LicenseAgreementDialog;
import de.huxhorn.lilith.swing.MainFrame;
import de.huxhorn.lilith.swing.SplashScreen;
import de.huxhorn.lilith.swing.callables.IndexingCallable;
import de.huxhorn.sulky.sounds.Sounds;
import de.huxhorn.sulky.sounds.jlayer.JLayerSounds;
import de.huxhorn.sulky.swing.Windows;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.simplericity.macify.eawt.DefaultApplication;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lilith {
    public static final String APP_NAME;
    public static final String APP_VERSION;
    public static final String APP_BUILD_NUMBER;
    public static final long APP_TIMESTAMP;
    private static final String VERBOSE_SHORT = "v";
    private static final String PRINT_HELP_SHORT = "h";
    private static final String FLUSH_PREFERENCES_SHORT = "F";
    private static final String FLUSH_LICENSED_SHORT = "L";
    private static final String INDEX_SHORT = "i";
    private static final String ENABLE_BONJOUR_SHORT = "b";
    private static final String CREATE_MD5_SHORT = "m";
    private static final String VERBOSE = "verbose";
    private static final String PRINT_HELP = "help";
    private static final String FLUSH_PREFERENCES = "flushPrefs";
    private static final String FLUSH_LICENSED = "flushLicensed";
    private static final String INDEX = "indexFile";
    private static final String ENABLE_BONJOUR = "bonjour";
    private static final String CREATE_MD5 = "md5";
    private static Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    public static void main(String[] args) {
        ApplicationPreferences prefs;
        ILoggerFactory loggerFactory;
        boolean printHelp;
        Logger logger = LoggerFactory.getLogger(Lilith.class);
        Slf4JHandler handler = new Slf4JHandler();
        java.util.logging.Logger rootLogger = java.util.logging.Logger.getLogger("");
        rootLogger.addHandler((Handler)handler);
        rootLogger.setLevel(Level.WARNING);
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption(PRINT_HELP_SHORT, PRINT_HELP, false, "show this help.");
        options.addOption(VERBOSE_SHORT, VERBOSE, false, "show more info.");
        options.addOption(FLUSH_PREFERENCES_SHORT, FLUSH_PREFERENCES, false, "flush gui preferences.");
        options.addOption(FLUSH_LICENSED_SHORT, FLUSH_LICENSED, false, "flush licensed.");
        options.addOption(ENABLE_BONJOUR_SHORT, ENABLE_BONJOUR, false, "disable Bonjor.");
        options.addOption(INDEX_SHORT, INDEX, false, "indexes the given file.");
        options.addOption(CREATE_MD5_SHORT, CREATE_MD5, false, "create an MD% checksum for the given file.");
        boolean verbose = false;
        boolean flushPrefs = false;
        boolean flushLicensed = false;
        boolean enableBonjour = false;
        boolean indexFileOpt = false;
        boolean createMd5 = false;
        String[] originalArgs = args;
        int exitCode = 0;
        try {
            CommandLine line = parser.parse(options, args);
            verbose = line.hasOption(VERBOSE_SHORT);
            printHelp = line.hasOption(PRINT_HELP_SHORT);
            flushPrefs = line.hasOption(FLUSH_PREFERENCES_SHORT);
            flushLicensed = line.hasOption(FLUSH_LICENSED_SHORT);
            enableBonjour = line.hasOption(ENABLE_BONJOUR_SHORT);
            indexFileOpt = line.hasOption(INDEX_SHORT);
            createMd5 = line.hasOption(CREATE_MD5_SHORT);
            args = line.getArgs();
        }
        catch (ParseException exp) {
            exitCode = -1;
            printHelp = true;
        }
        String appTitle = APP_NAME + " V" + APP_VERSION + "." + APP_BUILD_NUMBER;
        if (verbose) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            Date d = new Date(APP_TIMESTAMP);
            appTitle = appTitle + " - " + sdf.format(d);
        }
        System.out.println(" _     _ _ _ _   _     \n| |   (_) (_) |_| |__  \n| |   | | | | __| '_ \\ \n| |___| | | | |_| | | |\n|_____|_|_|_|\\__|_| |_|");
        System.out.println(appTitle);
        System.out.println("\nCopyright (C) 2007-2008  Joern Huxhorn\n\nThis program comes with ABSOLUTELY NO WARRANTY!\n\nThis is free software, and you are welcome to redistribute it\nunder certain conditions.\nYou should have received a copy of the GNU General Public License\nalong with this program.  If not, see <http://www.gnu.org/licenses/>.\n");
        System.out.println("Use commandline option -h to view help.\n\n");
        if (createMd5) {
            block32: {
                File input = new File(args[0]);
                if (!input.isFile()) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("{} isn't a file!", (Object)input.getAbsolutePath());
                    }
                    return;
                }
                File output = new File(input.getParentFile(), input.getName() + ".md5");
                try {
                    FileInputStream fis = new FileInputStream(input);
                    byte[] md5 = ApplicationPreferences.getMD5(fis);
                    if (md5 == null) {
                        if (logger.isWarnEnabled()) {
                            logger.warn("Couldn't calculate checksum for {}!", (Object)input.getAbsolutePath());
                        }
                        return;
                    }
                    FileOutputStream fos = new FileOutputStream(output);
                    fos.write(md5);
                    fos.close();
                    if (logger.isInfoEnabled()) {
                        logger.info("Wrote checksum of {} to {}.", (Object)input.getAbsolutePath(), (Object)output.getAbsolutePath());
                    }
                }
                catch (IOException e) {
                    if (!logger.isWarnEnabled()) break block32;
                    logger.warn("Exception while creating checksum!", e);
                }
            }
            return;
        }
        if (verbose) {
            int i;
            for (i = 0; i < originalArgs.length; ++i) {
                System.out.println("originalArgs[" + i + "]: " + originalArgs[i]);
            }
            for (i = 0; i < args.length; ++i) {
                System.out.println("args[" + i + "]: " + args[i]);
            }
            System.out.println("\n");
        }
        if ((loggerFactory = LoggerFactory.getILoggerFactory()) instanceof LoggerContext) {
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            if (verbose) {
                loggerContext.reset();
                JoranConfigurator configurator = new JoranConfigurator();
                configurator.setContext((Context)loggerContext);
                URL configUrl = Lilith.class.getResource("/logbackVerbose.xml");
                try {
                    configurator.doConfigure(configUrl);
                    if (logger.isDebugEnabled()) {
                        logger.debug("Configured logging with {}.", configUrl);
                    }
                    StatusPrinter.print((Context)loggerContext);
                }
                catch (JoranException ex) {
                    if (logger.isErrorEnabled()) {
                        logger.error("Error configuring logging framework!", ex);
                    }
                    StatusPrinter.print((Context)loggerContext);
                }
            }
        }
        if (flushPrefs) {
            prefs = new ApplicationPreferences();
            prefs.reset();
            prefs.setLicensed(false);
            if (logger.isInfoEnabled()) {
                logger.info("Flushed preferences...");
            }
            return;
        }
        if (flushLicensed) {
            prefs = new ApplicationPreferences();
            prefs.setLicensed(false);
            if (logger.isInfoEnabled()) {
                logger.info("Flushed licensed...");
            }
            return;
        }
        if (printHelp) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("lilith", options);
            System.exit(exitCode);
        }
        if (indexFileOpt) {
            if (args.length >= 2) {
                String logFileStr = args[0];
                String indexFileStr = args[1];
                File logFile = new File(logFileStr);
                File indexFile = new File(indexFileStr);
                IndexingCallable callable = new IndexingCallable(logFile, indexFile);
                callable.addPropertyChangeListener(new IndexingChangeListener());
                try {
                    long count = callable.call();
                    if (logger.isInfoEnabled()) {
                        logger.info("Finished indexing {}. Number of events: {}", (Object)logFile.getAbsolutePath(), (Object)count);
                    }
                    System.exit(0);
                }
                catch (Exception e) {
                    if (logger.isErrorEnabled()) {
                        logger.error("Exception while indexing '" + logFile.getAbsolutePath() + "'!", e);
                    }
                    System.exit(-1);
                }
            }
            if (logger.isErrorEnabled()) {
                logger.error("Missing file argument!");
            }
            System.exit(-1);
        }
        uncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

            public void uncaughtException(Thread t, Throwable e) {
                System.err.println("\n-----\nThread " + t.getName() + " threw an exception!");
                e.printStackTrace(System.err);
            }
        };
        Thread.setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Thread.currentThread().setUncaughtExceptionHandler(uncaughtExceptionHandler);
            }
        });
        Lilith.startUI(appTitle, enableBonjour);
    }

    private static void updateSplashStatus(final SplashScreen splashScreen, final String status) throws InvocationTargetException, InterruptedException {
        if (splashScreen != null) {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    if (!splashScreen.isVisible()) {
                        Windows.showWindow((Window)splashScreen, null, (boolean)true);
                    }
                    splashScreen.toFront();
                    splashScreen.setStatusText(status);
                }
            });
        }
    }

    private static void hideSplashScreen(final SplashScreen splashScreen) throws InvocationTargetException, InterruptedException {
        if (splashScreen != null) {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    splashScreen.setVisible(false);
                }
            });
        }
    }

    public static void startUI(String appTitle, boolean enableBonjour) {
        block30: {
            String lookAndFeel;
            Logger logger = LoggerFactory.getLogger(Lilith.class);
            UIManager.installLookAndFeel("JGoodies Windows", "com.jgoodies.looks.windows.WindowsLookAndFeel");
            UIManager.installLookAndFeel("JGoodies Plastic", "com.jgoodies.looks.plastic.PlasticLookAndFeel");
            UIManager.installLookAndFeel("JGoodies Plastic 3D", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
            UIManager.installLookAndFeel("JGoodies Plastic XP", "com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
            DefaultApplication application = new DefaultApplication();
            ApplicationPreferences applicationPreferences = new ApplicationPreferences();
            if (application.isMac()) {
                try {
                    System.setProperty("apple.laf.useScreenMenuBar", "true");
                }
                catch (Exception e) {
                    System.setProperty("com.apple.macos.useScreenMenuBar", "true");
                }
            }
            if ((lookAndFeel = applicationPreferences.getLookAndFeel()) != null) {
                try {
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        if (!lookAndFeel.equals(info.getName())) continue;
                        String lafClassName = info.getClassName();
                        if (logger.isDebugEnabled()) {
                            logger.debug("Setting look&feel to {}.", (Object)lafClassName);
                        }
                        UIManager.setLookAndFeel(lafClassName);
                        break;
                    }
                }
                catch (UnsupportedLookAndFeelException e) {
                }
                catch (ClassNotFoundException e) {
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
            boolean splashScreenDisabled = applicationPreferences.isSplashScreenDisabled();
            try {
                File startupApplicationPath;
                SplashScreen splashScreen = null;
                if (!splashScreenDisabled) {
                    CreateSplashRunnable createRunnable = new CreateSplashRunnable(appTitle);
                    SwingUtilities.invokeAndWait(createRunnable);
                    splashScreen = createRunnable.getSplashScreen();
                    Thread.sleep(500L);
                    Lilith.updateSplashStatus(splashScreen, "Initialized application preferences...");
                }
                if ((startupApplicationPath = applicationPreferences.getStartupApplicationPath()).mkdirs() && logger.isDebugEnabled()) {
                    logger.debug("Created '{}'.", (Object)startupApplicationPath.getAbsolutePath());
                }
                File errorLog = new File(startupApplicationPath, "errors.log");
                boolean freshFile = false;
                if (!errorLog.isFile()) {
                    freshFile = true;
                }
                try {
                    FileOutputStream fos = new FileOutputStream(errorLog, true);
                    PrintStream ps = new PrintStream(fos, true);
                    if (!freshFile) {
                        ps.println("----------------------------------------");
                    }
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
                    ps.println("Started " + APP_NAME + " V" + APP_VERSION + " at " + format.format(new Date()));
                    System.setErr(ps);
                    if (logger.isInfoEnabled()) {
                        logger.info("Writing System.err to '{}'.", (Object)errorLog.getAbsolutePath());
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                File prevPathFile = new File(startupApplicationPath, ".previous.application.path");
                if (prevPathFile.isFile()) {
                    Lilith.updateSplashStatus(splashScreen, "Moving application path content...");
                    Lilith.moveApplicationPathContent(prevPathFile, startupApplicationPath);
                }
                if (!applicationPreferences.isLicensed()) {
                    Lilith.hideSplashScreen(splashScreen);
                    LicenseAgreementDialog licenseDialog = new LicenseAgreementDialog();
                    Windows.showWindow((Window)licenseDialog, null, (boolean)true);
                    if (licenseDialog.isLicenseAgreed()) {
                        applicationPreferences.setLicensed(true);
                    } else {
                        if (logger.isWarnEnabled()) {
                            logger.warn("Didn't accept license! Exiting...");
                        }
                        System.exit(-1);
                    }
                }
                Lilith.updateSplashStatus(splashScreen, "Creating main window...");
                CreateMainFrameRunnable createMain = new CreateMainFrameRunnable(applicationPreferences, splashScreen, appTitle, enableBonjour);
                SwingUtilities.invokeAndWait(createMain);
                final MainFrame frame = createMain.getMainFrame();
                if (logger.isDebugEnabled()) {
                    logger.debug("After show...");
                }
                Lilith.updateSplashStatus(splashScreen, "Initializing application...");
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        frame.startUp();
                    }
                });
                Lilith.hideSplashScreen(splashScreen);
            }
            catch (InterruptedException ex) {
                if (logger.isInfoEnabled()) {
                    logger.info("Interrupted...", ex);
                }
            }
            catch (InvocationTargetException ex) {
                if (logger.isWarnEnabled()) {
                    logger.warn("InvocationTargetException...", ex);
                }
                if (!logger.isWarnEnabled()) break block30;
                logger.warn("Target-Exception: ", ex.getTargetException());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void moveApplicationPathContent(File prevPathFile, File startupApplicationPath) {
        Logger logger = LoggerFactory.getLogger(Lilith.class);
        FileInputStream is = null;
        String prevPathStr = null;
        try {
            is = new FileInputStream(prevPathFile);
            prevPathStr = IOUtils.toString((InputStream)is);
        }
        catch (IOException ex) {
            block8: {
                try {
                    if (!logger.isWarnEnabled()) break block8;
                    logger.warn("Exception while reading previous application path!", ex);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        IOUtils.closeQuietly((InputStream)is);
        if (prevPathStr != null) {
            File prevPath;
            block9: {
                prevPath = new File(prevPathStr);
                try {
                    FileUtils.copyDirectory((File)prevPath, (File)startupApplicationPath);
                    FileUtils.deleteDirectory((File)prevPath);
                }
                catch (IOException ex) {
                    if (!logger.isWarnEnabled()) break block9;
                    logger.warn("Exception while moving content of previous application path '" + prevPath.getAbsolutePath() + "' to new one '" + startupApplicationPath.getAbsolutePath() + "'!", ex);
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info("Moved content from previous application path '{}' to new application path '{}'.", (Object)prevPath.getAbsolutePath(), (Object)startupApplicationPath.getAbsolutePath());
            }
        }
        prevPathFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InternalLilithAppender.getSourceIdentifier();
        Logger logger = LoggerFactory.getLogger(Lilith.class);
        InputStream is = Lilith.class.getResourceAsStream("/app.properties");
        Properties p = new Properties();
        try {
            p.load(is);
        }
        catch (IOException ex) {
            if (logger.isErrorEnabled()) {
                logger.error("Couldn't find app info resource!", ex);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        APP_NAME = p.getProperty("application.name");
        APP_VERSION = p.getProperty("application.version");
        APP_BUILD_NUMBER = p.getProperty("application.buildNumber");
        String tsStr = p.getProperty("application.timestamp");
        long ts = -1L;
        if (tsStr != null) {
            try {
                ts = Long.parseLong(tsStr);
            }
            catch (NumberFormatException ex) {
                if (logger.isErrorEnabled()) {
                    logger.error("Exception while reading timestamp!", ex);
                }
            }
        } else if (logger.isErrorEnabled()) {
            logger.error("Application-timestamp not found!");
        }
        APP_TIMESTAMP = ts;
    }

    private static class IndexingChangeListener
    implements PropertyChangeListener {
        private final Logger logger = LoggerFactory.getLogger(Lilith.class);

        private IndexingChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("progress".equals(evt.getPropertyName()) && this.logger.isInfoEnabled()) {
                this.logger.info("Progress: {}%", evt.getNewValue());
            }
        }
    }

    static class CreateMainFrameRunnable
    implements Runnable {
        private SplashScreen splashScreen;
        private MainFrame mainFrame;
        private ApplicationPreferences applicationPreferences;
        private String appTitle;
        private boolean enableBonjour;

        public CreateMainFrameRunnable(ApplicationPreferences applicationPreferences, SplashScreen splashScreen, String appTitle, boolean enableBonjour) {
            this.splashScreen = splashScreen;
            this.enableBonjour = enableBonjour;
            this.appTitle = appTitle;
            this.applicationPreferences = applicationPreferences;
        }

        public void run() {
            this.mainFrame = new MainFrame(this.applicationPreferences, this.splashScreen, this.appTitle, this.enableBonjour);
            this.mainFrame.setSounds((Sounds)new JLayerSounds());
            this.mainFrame.setSize(1024, 768);
            Windows.showWindow((Window)this.mainFrame, null, (boolean)false);
        }

        public MainFrame getMainFrame() {
            return this.mainFrame;
        }
    }

    static class CreateSplashRunnable
    implements Runnable {
        private SplashScreen splashScreen;
        private String appTitle;

        public CreateSplashRunnable(String appTitle) {
            this.appTitle = appTitle;
        }

        public void run() {
            this.splashScreen = new SplashScreen(this.appTitle);
            Windows.showWindow((Window)this.splashScreen, null, (boolean)true);
        }

        public SplashScreen getSplashScreen() {
            return this.splashScreen;
        }
    }
}

