/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.engine.impl.sourcemanager;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.engine.EventConsumer;
import de.huxhorn.lilith.engine.EventProducer;
import de.huxhorn.lilith.engine.EventSource;
import de.huxhorn.lilith.engine.EventSourceListener;
import de.huxhorn.lilith.engine.EventSourceProducer;
import de.huxhorn.lilith.engine.SourceManager;
import de.huxhorn.lilith.engine.impl.sourcemanager.EventPoller;
import de.huxhorn.sulky.buffers.AppendOperation;
import de.huxhorn.sulky.buffers.BlockingCircularBuffer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceManagerImpl<T extends Serializable>
implements SourceManager<T> {
    private final Logger logger = LoggerFactory.getLogger(SourceManagerImpl.class);
    private BlockingCircularBuffer<EventWrapper<T>> queue;
    private Set<EventSourceListener<T>> listeners;
    private PropertyChangeSupport changeSupport;
    private List<EventSource<T>> sources;
    private Map<SourceIdentifier, EventProducer> eventProducers;
    private EventPoller<T> eventPoller;
    private static final String NUMBER_OF_SOURCES = "numberOfSources";
    private List<EventSourceProducer<T>> eventSourceProducers;

    public SourceManagerImpl(BlockingCircularBuffer<EventWrapper<T>> queue) {
        this.queue = queue;
        this.eventPoller = new EventPoller<T>(queue);
        this.eventProducers = new HashMap<SourceIdentifier, EventProducer>();
        this.eventSourceProducers = new ArrayList<EventSourceProducer<T>>();
        this.listeners = new HashSet<EventSourceListener<T>>();
        this.changeSupport = new PropertyChangeSupport(this);
        this.sources = new ArrayList<EventSource<T>>();
    }

    @Override
    public void addSource(EventSource<T> source) {
        int oldSize = this.sources.size();
        if (!this.sources.contains(source)) {
            this.sources.add(source);
            int newSize = this.sources.size();
            this.changeSupport.firePropertyChange(NUMBER_OF_SOURCES, oldSize, newSize);
            this.fireAddSource(source);
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Added source {}.", source);
            }
        }
    }

    @Override
    public void removeSource(SourceIdentifier source) {
        int oldSize = this.sources.size();
        ArrayList<EventSource<T>> removedSources = new ArrayList<EventSource<T>>();
        for (EventSource<T> src : this.sources) {
            if (!source.equals((Object)src.getSourceIdentifier())) continue;
            removedSources.add(src);
        }
        this.sources.removeAll(removedSources);
        int newSize = this.sources.size();
        this.changeSupport.firePropertyChange(NUMBER_OF_SOURCES, oldSize, newSize);
        for (EventSource eventSource : removedSources) {
            this.fireRemoveSource(eventSource);
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info("Removed source {}.", (Object)eventSource);
        }
    }

    private void fireAddSource(EventSource<T> source) {
        for (EventSourceListener<T> listener : this.listeners) {
            listener.eventSourceAdded(source);
        }
    }

    private void fireRemoveSource(EventSource<T> source) {
        for (EventSourceListener<T> listener : this.listeners) {
            listener.eventSourceRemoved(source);
        }
    }

    @Override
    public List<EventSource<T>> getSources() {
        return new ArrayList<EventSource<T>>(this.sources);
    }

    @Override
    public int getNumberOfSources() {
        return this.sources.size();
    }

    @Override
    public void addEventSourceProducer(EventSourceProducer<T> producer) {
        producer.setQueue((AppendOperation<EventWrapper<T>>)this.queue);
        producer.setSourceManager(this);
        this.eventSourceProducers.add(producer);
    }

    @Override
    public void addEventProducer(EventProducer producer) {
        SourceIdentifier id = producer.getSourceIdentifier();
        EventProducer previous = this.eventProducers.put(id, producer);
        if (previous != null) {
            previous.close();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Started {}.", (Object)producer);
        }
    }

    @Override
    public void removeEventProducer(SourceIdentifier id) {
        EventProducer producer = this.eventProducers.remove(id);
        if (producer != null) {
            producer.close();
        }
    }

    @Override
    public void setEventConsumers(List<EventConsumer<T>> consumers) {
        this.eventPoller.setConsumers(consumers);
    }

    @Override
    public List<EventConsumer<T>> getEventConsumers() {
        return this.eventPoller.getConsumers();
    }

    @Override
    public void addEventSourceListener(EventSourceListener<T> listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeEventSourceListener(EventSourceListener<T> listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void start() {
        Thread t;
        Thread t2 = new Thread(this.eventPoller, "EventPoller");
        t2.setDaemon(true);
        t2.start();
        for (EventConsumer<T> eventConsumer : this.getEventConsumers()) {
            if (!(eventConsumer instanceof Runnable)) continue;
            t = new Thread((Runnable)((Object)eventConsumer), "Consumer-Thread");
            t.setDaemon(true);
            t.start();
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info("Started {}.", (Object)t);
        }
        for (EventSourceProducer eventSourceProducer : this.eventSourceProducers) {
            if (!(eventSourceProducer instanceof Runnable)) continue;
            t = new Thread((Runnable)((Object)eventSourceProducer), "Producer-Thread-" + eventSourceProducer);
            t.setDaemon(true);
            t.start();
            if (!this.logger.isInfoEnabled()) continue;
            this.logger.info("Started {}.", (Object)t);
        }
    }
}

