/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.engine.impl.eventproducer;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.engine.EventProducer;
import de.huxhorn.sulky.buffers.AppendOperation;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEventProducer<T extends Serializable>
implements EventProducer {
    private final Logger logger = LoggerFactory.getLogger(AbstractEventProducer.class);
    private AppendOperation<EventWrapper<T>> eventQueue;
    private SourceIdentifier sourceIdentifier;
    private long localIdCounter;

    protected AbstractEventProducer(SourceIdentifier sourceIdentifier, AppendOperation<EventWrapper<T>> eventQueue) {
        this.sourceIdentifier = sourceIdentifier;
        this.eventQueue = eventQueue;
        this.localIdCounter = 0L;
    }

    @Override
    public SourceIdentifier getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    protected void addEvent(T event) {
        if (event == null && this.localIdCounter == 0L) {
            return;
        }
        ++this.localIdCounter;
        EventWrapper wrapper = new EventWrapper(this.getSourceIdentifier(), this.localIdCounter, event);
        this.eventQueue.add((Object)wrapper);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Added event-wrapper for {}.", event);
        }
    }
}

