/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.engine.impl;

import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.engine.LogFileFactory;
import java.io.File;

public class LogFileFactoryImpl
implements LogFileFactory {
    private File baseDir;
    private String dataFileExtension;

    public LogFileFactoryImpl(File baseDir) {
        this.baseDir = baseDir;
        this.dataFileExtension = ".lilith";
        if (!this.dataFileExtension.startsWith(".")) {
            this.dataFileExtension = "." + this.dataFileExtension;
        }
    }

    private String getBaseFileName(SourceIdentifier si) {
        String primaryName = si.getIdentifier();
        String secondaryName = si.getSecondaryIdentifier();
        primaryName = LogFileFactoryImpl.prepareName(primaryName);
        if (secondaryName != null) {
            secondaryName = LogFileFactoryImpl.prepareName(secondaryName);
            File parent = new File(this.baseDir, primaryName);
            parent.mkdirs();
            File baseFile = new File(parent, secondaryName);
            return baseFile.getAbsolutePath();
        }
        this.baseDir.mkdirs();
        File baseFile = new File(this.baseDir, primaryName);
        return baseFile.getAbsolutePath();
    }

    private static String prepareName(String name) {
        name = name.replace(':', '_');
        name = name.replace('/', '_');
        name = name.replace('\\', '_');
        name = name.replace('#', '_');
        return name;
    }

    public File getBaseDir() {
        return this.baseDir;
    }

    public File getIndexFile(SourceIdentifier sourceIdentifier) {
        String baseName = this.getBaseFileName(sourceIdentifier);
        return new File(baseName + ".idx");
    }

    public File getDataFile(SourceIdentifier sourceIdentifier) {
        String baseName = this.getBaseFileName(sourceIdentifier);
        return new File(baseName + this.dataFileExtension);
    }

    public File getActiveFile(SourceIdentifier sourceIdentifier) {
        String baseName = this.getBaseFileName(sourceIdentifier);
        return new File(baseName + ".active");
    }

    public String getDataFileExtension() {
        return this.dataFileExtension;
    }

    public long getSizeOnDisk(SourceIdentifier sourceIdentifier) {
        File indexFile = this.getIndexFile(sourceIdentifier);
        File dataFile = this.getDataFile(sourceIdentifier);
        long indexSize = indexFile.length();
        long dataSize = dataFile.length();
        return indexSize + dataSize;
    }

    public long getNumberOfEvents(SourceIdentifier sourceIdentifier) {
        File indexFile = this.getIndexFile(sourceIdentifier);
        long indexSize = indexFile.length();
        return indexSize / 8L;
    }
}

