/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.engine.impl;

import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.lilith.engine.EventSource;
import de.huxhorn.sulky.buffers.Buffer;
import de.huxhorn.sulky.conditions.Condition;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventSourceImpl<T extends Serializable>
implements EventSource<T> {
    private SourceIdentifier sourceIdentifier;
    private Buffer<EventWrapper<T>> buffer;
    private boolean global;
    private Condition filter;

    public EventSourceImpl(SourceIdentifier sourceIdentifier, Buffer<EventWrapper<T>> buffer, boolean global) {
        this(sourceIdentifier, buffer, null, global);
    }

    public EventSourceImpl(SourceIdentifier sourceIdentifier, Buffer<EventWrapper<T>> buffer, Condition filter, boolean global) {
        this.sourceIdentifier = sourceIdentifier;
        this.buffer = buffer;
        this.filter = filter;
        this.global = global;
    }

    @Override
    public boolean isGlobal() {
        return this.global;
    }

    @Override
    public SourceIdentifier getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    @Override
    public Buffer<EventWrapper<T>> getBuffer() {
        return this.buffer;
    }

    @Override
    public Condition getFilter() {
        return this.filter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventSourceImpl that = (EventSourceImpl)o;
        if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) {
            return false;
        }
        return !(this.sourceIdentifier == null ? that.sourceIdentifier != null : !this.sourceIdentifier.equals((Object)that.sourceIdentifier));
    }

    public int hashCode() {
        int result = this.sourceIdentifier != null ? this.sourceIdentifier.hashCode() : 0;
        result = 29 * result + (this.filter != null ? this.filter.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(EventSource<T> o) {
        if (this.global) {
            if (!o.isGlobal()) {
                return -1;
            }
        } else if (o.isGlobal()) {
            return 1;
        }
        if (this.sourceIdentifier == null) {
            if (o.getSourceIdentifier() != null) {
                return -1;
            }
        } else {
            if (o.getSourceIdentifier() == null) {
                return 1;
            }
            int result = this.sourceIdentifier.compareTo(o.getSourceIdentifier());
            if (result != 0) {
                return result;
            }
        }
        if (this.filter == null) {
            if (o.getFilter() != null) {
                return 1;
            }
            return 0;
        }
        Condition otherFilter = o.getFilter();
        if (otherFilter == null) {
            return -1;
        }
        return this.filter.toString().compareTo(otherFilter.toString());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("EventSource[");
        result.append("id=").append(this.sourceIdentifier);
        result.append(", ");
        result.append("filter=").append(this.filter);
        result.append(", ");
        result.append("global=").append(this.global);
        result.append("]");
        return result.toString();
    }
}

