/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.logging.logback;

import ch.qos.logback.classic.spi.CallerData;
import ch.qos.logback.classic.spi.ClassPackagingData;
import ch.qos.logback.classic.spi.LoggerContextRemoteView;
import ch.qos.logback.classic.spi.LoggerRemoteView;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableDataPoint;
import ch.qos.logback.classic.spi.ThrowableProxy;
import de.huxhorn.lilith.data.logging.ExtendedStackTraceElement;
import de.huxhorn.lilith.data.logging.LoggerContext;
import de.huxhorn.lilith.data.logging.LoggingEvent;
import de.huxhorn.lilith.data.logging.Marker;
import de.huxhorn.lilith.data.logging.Message;
import de.huxhorn.lilith.data.logging.MessageFormatter;
import de.huxhorn.lilith.data.logging.ThreadInfo;
import de.huxhorn.lilith.data.logging.ThrowableInfo;
import de.huxhorn.lilith.logback.classic.NDC;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogbackLoggingAdapter {
    private static final String CLASSNAME_MESSAGE_SEPARATOR = ": ";
    private static final String COMMON_FRAMES_PREFIX = "\t... ";
    private static final String COMMON_FRAMES_OMITTED = " common frames omitted";
    private static final String CAUSED_BY = "Caused by: ";

    public LoggingEvent convert(ch.qos.logback.classic.spi.LoggingEvent event, boolean inSameThread) {
        if (event == null) {
            return null;
        }
        LoggingEvent result = new LoggingEvent();
        String messagePattern = event.getMessage();
        Object[] originalArguments = event.getArgumentArray();
        MessageFormatter.ArgumentResult argumentResult = MessageFormatter.evaluateArguments((String)messagePattern, (Object[])originalArguments);
        String[] arguments = null;
        if (argumentResult != null) {
            arguments = argumentResult.getArguments();
            Throwable t = argumentResult.getThrowable();
            if (t != null && event.getThrowableProxy() == null) {
                event.setThrowableProxy(new ThrowableProxy(t));
            }
        }
        if (messagePattern != null || arguments != null) {
            Message message = new Message(messagePattern, arguments);
            result.setMessage(message);
        }
        this.initThrowableFromEvent(event, result);
        this.initCallStack(event, result);
        result.setLevel(LoggingEvent.Level.valueOf((String)event.getLevel().toString()));
        LoggerRemoteView lrv = event.getLoggerRemoteView();
        LoggerContextRemoteView lcv = lrv.getLoggerContextView();
        if (lcv != null) {
            String name = lcv.getName();
            HashMap props = lcv.getPropertyMap();
            if (props != null) {
                props = new HashMap(props);
            }
            LoggerContext loggerContext = new LoggerContext();
            loggerContext.setName(name);
            loggerContext.setProperties(props);
            result.setLoggerContext(loggerContext);
        }
        result.setLogger(lrv.getName());
        this.initMarker(event, result);
        result.setMdc(event.getMDCPropertyMap());
        String threadName = event.getThreadName();
        if (threadName != null) {
            Long threadId = null;
            String threadGroupName = null;
            Long threadGroupId = null;
            if (inSameThread) {
                Thread t = Thread.currentThread();
                threadId = t.getId();
                ThreadGroup tg = t.getThreadGroup();
                if (tg != null) {
                    threadGroupName = tg.getName();
                    threadGroupId = System.identityHashCode(tg);
                }
            }
            ThreadInfo threadInfo = new ThreadInfo(threadId, threadName, threadGroupId, threadGroupName);
            result.setThreadInfo(threadInfo);
        }
        result.setTimeStamp(new Date(event.getTimeStamp()));
        if (inSameThread && !NDC.isEmpty()) {
            result.setNdc(NDC.getContextStack());
        }
        return result;
    }

    private void initThrowableFromEvent(ch.qos.logback.classic.spi.LoggingEvent src, LoggingEvent dst) {
        ThrowableProxy ti = src.getThrowableProxy();
        if (ti == null) {
            return;
        }
        ti.calculatePackagingData();
        this.initFromThrowableDataPoints(ti, dst);
    }

    private ExtendedStackTraceElement[] convert(StackTraceElement[] stackTrace) {
        if (stackTrace == null) {
            return null;
        }
        ExtendedStackTraceElement[] result = new ExtendedStackTraceElement[stackTrace.length];
        for (int i = 0; i < stackTrace.length; ++i) {
            result[i] = new ExtendedStackTraceElement(stackTrace[i]);
        }
        return result;
    }

    void initFromThrowableDataPoints(ThrowableProxy ti, LoggingEvent dst) {
        ThrowableDataPoint[] throwStrRep = ti.getThrowableDataPointArray();
        if (throwStrRep == null) {
            return;
        }
        dst.setThrowable(this.initFromThrowableDataPointsRecursive(throwStrRep, 0));
    }

    ThrowableInfo initFromThrowableDataPointsRecursive(ThrowableDataPoint[] throwStrRep, int index) {
        if (index >= throwStrRep.length) {
            return null;
        }
        ThrowableDataPoint currentDataPoint = throwStrRep[index];
        String current = currentDataPoint.toString();
        if (current.startsWith(CAUSED_BY)) {
            current = current.substring(CAUSED_BY.length());
        }
        int colonIdx = current.indexOf(CLASSNAME_MESSAGE_SEPARATOR);
        ThrowableInfo result = new ThrowableInfo();
        if (colonIdx == -1) {
            result.setName(current);
        } else {
            result.setName(current.substring(0, colonIdx));
            result.setMessage(current.substring(colonIdx + CLASSNAME_MESSAGE_SEPARATOR.length()));
        }
        ArrayList<ExtendedStackTraceElement> stackElements = new ArrayList<ExtendedStackTraceElement>();
        for (int i = ++index; i < throwStrRep.length; ++i) {
            ThrowableDataPoint dataPoint = throwStrRep[i];
            ThrowableDataPoint.ThrowableDataPointType type = dataPoint.getType();
            if (type == ThrowableDataPoint.ThrowableDataPointType.RAW) {
                String raw = throwStrRep[i].toString();
                if (raw.startsWith(CAUSED_BY)) {
                    result.setCause(this.initFromThrowableDataPointsRecursive(throwStrRep, i));
                    break;
                }
                if (raw.endsWith(COMMON_FRAMES_OMITTED)) {
                    String omittedElementsStr = raw.substring(COMMON_FRAMES_PREFIX.length(), raw.length() - COMMON_FRAMES_OMITTED.length());
                    int omittedElements = 0;
                    try {
                        omittedElements = Integer.parseInt(omittedElementsStr);
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                    result.setOmittedElements(omittedElements);
                    continue;
                }
            }
            stackElements.add(LogbackLoggingAdapter.parseStackTraceElementProxy(dataPoint.getStackTraceElementProxy()));
        }
        result.setStackTrace(stackElements.toArray(new ExtendedStackTraceElement[stackElements.size()]));
        return result;
    }

    public static ExtendedStackTraceElement parseStackTraceElementProxy(StackTraceElementProxy proxy) {
        if (proxy == null) {
            return null;
        }
        ExtendedStackTraceElement result = new ExtendedStackTraceElement();
        StackTraceElement ste = proxy.getStackTraceElement();
        result.setClassName(ste.getClassName());
        result.setMethodName(ste.getMethodName());
        result.setLineNumber(ste.getLineNumber());
        result.setFileName(ste.getFileName());
        ClassPackagingData cpd = proxy.getClassPackagingData();
        if (cpd != null) {
            result.setCodeLocation(cpd.getCodeLocation());
            result.setVersion(cpd.getVersion());
            result.setExact(cpd.isExact());
        }
        return result;
    }

    private void initCallStack(ch.qos.logback.classic.spi.LoggingEvent src, LoggingEvent dst) {
        CallerData[] cd = src.getCallerData();
        if (cd == null) {
            return;
        }
        StackTraceElement[] callStack = new StackTraceElement[cd.length];
        for (int i = 0; i < cd.length; ++i) {
            CallerData current = cd[i];
            int lineNumber = current.getLineNumber();
            if (current.isNativeMethod()) {
                lineNumber = -2;
            }
            callStack[i] = new StackTraceElement(current.getClassName(), current.getMethodName(), current.getFileName(), lineNumber);
        }
        dst.setCallStack(this.convert(callStack));
    }

    private void initMarker(ch.qos.logback.classic.spi.LoggingEvent src, LoggingEvent dst) {
        org.slf4j.Marker origMarker = src.getMarker();
        if (origMarker == null) {
            return;
        }
        HashMap<String, Marker> markers = new HashMap<String, Marker>();
        dst.setMarker(this.initMarkerRecursive(origMarker, markers));
    }

    private Marker initMarkerRecursive(org.slf4j.Marker origMarker, Map<String, Marker> markers) {
        if (origMarker == null) {
            return null;
        }
        String name = origMarker.getName();
        if (markers.containsKey(name)) {
            return markers.get(name);
        }
        Marker newMarker = new Marker(name);
        markers.put(name, newMarker);
        if (origMarker.hasReferences()) {
            for (org.slf4j.Marker current : origMarker) {
                newMarker.add(this.initMarkerRecursive(current, markers));
            }
        }
        return newMarker;
    }
}

