/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.data.access.protobuf;

import com.google.protobuf.InvalidProtocolBufferException;
import de.huxhorn.lilith.data.access.AccessEvent;
import de.huxhorn.lilith.data.access.protobuf.AccessEventProtobufDecoder;
import de.huxhorn.lilith.data.access.protobuf.generated.AccessProto;
import de.huxhorn.lilith.data.eventsource.EventIdentifier;
import de.huxhorn.lilith.data.eventsource.EventWrapper;
import de.huxhorn.lilith.data.eventsource.SourceIdentifier;
import de.huxhorn.sulky.codec.Decoder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessEventWrapperProtobufDecoder
implements Decoder<EventWrapper<AccessEvent>> {
    private boolean compressing;

    public AccessEventWrapperProtobufDecoder(boolean compressing) {
        this.compressing = compressing;
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
    }

    public EventWrapper<AccessEvent> decode(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        AccessProto.EventWrapper parsedEvent = null;
        if (!this.compressing) {
            try {
                parsedEvent = AccessProto.EventWrapper.parseFrom(bytes);
            }
            catch (InvalidProtocolBufferException e) {}
        } else {
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            try {
                GZIPInputStream gis = new GZIPInputStream(in);
                parsedEvent = AccessProto.EventWrapper.parseFrom(gis);
                gis.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return AccessEventWrapperProtobufDecoder.convert(parsedEvent);
    }

    public static EventWrapper<AccessEvent> convert(AccessProto.EventWrapper parsedEvent) {
        if (parsedEvent == null) {
            return null;
        }
        EventWrapper result = new EventWrapper();
        if (parsedEvent.hasEventIdentifier()) {
            result.setEventIdentifier(AccessEventWrapperProtobufDecoder.convert(parsedEvent.getEventIdentifier()));
        }
        if (parsedEvent.hasEvent()) {
            result.setEvent((Serializable)AccessEventProtobufDecoder.convert(parsedEvent.getEvent()));
        }
        return result;
    }

    public static EventIdentifier convert(AccessProto.EventIdentifier eventIdentifier) {
        if (eventIdentifier == null) {
            return null;
        }
        EventIdentifier result = new EventIdentifier();
        if (eventIdentifier.hasSourceIdentifier()) {
            result.setSourceIdentifier(AccessEventWrapperProtobufDecoder.convert(eventIdentifier.getSourceIdentifier()));
        }
        if (eventIdentifier.hasLocalId()) {
            result.setLocalId(eventIdentifier.getLocalId());
        }
        return result;
    }

    public static SourceIdentifier convert(AccessProto.SourceIdentifier sourceIdentifier) {
        if (sourceIdentifier == null) {
            return null;
        }
        SourceIdentifier result = new SourceIdentifier();
        if (sourceIdentifier.hasIdentifier()) {
            result.setIdentifier(sourceIdentifier.getIdentifier());
        }
        if (sourceIdentifier.hasSecondaryIdentifier()) {
            result.setSecondaryIdentifier(sourceIdentifier.getSecondaryIdentifier());
        }
        return result;
    }
}

