/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.codec.filebuffer;

import de.huxhorn.sulky.codec.Encoder;
import de.huxhorn.sulky.codec.filebuffer.MetaData;
import de.huxhorn.sulky.codec.filebuffer.generated.MetaDataProto;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataEncoder
implements Encoder<MetaData> {
    private boolean compressing;

    public MetaDataEncoder(boolean compressing) {
        this.compressing = compressing;
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
    }

    public byte[] encode(MetaData data) {
        MetaDataProto.MetaData converted = MetaDataEncoder.convert(data);
        if (converted == null) {
            return null;
        }
        if (!this.compressing) {
            return converted.toByteArray();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gos = new GZIPOutputStream(out);
            converted.writeTo(gos);
            gos.flush();
            gos.close();
            return out.toByteArray();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static MetaDataProto.MetaData convert(MetaData metaData) {
        if (metaData == null) {
            return null;
        }
        Map<String, String> data = metaData.getData();
        if (data == null || data.size() == 0) {
            return null;
        }
        MetaDataProto.MetaData.Builder builder = MetaDataProto.MetaData.newBuilder();
        for (Map.Entry<String, String> current : data.entrySet()) {
            String key = current.getKey();
            String value = current.getValue();
            if (key == null) continue;
            builder.addEntry(MetaDataProto.MapEntry.newBuilder().setKey(key).setValue(value).build());
        }
        return builder.build();
    }
}

