/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.codec.filebuffer;

import com.google.protobuf.InvalidProtocolBufferException;
import de.huxhorn.sulky.codec.Decoder;
import de.huxhorn.sulky.codec.filebuffer.MetaData;
import de.huxhorn.sulky.codec.filebuffer.generated.MetaDataProto;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataDecoder
implements Decoder<MetaData> {
    private boolean compressing;

    public MetaDataDecoder(boolean compressing) {
        this.compressing = compressing;
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
    }

    public MetaData decode(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        MetaDataProto.MetaData parsedData = null;
        if (!this.compressing) {
            try {
                parsedData = MetaDataProto.MetaData.parseFrom(bytes);
            }
            catch (InvalidProtocolBufferException e) {}
        } else {
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            try {
                GZIPInputStream gis = new GZIPInputStream(in);
                parsedData = MetaDataProto.MetaData.parseFrom(gis);
                gis.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return MetaDataDecoder.convert(parsedData);
    }

    public static MetaData convert(MetaDataProto.MetaData data) {
        if (data == null) {
            return null;
        }
        int entryCount = data.getEntryCount();
        if (entryCount == 0) {
            return null;
        }
        HashMap<String, String> dataMap = new HashMap<String, String>();
        for (int i = 0; i < entryCount; ++i) {
            MetaDataProto.MapEntry entry = data.getEntry(i);
            String key = null;
            String value = null;
            if (entry.hasKey()) {
                key = entry.getKey();
            }
            if (entry.hasValue()) {
                value = entry.getValue();
            }
            if (key == null) continue;
            dataMap.put(key, value);
        }
        return new MetaData(dataMap);
    }
}

