/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.sender;

import de.huxhorn.lilith.sender.DataOutputStreamFactory;
import de.huxhorn.sulky.io.TimeoutOutputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;

public class SocketDataOutputStreamFactory
implements DataOutputStreamFactory {
    public static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    public static final int DEFAULT_WRITE_TIMEOUT = 5000;
    private String hostName;
    private int port;
    private int connectionTimeout;
    private int writeTimeout;

    public SocketDataOutputStreamFactory(String hostName, int port) {
        this(hostName, port, 10000, 5000);
        this.hostName = hostName;
        this.port = port;
    }

    public SocketDataOutputStreamFactory(String hostName, int port, int connectionTimeout, int writeTimeout) {
        this.hostName = hostName;
        this.port = port;
        this.connectionTimeout = connectionTimeout;
        this.writeTimeout = writeTimeout;
    }

    public DataOutputStream createDataOutputStream() throws IOException {
        InetAddress address = InetAddress.getByName(this.hostName);
        Socket socket = new Socket();
        InetSocketAddress socketAddress = new InetSocketAddress(address, this.port);
        socket.connect(socketAddress, this.connectionTimeout);
        OutputStream os = socket.getOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(os);
        TimeoutOutputStream tos = new TimeoutOutputStream((OutputStream)bos, this.writeTimeout);
        return new DataOutputStream((OutputStream)tos);
    }
}

