/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.lilith.sender;

import de.huxhorn.lilith.sender.SendBytesService;
import de.huxhorn.lilith.sender.SimpleSendBytesService;
import de.huxhorn.lilith.sender.SocketDataOutputStreamFactory;
import de.huxhorn.lilith.sender.WriteByteStrategy;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiplexSendBytesService
implements SendBytesService {
    private int queueSize;
    private Set<SimpleSendBytesService> senderServices;
    private BlockingQueue<byte[]> eventBytes;
    private List<String> remoteHostsList;
    private Thread dispatcherThread;
    private String name;
    private WriteByteStrategy writeByteStrategy;
    private int port;
    private int reconnectionDelay;
    private boolean debug;

    public MultiplexSendBytesService(String name, List<String> remoteHostsList, int port, WriteByteStrategy writeByteStrategy, int reconnectionDelay, int queueSize) {
        this.name = name;
        this.queueSize = queueSize;
        this.remoteHostsList = remoteHostsList;
        this.senderServices = new HashSet<SimpleSendBytesService>();
        this.eventBytes = new ArrayBlockingQueue<byte[]>(queueSize);
        this.writeByteStrategy = writeByteStrategy;
        this.port = port;
        this.reconnectionDelay = reconnectionDelay;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public void startUp() {
        if (this.dispatcherThread == null) {
            for (String hostName : this.remoteHostsList) {
                SocketDataOutputStreamFactory dataOutputStreamFactory = new SocketDataOutputStreamFactory(hostName, this.port);
                SimpleSendBytesService service = new SimpleSendBytesService(dataOutputStreamFactory, this.writeByteStrategy, this.queueSize, this.reconnectionDelay, 100);
                service.setDebug(this.debug);
                this.senderServices.add(service);
                service.startUp();
            }
            this.dispatcherThread = new Thread((Runnable)new DispatcherRunnable(), this.name + " Dispatcher");
            this.dispatcherThread.setDaemon(true);
            this.dispatcherThread.start();
        }
    }

    @Override
    public void shutDown() {
        if (this.dispatcherThread != null) {
            this.dispatcherThread.interrupt();
            for (SimpleSendBytesService current : this.senderServices) {
                current.shutDown();
            }
            this.senderServices.clear();
            this.eventBytes.clear();
            this.dispatcherThread = null;
        }
    }

    @Override
    public void sendBytes(byte[] serialized) {
        try {
            this.eventBytes.put(serialized);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private class DispatcherRunnable
    implements Runnable {
        private DispatcherRunnable() {
        }

        public void run() {
            try {
                block2: while (true) {
                    byte[] bytes = (byte[])MultiplexSendBytesService.this.eventBytes.take();
                    Iterator i$ = MultiplexSendBytesService.this.senderServices.iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block2;
                        SimpleSendBytesService current = (SimpleSendBytesService)i$.next();
                        current.sendBytes(bytes);
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

