/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.generics.io;

import de.huxhorn.sulky.generics.io.Deserializer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableDeserializer<E extends Serializable>
implements Deserializer<E> {
    private boolean compressing;

    public SerializableDeserializer() {
        this(false);
    }

    public SerializableDeserializer(boolean compressing) {
        this.setCompressing(compressing);
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E deserialize(byte[] bytes) {
        Serializable serializable;
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = null;
        try {
            if (this.compressing) {
                GZIPInputStream gis = new GZIPInputStream(bis);
                ois = new ObjectInputStream(gis);
            } else {
                ois = new ObjectInputStream(bis);
            }
            Object result = ois.readObject();
            serializable = (Serializable)result;
        }
        catch (Throwable e) {
            try {
                E e2 = null;
                return e2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                IOUtils.closeQuietly(ois);
                IOUtils.closeQuietly((InputStream)bis);
            }
        }
        IOUtils.closeQuietly((InputStream)ois);
        IOUtils.closeQuietly((InputStream)bis);
        return (E)serializable;
    }

    public String toString() {
        return "SerializableDeserializer[compressing=" + this.compressing + "]";
    }
}

