/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.tasks;

import de.huxhorn.sulky.tasks.ProgressingCallable;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProgressingCallable<T>
implements ProgressingCallable<T> {
    private final Logger logger = LoggerFactory.getLogger(AbstractProgressingCallable.class);
    private PropertyChangeSupport changeSupport;
    private int progress = -1;
    private long numberOfSteps = 0L;
    private long currentStep;
    private long initialSleepSteps;
    private long laterSleepSteps;
    private long lastSleepStep;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();

    public AbstractProgressingCallable() {
        this(0L, 0L);
    }

    public AbstractProgressingCallable(long sleepSteps) {
        this(sleepSteps, 0L);
    }

    public AbstractProgressingCallable(long initialSleepSteps, long laterSleepSteps) {
        this.changeSupport = new PropertyChangeSupport(this);
        this.initialSleepSteps = initialSleepSteps;
        this.laterSleepSteps = laterSleepSteps;
        this.lastSleepStep = 0L;
    }

    protected void setNumberOfSteps(long numberOfSteps) {
        if (this.numberOfSteps != numberOfSteps) {
            this.numberOfSteps = numberOfSteps;
            this.calculateProgress();
        }
    }

    protected void setCurrentStep(long currentStep) throws InterruptedException {
        if (this.currentStep != currentStep) {
            this.currentStep = currentStep;
            this.calculateProgress();
            if (currentStep != 0L && this.initialSleepSteps > 0L) {
                if (this.laterSleepSteps > 0L && currentStep > this.initialSleepSteps * 5L) {
                    if (this.lastSleepStep + this.laterSleepSteps < currentStep) {
                        this.lastSleepStep = currentStep;
                        Thread.sleep(1L);
                    }
                } else if (this.lastSleepStep + this.initialSleepSteps < currentStep) {
                    this.lastSleepStep = currentStep;
                    Thread.sleep(1L);
                }
            }
        }
    }

    private void calculateProgress() {
        int newProgress = -1;
        if (this.numberOfSteps > 0L) {
            newProgress = (int)((double)this.currentStep / (double)this.numberOfSteps * 100.0);
        }
        this.setProgress(newProgress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProgress(int progress) {
        ReentrantReadWriteLock.WriteLock lock = this.rwLock.writeLock();
        lock.lock();
        try {
            if (this.progress != progress) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("New progress: {}", (Object)progress);
                }
                Integer oldValue = this.progress;
                this.progress = progress;
                Integer newValue = this.progress;
                this.changeSupport.firePropertyChange("progress", oldValue, newValue);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getProgress() {
        ReentrantReadWriteLock.ReadLock lock = this.rwLock.readLock();
        lock.lock();
        try {
            int n = this.progress;
            return n;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }
}

