/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.stax;

import de.huxhorn.sulky.stax.StaxUtilities;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndentingXMLStreamWriter
implements XMLStreamWriter {
    private final Logger logger = LoggerFactory.getLogger(IndentingXMLStreamWriter.class);
    private static final String SYSTEM_LINE_SEPARATOR = System.getProperty("line.separator");
    private XMLStreamWriter writer;
    private int indentLevel;
    private boolean wroteText;
    private final String lineSeparator;
    private final String indentString;

    public IndentingXMLStreamWriter(XMLStreamWriter writer) {
        this(writer, SYSTEM_LINE_SEPARATOR, "\t");
    }

    public IndentingXMLStreamWriter(XMLStreamWriter writer, String lineSeparator) {
        this(writer, lineSeparator, "\t");
    }

    public IndentingXMLStreamWriter(XMLStreamWriter writer, String lineSeparator, String indentString) {
        if (writer == null) {
            throw new NullPointerException("writer must not be null!");
        }
        if (lineSeparator == null) {
            throw new NullPointerException("lineSeparator must not be null!");
        }
        if (indentString == null) {
            throw new NullPointerException("indentString must not be null!");
        }
        this.writer = writer;
        this.lineSeparator = lineSeparator;
        this.indentString = indentString;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("writer-class: {}", writer.getClass());
        }
        this.indentLevel = 0;
        this.wroteText = false;
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        this.writeIndent();
        this.writer.writeStartElement(localName);
        this.increaseIndentLevel();
        this.wroteText = false;
    }

    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeIndent();
        this.writer.writeStartElement(namespaceURI, localName);
        this.increaseIndentLevel();
        this.wroteText = false;
    }

    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeIndent();
        this.writer.writeStartElement(prefix, localName, namespaceURI);
        this.increaseIndentLevel();
        this.wroteText = false;
    }

    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeIndent();
        this.writer.writeEmptyElement(namespaceURI, localName);
        this.wroteText = false;
    }

    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeIndent();
        this.writer.writeEmptyElement(prefix, localName, namespaceURI);
        this.wroteText = false;
    }

    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writeIndent();
        this.writer.writeEmptyElement(localName);
        this.wroteText = false;
    }

    private void writeIndent() throws XMLStreamException {
        StringBuilder indentStr = new StringBuilder(this.lineSeparator);
        for (int i = 0; i < this.indentLevel; ++i) {
            indentStr.append(this.indentString);
        }
        this.writer.writeCharacters(indentStr.toString());
    }

    private void increaseIndentLevel() {
        ++this.indentLevel;
    }

    private void decreaseIndentLevel() {
        --this.indentLevel;
        if (this.indentLevel < 0) {
            this.indentLevel = 0;
        }
    }

    public void writeEndElement() throws XMLStreamException {
        this.decreaseIndentLevel();
        if (!this.wroteText) {
            this.writeIndent();
            this.wroteText = false;
        }
        this.writer.writeEndElement();
        this.wroteText = false;
    }

    public void writeEndDocument() throws XMLStreamException {
        this.writer.writeEndDocument();
    }

    public void close() throws XMLStreamException {
        this.writer.close();
    }

    public void flush() throws XMLStreamException {
        this.writer.flush();
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(localName, value);
    }

    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(prefix, namespaceURI, localName, value);
    }

    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writer.writeAttribute(namespaceURI, localName, value);
    }

    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.writer.writeNamespace(prefix, namespaceURI);
    }

    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.writer.writeDefaultNamespace(namespaceURI);
    }

    public void writeComment(String data) throws XMLStreamException {
        if ((data = StaxUtilities.normalizeNewlines(data)) != null) {
            data = data.replace("\n", this.lineSeparator);
        }
        this.writer.writeComment(data);
    }

    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.writer.writeProcessingInstruction(target);
    }

    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.writer.writeProcessingInstruction(target, data);
    }

    public void writeCData(String data) throws XMLStreamException {
        if ((data = StaxUtilities.normalizeNewlines(data)) != null) {
            data = data.replace("\n", this.lineSeparator);
        }
        this.writer.writeCData(data);
        this.wroteText = true;
    }

    public void writeDTD(String dtd) throws XMLStreamException {
        this.writer.writeDTD(dtd);
    }

    public void writeEntityRef(String name) throws XMLStreamException {
        this.writer.writeEntityRef(name);
    }

    public void writeStartDocument() throws XMLStreamException {
        this.writer.writeStartDocument();
        this.wroteText = false;
    }

    public void writeStartDocument(String version) throws XMLStreamException {
        this.writer.writeStartDocument(version);
        this.wroteText = false;
    }

    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.writer.writeStartDocument(encoding, version);
        this.wroteText = false;
    }

    public void writeCharacters(String text) throws XMLStreamException {
        if ((text = StaxUtilities.normalizeNewlines(text)) != null) {
            text = text.replace("\n", this.lineSeparator);
        }
        this.writer.writeCharacters(text);
        this.wroteText = true;
    }

    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.writer.writeCharacters(text, start, len);
        this.wroteText = true;
    }

    public String getPrefix(String uri) throws XMLStreamException {
        return this.writer.getPrefix(uri);
    }

    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.writer.setPrefix(prefix, uri);
    }

    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.writer.setDefaultNamespace(uri);
    }

    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.writer.setNamespaceContext(context);
    }

    public NamespaceContext getNamespaceContext() {
        return this.writer.getNamespaceContext();
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        return this.writer.getProperty(name);
    }
}

